/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.managerAPI;

import com.sap.cms.client.connection.ICMSConnectionIdentifier;
import com.sap.cms.client.connector.CMSConnector;
import com.sap.cms.client.connector.CMSConnectorException;
import com.sap.cms.client.connector.CMSParserException;
import com.sap.cms.client.managerAPI.CMSConfigurationManagerIF;
import com.sap.cms.client.types.CmsUserPermissions;
import com.sap.cms.client.types.SystemId;
import com.sap.cms.client.types.config.CBSCompartmentObject;
import com.sap.cms.client.types.config.CMSServerObject;
import com.sap.cms.client.types.config.CompartmentObject;
import com.sap.cms.client.types.config.RTSObject;
import com.sap.cms.client.types.config.SDMServerObject;
import com.sap.cms.client.types.config.TrackConfigurationObject;
import com.sap.cms.client.types.config.TrackConnectionObject;
import com.sap.cms.util.exception.CMSUnexpectedException;
import com.sap.cms.util.exception.client.CMSClientVersionConflictException;
import com.sap.cms.util.exception.conf.CMSConfigurationException;
import com.sap.cms.util.exception.misc.CMSPermissionDeniedException;
import com.sap.cms.util.logging.CmsLogger;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import java.net.URL;
import java.security.KeyStore;
import java.util.Vector;

public class CMSConfigurationManagerAPI
implements CMSConfigurationManagerIF {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$client$managerAPI$CMSConfigurationManagerAPI == null ? (class$com$sap$cms$client$managerAPI$CMSConfigurationManagerAPI = CMSConfigurationManagerAPI.class$("com.sap.cms.client.managerAPI.CMSConfigurationManagerAPI")) : class$com$sap$cms$client$managerAPI$CMSConfigurationManagerAPI).getName());
    private static String service = "configuration";
    private CMSConnector connector;
    private long startTime;
    static /* synthetic */ Class class$com$sap$cms$client$managerAPI$CMSConfigurationManagerAPI;

    public CMSConfigurationManagerAPI(URL cmsServer) throws CMSConnectorException {
        this.connector = new CMSConnector(cmsServer.toString(), service);
    }

    public CMSConfigurationManagerAPI(String cmsServer) throws CMSConnectorException {
        this.connector = new CMSConnector(cmsServer, service);
    }

    public CMSConfigurationManagerAPI(String cmsServer, String ticket, String user, String password, KeyStore truststore) throws CMSConnectorException {
        this.connector = new CMSConnector(cmsServer, service, ticket, user, password, truststore);
    }

    public CMSConfigurationManagerAPI(ICMSConnectionIdentifier connectionIdentifier) throws CMSConnectorException {
        this.connector = new CMSConnector(service, connectionIdentifier);
    }

    public CMSConfigurationManagerAPI(IConnectionTemplate connectionTemplate) throws CMSConnectorException {
        this.connector = new CMSConnector(service, connectionTemplate);
    }

    public void startRecording(String logFile) throws CMSConnectorException {
        this.connector.startLogToFile(logFile);
    }

    public int stopRecording() {
        return this.connector.endLogToFile();
    }

    public void replay(String logFile, int lastNo) throws CMSConnectorException {
        this.connector.replayFromFile(logFile, 0, lastNo);
    }

    public void updateCMSConfiguration(CMSServerObject cmsServerObject) throws CMSConnectorException, CMSConfigurationException {
        log.entering("updateCMSConfiguration");
        this.startTime = System.currentTimeMillis();
        this.connector.encodeObject(cmsServerObject, "cmsServerObject");
        try {
            this.connector.callMethod("updateCMSConfiguration");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        log.exiting("updateCMSConfiguration", this.getRuntime());
    }

    public CMSServerObject readCMSConfiguration() throws CMSConnectorException, CMSConfigurationException {
        log.entering("readCMSConfiguration");
        this.startTime = System.currentTimeMillis();
        try {
            this.connector.callMethod("readCMSConfiguration");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        CMSServerObject cmsServerObject = (CMSServerObject)this.connector.getObject("cmsServerObject");
        log.exiting("readCMSConfiguration", this.getRuntime());
        return cmsServerObject;
    }

    public boolean isCMSConfigured() throws CMSConnectorException, CMSConfigurationException {
        log.entering("isCMSConfigured");
        this.startTime = System.currentTimeMillis();
        try {
            this.connector.callMethod("isCMSConfigured");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        Boolean isConfigured = (Boolean)this.connector.getObject("isConfigured");
        log.exiting("isCMSConfigured", this.getRuntime());
        return isConfigured;
    }

    public Vector getTracks() throws CMSConnectorException, CMSConfigurationException {
        log.entering("getTracks");
        this.startTime = System.currentTimeMillis();
        try {
            this.connector.callMethod("getTracks");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        Vector tracks = (Vector)this.connector.getObject("tracks");
        log.exiting("getTracks", this.getRuntime());
        return tracks;
    }

    public void newTrackConfiguration(TrackConfigurationObject trackConfigurationObject) throws CMSConnectorException, CMSConfigurationException {
        log.entering("newTrackConfiguration");
        this.startTime = System.currentTimeMillis();
        this.connector.encodeObject(trackConfigurationObject, "trackConfigurationObject");
        try {
            this.connector.callMethod("newTrackConfiguration");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        log.exiting("newTrackConfiguration", this.getRuntime());
    }

    public void editTrackConfiguration(TrackConfigurationObject trackConfigurationObject) throws CMSConnectorException, CMSConfigurationException {
        log.entering("editTrackConfiguration");
        this.startTime = System.currentTimeMillis();
        this.connector.encodeObject(trackConfigurationObject, "trackConfigurationObject");
        try {
            this.connector.callMethod("editTrackConfiguration");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        log.exiting("editTrackConfiguration", this.getRuntime());
    }

    public void deleteTrackConfiguration(TrackConfigurationObject trackConfigurationObject) throws CMSConnectorException, CMSConfigurationException {
        log.entering("deleteTrackConfiguration");
        this.startTime = System.currentTimeMillis();
        this.connector.encodeObject(trackConfigurationObject, "trackConfigurationObject");
        try {
            this.connector.callMethod("deleteTrackConfiguration");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        log.exiting("deleteTrackConfiguration", this.getRuntime());
    }

    public TrackConfigurationObject readTrackConfiguration(TrackConfigurationObject trackConfigurationObject) throws CMSConnectorException, CMSConfigurationException {
        log.entering("readTrackConfiguration");
        this.startTime = System.currentTimeMillis();
        this.connector.encodeObject(trackConfigurationObject, "trackConfigurationObject");
        try {
            this.connector.callMethod("readTrackConfiguration");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        TrackConfigurationObject trackConfigurationObjectResult = (TrackConfigurationObject)this.connector.getObject("trackConfigurationObjectResult");
        log.exiting("readTrackConfiguration", this.getRuntime());
        return trackConfigurationObjectResult;
    }

    public Vector readSystems(TrackConfigurationObject trackConfigurationObject) throws CMSConnectorException, CMSConfigurationException {
        log.entering("readSystems");
        this.startTime = System.currentTimeMillis();
        this.connector.encodeObject(trackConfigurationObject, "trackConfigurationObject");
        try {
            this.connector.callMethod("readSystems");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        Vector systems = (Vector)this.connector.getObject("systems");
        log.exiting("readSystems", this.getRuntime());
        return systems;
    }

    public void newTrackConnection(TrackConnectionObject trackConnectionObject, String connectionType) throws CMSConnectorException, CMSConfigurationException {
        log.entering("newTrackConnection");
        this.startTime = System.currentTimeMillis();
        this.connector.encodeObject(trackConnectionObject, "trackConnectionObject");
        try {
            this.connector.callMethod("newTrackConnection");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        log.exiting("newTrackConnection", this.getRuntime());
    }

    public void deleteTrackConnection(TrackConnectionObject trackConnectionObject, String connectionType) throws CMSConnectorException, CMSConfigurationException {
        log.entering("deleteTrackConnection");
        this.startTime = System.currentTimeMillis();
        this.connector.encodeObject(trackConnectionObject, "trackConnectionObject");
        try {
            this.connector.callMethod("deleteTrackConnection");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        log.exiting("deleteTrackConnection", this.getRuntime());
    }

    public Vector readTrackConnection(TrackConfigurationObject trackConfigurationObject, String connectionType) throws CMSConnectorException, CMSConfigurationException {
        log.entering("readTrackConnection");
        this.startTime = System.currentTimeMillis();
        this.connector.encodeObject(trackConfigurationObject, "trackConfigurationObject");
        try {
            this.connector.callMethod("readTrackConnection");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        Vector trackConnectionObjectVector = (Vector)this.connector.getObject("trackConnectionObjectVector");
        log.exiting("readTrackConnection", this.getRuntime());
        return trackConnectionObjectVector;
    }

    public void newTrackReplication(TrackConnectionObject trackConnectionObject) throws CMSConnectorException, CMSConfigurationException {
        log.entering("newTrackReplication");
        this.startTime = System.currentTimeMillis();
        this.connector.encodeObject(trackConnectionObject, "trackConnectionObject");
        try {
            this.connector.callMethod("newTrackReplication");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        log.exiting("newTrackReplication", this.getRuntime());
    }

    public void deleteTrackReplication(TrackConnectionObject trackConnectionObject) throws CMSConnectorException, CMSConfigurationException {
        log.entering("deleteTrackReplication");
        this.startTime = System.currentTimeMillis();
        this.connector.encodeObject(trackConnectionObject, "trackConnectionObject");
        try {
            this.connector.callMethod("deleteTrackReplication");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        log.exiting("deleteTrackReplication", this.getRuntime());
    }

    public Vector readTrackReplication(TrackConfigurationObject trackConfigurationObject) throws CMSConnectorException, CMSConfigurationException {
        log.entering("readTrackReplication");
        this.startTime = System.currentTimeMillis();
        this.connector.encodeObject(trackConfigurationObject, "trackConfigurationObject");
        try {
            this.connector.callMethod("readTrackReplication");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        Vector trackConnectionObjectVector = (Vector)this.connector.getObject("trackConnectionObjectVector");
        log.exiting("readTrackReplication", this.getRuntime());
        return trackConnectionObjectVector;
    }

    public Vector getAllComponents() throws CMSConnectorException, CMSConfigurationException {
        log.entering("getAllComponents");
        this.startTime = System.currentTimeMillis();
        try {
            this.connector.callMethod("getAllComponents");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        Vector allComponents = (Vector)this.connector.getObject("allComponents");
        log.exiting("getAllComponents", this.getRuntime());
        return allComponents;
    }

    public Vector getSubstitutionVariableList() throws CMSConnectorException, CMSConfigurationException {
        log.entering("getSubstitutionVariableList");
        this.startTime = System.currentTimeMillis();
        try {
            this.connector.callMethod("getSubstitutionVariableList");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        Vector substitutionVariableList = (Vector)this.connector.getObject("substitutionVariableList");
        log.exiting("getSubstitutionVariableList", this.getRuntime());
        return substitutionVariableList;
    }

    public void updateCMSServer() throws CMSConnectorException, CMSConfigurationException {
        log.entering("updateCMSServer");
        this.startTime = System.currentTimeMillis();
        try {
            this.connector.callMethod("updateCMSServer");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        log.exiting("updateCMSServer", this.getRuntime());
    }

    public RTSObject readRTSConfigurationFromSDM(SDMServerObject sdmServerObject) throws CMSConnectorException, CMSConfigurationException {
        log.entering("readRTSConfigurationFromSDM");
        this.startTime = System.currentTimeMillis();
        this.connector.encodeObject(sdmServerObject, "sdmServerObject");
        try {
            this.connector.callMethod("readRTSConfigurationFromSDM");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        RTSObject rtsObject = (RTSObject)this.connector.getObject("rtsObject");
        log.exiting("readRTSConfigurationFromSDM", this.getRuntime());
        return rtsObject;
    }

    public void writeRTSConfigurationToSDM(RTSObject rtsObject) throws CMSConnectorException, CMSConfigurationException {
        log.entering("writeRTSConfigurationFromSDM");
        this.startTime = System.currentTimeMillis();
        this.connector.encodeObject(rtsObject, "rtsObject");
        try {
            this.connector.callMethod("writeRTSConfigurationFromSDM");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        log.exiting("writeRTSConfigurationFromSDM", this.getRuntime());
    }

    public Vector getComponentReleases(CompartmentObject compartmentObject) throws CMSConnectorException, CMSConfigurationException {
        log.entering("getComponentReleases");
        this.startTime = System.currentTimeMillis();
        this.connector.encodeObject(compartmentObject, "compartmentObject");
        try {
            this.connector.callMethod("getComponentReleases");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        Vector componentReleases = (Vector)this.connector.getObject("componentReleases");
        log.exiting("getComponentReleases", this.getRuntime());
        return componentReleases;
    }

    public CBSCompartmentObject generateBuildCompartments(CBSCompartmentObject cbsCompartmentObject) throws CMSConnectorException, CMSConfigurationException {
        log.entering("generateBuildCompartments");
        this.startTime = System.currentTimeMillis();
        this.connector.encodeObject(cbsCompartmentObject, "cbsCompartmentObject");
        try {
            this.connector.callMethod("generateBuildCompartments");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        CBSCompartmentObject cbsCompartmentObjectResult = (CBSCompartmentObject)this.connector.getObject("cbsCompartmentObjectResult");
        log.exiting("generateBuildCompartments", this.getRuntime());
        return cbsCompartmentObjectResult;
    }

    public TrackConfigurationObject readCompartmentConfiguration(String fileName) throws CMSConnectorException, CMSConfigurationException {
        return null;
    }

    public void pingServersToConnect(TrackConfigurationObject trackConfigurationObject) throws CMSConnectorException, CMSConfigurationException {
        log.entering("pingServersToConnect");
        this.startTime = System.currentTimeMillis();
        this.connector.encodeObject(trackConfigurationObject, "trackConfigurationObject");
        try {
            this.connector.callMethod("pingServersToConnect");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        log.exiting("pingServersToConnect", this.getRuntime());
    }

    public void setSimulationMode(String domName, String simulationMode) throws CMSConnectorException, CMSConfigurationException {
        log.entering("setSimulationMode");
        this.startTime = System.currentTimeMillis();
        this.connector.encodeObject(domName, "domName");
        this.connector.encodeObject(simulationMode, "simulationMode");
        try {
            this.connector.callMethod("setSimulationMode");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        log.exiting("setSimulationMode", this.getRuntime());
    }

    public String getSimulationMode(String domName) throws CMSConnectorException, CMSConfigurationException {
        log.entering("getSimulationMode");
        this.startTime = System.currentTimeMillis();
        this.connector.encodeObject(domName, "domName");
        try {
            this.connector.callMethod("getSimulationMode");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        String simulationMode = (String)this.connector.getObject("simulationMode");
        log.exiting("getSimulationMode", this.getRuntime());
        return simulationMode;
    }

    public CmsUserPermissions getUserPermissions(SystemId system) {
        log.entering("getUserPermissions", new Object[]{system});
        CmsUserPermissions userPermissions = null;
        try {
            try {
                this.connector.encodeObject(system, "system");
                this.connector.callMethod("getUserPermissionsBySystem");
                userPermissions = (CmsUserPermissions)this.connector.getObject("userPermissions");
            }
            catch (CMSParserException e) {
                log.error("Error during parse of answer", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSConnectorException e) {
                log.error("Error during XML communication", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSClientVersionConflictException e) {
                throw e;
            }
            catch (CMSPermissionDeniedException e) {
                log.error("Permission denied", (Throwable)e);
                throw e;
            }
            catch (CMSUnexpectedException e) {
                log.error("Unexpected exception", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error("Unexpected exception", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            Object var10_3 = null;
        }
        catch (Throwable throwable) {
            Object var10_4 = null;
            log.exiting("getUserPermissions", userPermissions);
            throw throwable;
        }
        log.exiting("getUserPermissions", (Object)userPermissions);
        return userPermissions;
    }

    public void test() throws CMSConnectorException, CMSConfigurationException {
        log.entering("test()");
        this.startTime = System.currentTimeMillis();
        try {
            this.connector.callMethod("test1");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        log.exiting("test", this.getRuntime());
    }

    public Vector test(Vector testVectorIn) throws CMSConnectorException, CMSConfigurationException {
        log.entering("test(Vector)");
        this.startTime = System.currentTimeMillis();
        this.connector.encodeObject(testVectorIn, "testVectorIn");
        try {
            this.connector.callMethod("test2");
        }
        catch (CMSConnectorException e) {
            throw e;
        }
        catch (CMSConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("unknown exception", (Throwable)e);
            throw new CMSConnectorException("unknown exception: " + e.getMessage());
        }
        Vector test = (Vector)this.connector.getObject("test");
        log.exiting("test", this.getRuntime());
        return test;
    }

    private String getRuntime() {
        return "runtime = " + (System.currentTimeMillis() - this.startTime) + " ms";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

