/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.ideAPI;

import com.sap.cms.client.connection.ICMSConnectionIdentifier;
import com.sap.cms.client.connector.CMSConnectorException;
import com.sap.cms.client.ideAPI.CmsConfigurationIF;
import com.sap.cms.client.ideAPI.CmsException;
import com.sap.cms.client.organizerAPI.CMSTransportOrganizerAPI;
import com.sap.cms.client.organizerAPI.CMSTransportOrganizerIF;
import com.sap.cms.util.exception.CMSUnexpectedException;
import com.sap.cms.util.exception.client.CMSClientCreateAPIException;
import com.sap.cms.util.exception.client.CMSClientDTCDeletedException;
import com.sap.cms.util.exception.client.CMSClientDTCInvalidVersionException;
import com.sap.cms.util.exception.client.CMSClientDTCNotFoundException;
import com.sap.cms.util.exception.client.CMSClientVersionConflictException;
import com.sap.cms.util.exception.conf.CMSCFinderException;
import com.sap.cms.util.exception.conf.CMSConfigurationException;
import com.sap.cms.util.exception.misc.CMSPermissionDeniedException;
import com.sap.cms.util.logging.CmsLogger;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.KeyStore;
import javax.ejb.CreateException;

public class CmsConfiguration
implements CmsConfigurationIF {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$client$ideAPI$CmsConfiguration == null ? (class$com$sap$cms$client$ideAPI$CmsConfiguration = CmsConfiguration.class$("com.sap.cms.client.ideAPI.CmsConfiguration")) : class$com$sap$cms$client$ideAPI$CmsConfiguration).getName());
    private CMSTransportOrganizerIF transportOrganizer = null;
    private String user = "guest";
    static /* synthetic */ Class class$com$sap$cms$client$ideAPI$CmsConfiguration;

    public CmsConfiguration() {
    }

    CmsConfiguration(com.tssap.dtr.client.lib.protocol.URL cmsServer, String ticket, String user, String password, KeyStore truststore) {
        log.entering("CmsConfiguration", new Object[]{cmsServer, ticket, user, "***", truststore});
        try {
            try {
                this.transportOrganizer = new CMSTransportOrganizerAPI(cmsServer.toString(), ticket, user, password, truststore);
                this.user = user;
            }
            catch (CMSConnectorException ex) {
                log.error("Error during instantiation of CMSTransportOrganizerIF", (Throwable)((Object)ex));
                throw new CMSUnexpectedException((Throwable)((Object)ex));
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            log.exiting("CmsConfiguration");
            throw throwable;
        }
        log.exiting("CmsConfiguration");
    }

    CmsConfiguration(IConnectionTemplate connectionTemplate) throws CMSClientCreateAPIException {
        log.entering("CmsConfiguration", new Object[]{connectionTemplate});
        try {
            try {
                if (connectionTemplate.getSessionContext() == null) {
                    throw new CMSConnectorException("Connection template has no session context");
                }
                this.user = connectionTemplate.getSessionContext().getUser();
                this.transportOrganizer = new CMSTransportOrganizerAPI(connectionTemplate);
            }
            catch (CMSConnectorException ex) {
                log.error("Error during instantiation of CMSTransportOrganizerIF", (Throwable)((Object)ex));
                throw new CMSClientCreateAPIException((Throwable)((Object)ex));
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            log.exiting("CmsConfiguration");
            throw throwable;
        }
        log.exiting("CmsConfiguration");
    }

    CmsConfiguration(ICMSConnectionIdentifier connectionIdentifier) throws CMSClientCreateAPIException {
        log.entering("CmsConfiguration", new Object[]{connectionIdentifier});
        try {
            try {
                if (connectionIdentifier == null) {
                    throw new CMSConnectorException("Connection identifier is null");
                }
                if (connectionIdentifier.getConnectionPrincipal() == null) {
                    throw new CMSConnectorException("Connection identifier has no principal");
                }
                this.user = connectionIdentifier.getConnectionPrincipal().getUser();
                this.transportOrganizer = new CMSTransportOrganizerAPI(connectionIdentifier);
            }
            catch (CMSConnectorException ex) {
                log.error("Error during instantiation of CMSTransportOrganizerIF", (Throwable)((Object)ex));
                throw new CMSClientCreateAPIException((Throwable)((Object)ex));
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            log.exiting("CmsConfiguration");
            throw throwable;
        }
        log.exiting("CmsConfiguration");
    }

    public InputStream getConfiguration(URL cmsServer, String configurationId, String user) throws CmsException {
        ByteArrayInputStream byteArrayInputStream;
        String config;
        log.entering("getConfiguration");
        log.debug("cmsServer = " + cmsServer + "; configurationId = " + configurationId + "; user = " + user);
        try {
            CMSTransportOrganizerAPI transportOrganizer = new CMSTransportOrganizerAPI(cmsServer);
            config = transportOrganizer.getConfiguration(user, configurationId);
        }
        catch (CMSConnectorException e) {
            throw new CmsException(e.getMessage());
        }
        catch (CMSConfigurationException e) {
            throw new CmsException(e.getMessage());
        }
        catch (CMSPermissionDeniedException e) {
            throw new CmsException("You use an old version of the NetWeaver Developer Studio which does not support user authentification for CMS. The user guest has been used. User guest does not have enough access rights on CMS to read configurations. Please update your NetWeaver Developer Studio or give the guest user the appropriate CMS rights.");
        }
        catch (Throwable e) {
            throw new CmsException(e.getMessage());
        }
        log.debug("download of development configuration finished");
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        int i = 0;
        while (i < config.length()) {
            byteOut.write(config.charAt(i));
            ++i;
        }
        ByteArrayInputStream inputStream = byteArrayInputStream = new ByteArrayInputStream(byteOut.toByteArray());
        log.debug("conversion into input stream finished");
        log.exiting("getConfiguration");
        return inputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getConfiguration(URL cmsServer, String configurationId, String user, String password, KeyStore truststore) throws CMSConnectorException {
        ByteArrayInputStream byteArrayInputStream;
        log.entering("getConfiguration");
        log.debug("cmsServer = " + cmsServer + ", configurationId = " + configurationId + ", user = " + user + ", truststore = " + truststore);
        try {
            try {
                CMSTransportOrganizerAPI transportOrganizer = new CMSTransportOrganizerAPI(cmsServer.toString(), user, password, truststore);
                String config = transportOrganizer.getConfiguration(user, configurationId);
                if (config == null) {
                    log.error("Development configuration is null");
                    throw new CMSConnectorException("CMSConnectorException_NullConfiguration", new Object[]{configurationId});
                }
                log.debug("Development configuration loaded: " + config);
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                int i = 0;
                while (true) {
                    if (i >= config.length()) {
                        ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byteOut.toByteArray());
                        log.debug("Conversion into stream finished successfully");
                        byteArrayInputStream = byteArrayInputStream2;
                        Object var13_17 = null;
                        break;
                    }
                    byteOut.write(config.charAt(i));
                    ++i;
                }
            }
            catch (CMSConnectorException e) {
                throw e;
            }
            catch (CMSConfigurationException e) {
                throw e;
            }
            catch (CMSPermissionDeniedException e) {
                throw new CMSConnectorException("CMSConnectorException_PermissionDeniedGetConfiguration", new Object[]{user}, e);
            }
            catch (RemoteException e) {
                throw new CMSConnectorException(e);
            }
            catch (CreateException e) {
                throw new CMSConnectorException(e);
            }
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            log.exiting("getConfiguration");
            throw throwable;
        }
        log.exiting("getConfiguration");
        return byteArrayInputStream;
    }

    public InputStream getConfiguration(String configurationId) throws CMSClientDTCNotFoundException, CMSClientDTCDeletedException, CMSPermissionDeniedException, CMSClientVersionConflictException, CMSUnexpectedException {
        log.entering("getConfiguration", new Object[]{configurationId});
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            try {
                if (this.transportOrganizer == null) {
                    throw new CMSUnexpectedException("CmsConfiguration is not properly initialized");
                }
                if (configurationId == null) {
                    log.error("configurationId is null");
                    throw new CMSClientDTCNotFoundException(null);
                }
                String config = this.transportOrganizer.getConfiguration(this.user, configurationId);
                if (config == null) {
                    log.error("Development configuration is null");
                    throw new CMSUnexpectedException("Null configuration returned from server.");
                }
                log.debug("Development configuration loaded: " + config);
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                int i = 0;
                while (i < config.length()) {
                    byteOut.write(config.charAt(i));
                    ++i;
                }
                byteArrayInputStream = new ByteArrayInputStream(byteOut.toByteArray());
                log.debug("Conversion into stream finished successfully");
            }
            catch (CMSConnectorException e) {
                log.error("Error during XML communication", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CMSCFinderException e) {
                log.error("DTC not found", (Throwable)e);
                throw new CMSClientDTCNotFoundException((Throwable)e, configurationId);
            }
            catch (CMSClientVersionConflictException e) {
                throw e;
            }
            catch (CMSConfigurationException e) {
                log.error("DTC problem", (Throwable)e);
                throw new CMSUnexpectedException(e.getMessage());
            }
            catch (RemoteException e) {
                log.error((Throwable)e);
                throw new CMSUnexpectedException(e.getMessage());
            }
            catch (CreateException e) {
                log.error((Throwable)e);
                throw new CMSUnexpectedException(e.getMessage());
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            log.exiting("getConfiguration", byteArrayInputStream);
            throw throwable;
        }
        log.exiting("getConfiguration", (Object)byteArrayInputStream);
        return byteArrayInputStream;
    }

    public String getActualDTCVersion(String configurationId) throws CMSClientDTCNotFoundException, CMSClientDTCDeletedException, CMSPermissionDeniedException, CMSClientVersionConflictException, CMSUnexpectedException {
        log.entering("getActualDTCVersion", new Object[]{configurationId});
        String version = null;
        try {
            if (this.transportOrganizer == null) {
                throw new CMSUnexpectedException("CmsConfiguration is not properly initialized");
            }
            if (configurationId == null) {
                log.error("configurationId is null");
                throw new CMSClientDTCNotFoundException(null);
            }
            version = this.transportOrganizer.getActualDTCVersion(configurationId);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            log.exiting("getActualDTCVersion", version);
            throw throwable;
        }
        log.exiting("getActualDTCVersion", version);
        return version;
    }

    public boolean isDTCVersionActual(String configurationId, String currentDTCVersion) throws CMSClientDTCNotFoundException, CMSClientDTCInvalidVersionException, CMSClientDTCDeletedException, CMSPermissionDeniedException, CMSClientVersionConflictException, CMSUnexpectedException {
        log.entering("isDTCVersionActual", new Object[]{configurationId, currentDTCVersion});
        boolean isActual = false;
        try {
            if (this.transportOrganizer == null) {
                throw new CMSUnexpectedException("CmsConfiguration is not properly initialized");
            }
            if (configurationId == null) {
                log.error("configurationId is null");
                throw new CMSClientDTCNotFoundException(configurationId);
            }
            if (currentDTCVersion == null) {
                log.error("currentDTCVersion is null");
                throw new CMSClientDTCInvalidVersionException(configurationId, currentDTCVersion);
            }
            isActual = this.transportOrganizer.isDTCVersionActual(configurationId, currentDTCVersion);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            log.exiting("isDTCVersionActual", (Object)new Boolean(isActual));
            throw throwable;
        }
        log.exiting("isDTCVersionActual", (Object)new Boolean(isActual));
        return isActual;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

