/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.connector;

import com.sap.cms.client.connector.CMSParserException;
import com.sap.cms.util.exception.client.CMSClientWrapperException;
import com.sap.cms.util.logging.CmsLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CMSParser
extends DefaultHandler {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$client$connector$CMSParser == null ? (class$com$sap$cms$client$connector$CMSParser = CMSParser.class$("com.sap.cms.client.connector.CMSParser")) : class$com$sap$cms$client$connector$CMSParser).getName());
    private static final boolean fullTrace = true;
    private boolean endOfElement = false;
    private boolean isException = false;
    private boolean isObject = false;
    private boolean isMethod = false;
    private boolean isValue = false;
    private boolean isId = false;
    private boolean isCollection = false;
    private boolean endOfVector = false;
    private boolean endOfCollection = false;
    private boolean endOfException = true;
    private boolean exceptionRaised = false;
    private boolean encode = false;
    private String exception;
    private String message;
    private int level = 0;
    private String id = null;
    private String valueString = null;
    private Object valueObject = null;
    private String[] objectName = new String[10];
    private String[] method = new String[10];
    private String[] type = new String[10];
    private Object[] object = new Object[10];
    private Vector[] vector = new Vector[10];
    private Collection[] collection = new Collection[10];
    private int objCnt = 0;
    private String[] ids = new String[10];
    private Object[] extObjects = new Object[10];
    static /* synthetic */ Class class$com$sap$cms$client$connector$CMSParser;

    public CMSParser() {
        log.entering("CMSParser");
        log.exiting("CMSParser");
    }

    public void processingInstruction(String s1, String s2) {
        log.debug("*** processingInstruction> " + s1 + s2);
    }

    public void skippedEntity(String s1) {
        log.debug("*** skippedEntity> " + s1);
    }

    public void startPrefixMapping(String s1, String s2) {
        log.debug("*** startPrefixMapping> " + s1 + s2);
    }

    public void startElement(String s1, String s2, String elementName, Attributes att) {
        log.entering("startElement", new Object[]{s1, s2, elementName, att});
        try {
            block21: {
                try {
                    this.postProcessAfterLastCharacterChunk();
                    this.valueString = null;
                    if (elementName.equalsIgnoreCase("exception")) {
                        this.isException = true;
                        this.exceptionRaised = true;
                        this.endOfException = false;
                        break block21;
                    }
                    if (elementName.equalsIgnoreCase("object")) {
                        this.isObject = true;
                        break block21;
                    }
                    if (elementName.equalsIgnoreCase("method")) {
                        this.isMethod = true;
                        this.valueObject = null;
                        ++this.level;
                        int i = 0;
                        while (i < att.getLength()) {
                            if (att.getQName(i).equalsIgnoreCase("name")) {
                                if (att.getValue(i).substring(0, 3).equalsIgnoreCase("get")) {
                                    this.method[this.level] = "set" + att.getValue(i).substring(3);
                                } else if (att.getValue(i).substring(0, 2).equalsIgnoreCase("is")) {
                                    this.method[this.level] = "set" + att.getValue(i).substring(2);
                                }
                                log.debug("*** [" + this.level + "] method name = " + this.method[this.level]);
                            } else if (att.getQName(i).equalsIgnoreCase("type")) {
                                this.type[this.level] = att.getValue(i);
                                log.debug("*** [" + this.level + "] method type = " + this.type[this.level]);
                            }
                            ++i;
                        }
                        break block21;
                    }
                    if (elementName.equalsIgnoreCase("value")) {
                        this.isValue = true;
                        this.encode = false;
                        if (att.getLength() > 0 && att.getQName(0).equalsIgnoreCase("encode") && att.getValue(0).equalsIgnoreCase("true")) {
                            log.debug("encode = true");
                            this.encode = true;
                        }
                        break block21;
                    }
                    if (elementName.equalsIgnoreCase("vector")) {
                        this.endOfVector = false;
                        this.vector[this.level] = new Vector();
                        log.debug("*** [" + this.level + "] create vector");
                        break block21;
                    }
                    if (elementName.equalsIgnoreCase("collection")) {
                        this.isCollection = true;
                        this.endOfCollection = false;
                        this.collection[this.level] = null;
                        log.debug("*** [" + this.level + "] clear collection");
                        break block21;
                    }
                    if (elementName.equalsIgnoreCase("id")) {
                        this.isId = true;
                        break block21;
                    }
                    if (!elementName.equalsIgnoreCase("add")) break block21;
                    if (this.isCollection) {
                        log.debug("*** [" + this.level + "] add to collection");
                        this.collection[this.level].add(this.object[this.level + 1]);
                        break block21;
                    }
                    log.debug("*** [" + this.level + "] add to vector");
                    this.vector[this.level].add(this.object[this.level + 1]);
                }
                catch (SAXException ex) {
                    log.error("SAXException during parse (startElement): ", (Throwable)ex);
                    throw new RuntimeException(ex.getMessage());
                }
                catch (RuntimeException ex) {
                    log.error("RuntimeException during parse (startElement): ", (Throwable)ex);
                    throw ex;
                }
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            log.exiting("startElement");
            throw throwable;
        }
        log.exiting("startElement");
    }

    public void endElement(String s1, String s2, String elementName) throws SAXException {
        log.entering("endElement", new Object[]{s1, s2, elementName});
        try {
            block44: {
                try {
                    this.postProcessAfterLastCharacterChunk();
                    this.endOfElement = true;
                    if (elementName.equalsIgnoreCase("method")) {
                        log.debug("*** [" + this.level + "] end method tag: type = " + this.type[this.level]);
                        int i = 0;
                        while (i < this.objectName.length) {
                            if (this.objectName[i] != null || this.type[i] != null || this.method[i] != null) {
                                if (this.vector[i] == null) {
                                    log.debug("*** [" + i + "] object name=" + this.objectName[i] + " *** method=" + this.method[i] + " *** type=" + this.type[i]);
                                } else {
                                    log.debug("*** [" + i + "] object name=" + this.objectName[i] + " *** method=" + this.method[i] + " *** type=" + this.type[i] + " *** vector.size()=" + this.vector[i].size());
                                }
                            }
                            ++i;
                        }
                        if (this.type[this.level].equalsIgnoreCase("object")) {
                            log.debug("*** [" + this.level + "] " + this.objectName[this.level] + " invoke " + this.method[this.level] + " type=" + this.type[this.level] + " object=" + this.objectName[this.level + 1]);
                            try {
                                this.invokeMethod(this.object[this.level], this.objectName[this.level], this.method[this.level], this.object[this.level + 1]);
                            }
                            catch (CMSParserException e) {
                                log.error((Throwable)((Object)e));
                                throw new SAXException(e.getMessage());
                            }
                        }
                        if (this.type[this.level].equalsIgnoreCase("vector")) {
                            this.endOfVector = false;
                            log.debug("*** [" + this.level + "] " + this.objectName[this.level] + " invoke " + this.method[this.level] + " type=" + this.type[this.level] + " value=vector");
                            try {
                                this.invokeMethod(this.object[this.level], this.objectName[this.level], this.method[this.level], this.vector[this.level]);
                            }
                            catch (CMSParserException e) {
                                log.error((Throwable)((Object)e));
                                throw new SAXException(e.getMessage());
                            }
                        }
                        if (this.objectName[this.level].equalsIgnoreCase("java.lang.String") || this.objectName[this.level].equalsIgnoreCase("java.lang.Byte") || this.objectName[this.level].equalsIgnoreCase("java.lang.Long") || this.objectName[this.level].equalsIgnoreCase("java.lang.boolean")) {
                            log.debug("*** [" + this.level + "] " + this.objectName[this.level] + " set value=" + this.valueObject);
                            this.setValue(this.level, this.objectName[this.level], this.valueObject);
                        } else {
                            if (this.valueObject.toString().equalsIgnoreCase("cmsNull")) {
                                log.debug("*** [" + this.level + "] object changed from cmsNull to null");
                                this.valueObject = null;
                            }
                            log.debug("*** [" + this.level + "] " + this.objectName[this.level] + " invoke " + this.method[this.level] + " type=" + this.type[this.level] + " value=" + this.valueObject);
                            try {
                                this.invokeMethod(this.object[this.level], this.objectName[this.level], this.method[this.level], this.valueObject);
                            }
                            catch (CMSParserException e) {
                                log.error((Throwable)((Object)e));
                                throw new SAXException(e.getMessage());
                            }
                        }
                        --this.level;
                        break block44;
                    }
                    if (elementName.equalsIgnoreCase("exception")) {
                        this.endOfException = true;
                        break block44;
                    }
                    if (elementName.equalsIgnoreCase("object")) {
                        if (this.id != null) {
                            ++this.objCnt;
                            this.ids[this.objCnt] = this.id;
                            if (this.endOfVector) {
                                log.debug("*** [" + this.level + "] move vector to cache");
                                this.extObjects[this.objCnt] = this.vector[this.level];
                                this.endOfVector = false;
                            } else if (this.endOfCollection) {
                                log.debug("*** [" + this.level + "] move collection to cache");
                                this.extObjects[this.objCnt] = this.collection[this.level];
                                this.endOfCollection = false;
                            } else {
                                log.debug("*** [" + this.level + "] move object to cache");
                                this.extObjects[this.objCnt] = this.object[this.level + 1];
                            }
                            this.id = null;
                        }
                        break block44;
                    }
                    if (elementName.equalsIgnoreCase("value")) {
                        log.debug("*** [" + this.level + "] end value tag: type = " + this.type[this.level]);
                        this.isValue = false;
                        if (!this.endOfException) {
                            if (this.valueString.toString().equalsIgnoreCase("cmsNull")) {
                                log.debug("*** [" + this.level + "] value changed from cmsNull to null");
                                this.message = null;
                            } else {
                                this.message = this.valueString;
                            }
                            break block44;
                        }
                        if (this.type[this.level].equalsIgnoreCase("java.lang.String")) {
                            if (this.valueString.equalsIgnoreCase("cmsSpace")) {
                                this.valueObject = "";
                                log.debug("*** [" + this.level + "] value changed from cmsSpace to \"\"");
                            } else {
                                this.valueObject = this.encode ? this.decodeHexString(this.valueString) : this.valueString;
                            }
                            break block44;
                        }
                        if (this.type[this.level].equalsIgnoreCase("long")) {
                            this.valueObject = new Long(this.valueString);
                            break block44;
                        }
                        if (this.type[this.level].equalsIgnoreCase("byte")) {
                            this.valueObject = new Byte(this.valueString);
                            break block44;
                        }
                        if (this.type[this.level].equalsIgnoreCase("int")) {
                            this.valueObject = new Integer(this.valueString);
                            break block44;
                        }
                        if (this.type[this.level].equalsIgnoreCase("boolean")) {
                            this.valueObject = this.valueString.equalsIgnoreCase("true") ? new Boolean(true) : new Boolean(false);
                            break block44;
                        }
                        if (this.type[this.level].equalsIgnoreCase("java.lang.Character")) {
                            this.valueObject = new Character(this.valueString.charAt(0));
                            break block44;
                        }
                        if (this.type[this.level].equalsIgnoreCase("cmsType")) {
                            this.valueObject = this.encode ? this.decodeHexString(this.valueString) : this.valueString;
                            break block44;
                        }
                        log.error("unknown type " + this.type[this.level]);
                        throw new SAXException("unknown type " + this.type[this.level]);
                    }
                    if (elementName.equalsIgnoreCase("vector")) {
                        this.endOfVector = true;
                        this.type[this.level] = "vector";
                        log.debug("*** [" + this.level + "] set type to vector");
                        break block44;
                    }
                    if (elementName.equalsIgnoreCase("collection")) {
                        this.isCollection = false;
                        this.endOfCollection = true;
                        break block44;
                    }
                    if (!this.isValue) break block44;
                    if (this.valueString == null) {
                        this.valueString = "</" + elementName + ">";
                        break block44;
                    }
                    this.valueString = this.valueString + "</" + elementName + ">";
                }
                catch (SAXException ex) {
                    log.error("SAXException during parse (endElement): ", (Throwable)ex);
                    throw ex;
                }
                catch (RuntimeException ex) {
                    log.error("RuntimeException during parse (endElement): ", (Throwable)ex);
                    throw ex;
                }
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            log.exiting("endElement");
            throw throwable;
        }
        log.exiting("endElement");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void characters(char[] buf, int offset, int len) throws SAXException {
        block10: {
            CMSParser.log.entering("characters", new Object[]{buf, new Integer(offset), new Integer(len)});
            try {
                try {
                    if (this.endOfElement) {
                        this.endOfElement = false;
                        break block10;
                    }
                    while (len > 0 && (buf[offset] == '\n' || buf[offset] == '\r')) {
                        ++offset;
                        --len;
                    }
                    if (true) ** GOTO lbl22
                }
                catch (RuntimeException ex) {
                    CMSParser.log.error("RuntimeException during parse (characters): ", (Throwable)ex);
                    throw ex;
                }
            }
            catch (Throwable var5_9) {
                var6_6 = null;
                CMSParser.log.exiting("characters");
                throw var5_9;
            }
            do {
                --len;
lbl22:
                // 2 sources

            } while (len > 0 && (buf[offset + len - 1] == '\n' || buf[offset + len - 1] == '\r'));
            if (len <= 0) {
                var6_4 = null;
                CMSParser.log.exiting("characters");
                return;
            }
            s = new String(buf, offset, len);
            CMSParser.log.debug("*** [" + this.level + "] value = " + s);
            if (this.valueString == null) {
                this.valueString = s;
            } else {
                CMSParser.log.debug("valueString = " + this.valueString + " + " + s);
                this.valueString = this.valueString + s;
            }
        }
        var6_5 = null;
        CMSParser.log.exiting("characters");
    }

    public boolean isExceptionRaised() {
        log.entering("isExceptionRaised");
        log.debug("exceptionRaised = " + this.exceptionRaised);
        log.exiting("isExceptionRaised");
        return this.exceptionRaised;
    }

    public Exception getException() throws CMSParserException {
        log.entering("getException");
        if (!this.exceptionRaised) {
            log.debug("no exception raised");
            log.exiting("getException");
            return null;
        }
        log.debug("exception = " + this.exception + " message = " + this.message);
        Object o = null;
        Class<?> classRef = null;
        try {
            classRef = Class.forName(this.exception);
        }
        catch (ClassNotFoundException e) {
            log.warning("No class file found for exception '" + this.exception + "'");
            return new Exception(this.exception + ": " + this.message);
        }
        Constructor<?>[] constructors = classRef.getConstructors();
        int i = 0;
        while (i < constructors.length) {
            Constructor<?> constructor = constructors[i];
            Class<?>[] parameters = constructor.getParameterTypes();
            if (parameters.length == 1 && parameters[0].getName().equalsIgnoreCase("java.lang.String")) {
                Object[] values = new String[]{this.message};
                try {
                    o = constructor.newInstance(values);
                    log.exiting("getException");
                    return o;
                }
                catch (InstantiationException e) {
                    log.error("Exception is abstract class");
                    throw new CMSParserException(e);
                }
                catch (IllegalAccessException e) {
                    log.error("No access to constructor");
                    throw new CMSParserException(e);
                }
                catch (InvocationTargetException e) {
                    log.error("Exception during constructor call");
                    throw new CMSParserException(e);
                }
            }
            ++i;
        }
        if (this.message == null || this.message.length() == 0) {
            int i2 = 0;
            while (i2 < constructors.length) {
                Constructor<?> constructor = constructors[i2];
                Class<?>[] parameters = constructor.getParameterTypes();
                if (parameters.length == 0) {
                    try {
                        o = constructor.newInstance(null);
                        log.exiting("getException");
                        return o;
                    }
                    catch (InstantiationException e) {
                        log.error("Exception is abstract class");
                        throw new CMSParserException(e);
                    }
                    catch (IllegalAccessException e) {
                        log.error("No access to constructor");
                        throw new CMSParserException(e);
                    }
                    catch (InvocationTargetException e) {
                        log.error("Exception during constructor call");
                        throw new CMSParserException(e);
                    }
                }
                ++i2;
            }
            log.debug("No constructor with signature (java.lang.String) found for exception '" + this.exception + "'");
        }
        log.exiting("getException");
        return new CMSClientWrapperException(this.exception, this.message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getObject(String id) throws CMSParserException {
        Object object;
        log.entering("getObject", new Object[]{id});
        Object ret = null;
        try {
            int i = 1;
            while (true) {
                if (i >= this.ids.length) {
                    log.debug("object " + id + " not found");
                    throw new CMSParserException("CMSParserException_ObjectNotFound", new Object[]{id});
                }
                if (this.ids[i] != null && this.ids[i].equalsIgnoreCase(id)) {
                    object = ret = this.extObjects[i];
                    Object var6_5 = null;
                    break;
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            log.exiting("getObject", ret);
            throw throwable;
        }
        log.exiting("getObject", ret);
        return object;
    }

    private String decodeHexString(String hexString) {
        String string;
        log.entering("decodeHexString", new Object[]{hexString});
        String returnValue = null;
        try {
            log.debug("*** [" + this.level + "] value");
            StringBuffer str = new StringBuffer(hexString.length() / 3);
            StringTokenizer st = new StringTokenizer(hexString);
            while (st.hasMoreTokens()) {
                str.append((char)Integer.parseInt(st.nextToken(), 16));
            }
            string = returnValue = str.toString();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            log.exiting("decodeHexString", returnValue);
            throw throwable;
        }
        log.exiting("decodeHexString", returnValue);
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object createObject(String name) throws CMSParserException {
        Object o;
        block11: {
            Object var3_3;
            block10: {
                log.entering("createObject", new Object[]{name});
                o = null;
                try {
                    if (name.equalsIgnoreCase("java.lang.String") || name.equalsIgnoreCase("java.lang.Byte") || name.equalsIgnoreCase("java.lang.Long") || name.equalsIgnoreCase("java.lang.boolean")) {
                        var3_3 = o;
                        Object var9_6 = null;
                        break block10;
                    }
                    try {
                        Class<?> classRef = Class.forName(name);
                        Constructor<?> con = classRef.getConstructor(null);
                        if (con == null) {
                            log.error("Constructor of " + name + " is returning null");
                            throw new CMSParserException("CMSParserException_DefaultConstructorUndefined", new Object[]{name});
                        }
                        o = con.newInstance(null);
                        log.debug("object " + name + " created");
                        break block11;
                    }
                    catch (ClassNotFoundException e) {
                        log.error("Class " + name + " not found");
                        throw new CMSParserException(e);
                    }
                    catch (NoSuchMethodException e) {
                        log.error("No default constructor in class " + name);
                        throw new CMSParserException(e);
                    }
                    catch (InstantiationException e) {
                        log.error("Class " + name + " is an abstract class");
                        throw new CMSParserException(e);
                    }
                    catch (IllegalAccessException e) {
                        log.error("No access to constructor of class " + name);
                        throw new CMSParserException(e);
                    }
                    catch (InvocationTargetException e) {
                        log.error("Exception during construction of class " + name);
                        throw new CMSParserException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_8 = null;
                    log.exiting("createObject", o);
                    throw throwable;
                }
            }
            log.exiting("createObject", o);
            return var3_3;
        }
        Object var9_7 = null;
        log.exiting("createObject", o);
        return o;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void invokeMethod(Object o, String name, String method, Object value) throws CMSParserException {
        block11: {
            log.entering("invokeMethod", new Object[]{o, name, method, value});
            try {
                try {
                    Class<?> classRef = Class.forName(name);
                    Method[] objMethods = classRef.getDeclaredMethods();
                    int i = 0;
                    while (true) {
                        if (i >= objMethods.length) {
                            if (!method.startsWith("set")) {
                                log.error("Method " + method + " not found in class " + name);
                                throw new CMSParserException("CMSParserException_MethodUndefined", new Object[]{name, method});
                            }
                            log.warning("Setter method " + method + " not found in class " + name + " (value " + value + ") - skip execution - client and server seem to have different versions of this class!");
                            break block11;
                        }
                        if (objMethods[i].getName().toString().equalsIgnoreCase(method)) {
                            Object[] fields = new Object[]{value};
                            objMethods[i].invoke(o, fields);
                            log.debug("method " + method + " invoked for object " + name);
                            Object var10_12 = null;
                            break;
                        }
                        ++i;
                    }
                }
                catch (ClassNotFoundException e) {
                    log.error("Class " + name + " not found");
                    throw new CMSParserException(e);
                }
                catch (InvocationTargetException e) {
                    log.error("Exception during invocation of method " + method + " in class " + name);
                    throw new CMSParserException(e);
                }
                catch (IllegalAccessException e) {
                    log.error("No access to method " + method + " of class " + name);
                    throw new CMSParserException(e);
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                log.exiting("invokeMethod");
                throw throwable;
            }
            log.exiting("invokeMethod");
            return;
        }
        Object var10_13 = null;
        log.exiting("invokeMethod");
    }

    private void setValue(int level, String name, Object value) {
        log.entering("setValue", new Object[]{new Integer(level), name, value});
        try {
            if (name.equalsIgnoreCase("java.lang.String")) {
                if (value.toString().equalsIgnoreCase("cmsNull")) {
                    this.object[level] = null;
                    log.debug("[" + level + "] object " + name + " = null");
                } else {
                    this.object[level] = value;
                    log.debug("[" + level + "] object " + name + " = (String) " + this.object[level]);
                }
            } else if (name.equalsIgnoreCase("java.lang.Byte")) {
                this.object[level] = Byte.valueOf(value.toString());
                log.debug("[" + level + "] object " + name + " = (Byte) " + this.object[level]);
            } else if (name.equalsIgnoreCase("java.lang.Long")) {
                this.object[level] = Long.valueOf(value.toString());
                log.debug("[" + level + "] object " + name + " = (Long) " + this.object[level]);
            } else if (name.equalsIgnoreCase("java.lang.boolean")) {
                this.object[level] = value.toString().equalsIgnoreCase("true") ? new Boolean(true) : new Boolean(false);
                log.debug("[" + level + "] object " + name + " = (Boolean) " + this.object[level]);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            log.exiting("setValue");
            throw throwable;
        }
        log.exiting("setValue");
    }

    private void postProcessAfterLastCharacterChunk() throws SAXException {
        if (this.isException) {
            this.isException = false;
            this.exception = this.valueString;
        } else if (this.isObject) {
            this.isObject = false;
            log.debug("*** [" + (this.level + 1) + "] create object " + this.valueString);
            this.objectName[this.level + 1] = this.valueString;
            int i = 0;
            while (i < this.objectName.length) {
                if (this.objectName[i] != null || this.type[i] != null || this.method[i] != null) {
                    log.debug("*** [" + i + "] object name=" + this.objectName[i] + " *** method=" + this.method[i] + " *** type=" + this.type[i]);
                }
                ++i;
            }
            try {
                this.object[this.level + 1] = this.createObject(this.valueString);
            }
            catch (CMSParserException e) {
                log.error((Throwable)((Object)e));
                throw new SAXException(e.getMessage());
            }
        } else if (this.isMethod) {
            this.isMethod = false;
        } else if (this.isId) {
            this.isId = false;
            this.id = this.valueString;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

