/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.connector;

import com.sap.cms.client.connector.CMSEncoderException;
import com.sap.cms.util.exception.CMSUnexpectedException;
import com.sap.cms.util.logging.CmsLogger;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class CMSEncoder {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$client$connector$CMSEncoder == null ? (class$com$sap$cms$client$connector$CMSEncoder = CMSEncoder.class$("com.sap.cms.client.connector.CMSEncoder")) : class$com$sap$cms$client$connector$CMSEncoder).getName());
    static /* synthetic */ Class class$com$sap$cms$client$connector$CMSEncoder;

    public CMSEncoder() {
        log.entering("CMSEncoder");
        log.exiting("CMSEncoder");
    }

    public void objectToXML(Object o, PrintWriter printWriter, String id) throws CMSEncoderException {
        log.entering("objectToXML", new Object[]{o, printWriter, id});
        try {
            if (o == null) {
                log.debug("convert null to XML (id = " + id + ")");
                o = "cmsNull";
            } else {
                log.debug("convert object " + o.getClass().getName() + " to XML (id = " + id + ")");
            }
            printWriter.println("<object>" + o.getClass().getName());
            if (o.getClass().getName().equalsIgnoreCase("java.util.Vector")) {
                printWriter.println("<vector>");
                int i = 0;
                while (i < ((Vector)o).size()) {
                    this.objectToXML(((Vector)o).get(i), printWriter, null);
                    printWriter.println("<add></add>");
                    ++i;
                }
                printWriter.println("</vector>");
            } else if (o.getClass().getName().equalsIgnoreCase("java.util.Collection")) {
                printWriter.println("<collection>");
                Iterator iter = ((Collection)o).iterator();
                while (iter.hasNext()) {
                    this.objectToXML(iter.next(), printWriter, null);
                    printWriter.println("<add></add>");
                }
                printWriter.println("</collection>");
            } else if (o.getClass().getName().equalsIgnoreCase("java.lang.String") || o.getClass().getName().equalsIgnoreCase("java.lang.Byte") || o.getClass().getName().equalsIgnoreCase("java.lang.Long") || o.getClass().getName().equalsIgnoreCase("java.lang.boolean")) {
                if (o.toString().equalsIgnoreCase("")) {
                    log.debug("value changed to cmsSpace");
                    o = "cmsSpace";
                }
                printWriter.println("<method name=\"cmsSetValue\" type=\"cmsType\">");
                this.stringToXML(o.toString(), printWriter);
                printWriter.println("</method>");
            } else {
                Class<?> objClass = o.getClass();
                Method[] objMethods = objClass.getDeclaredMethods();
                int i = 0;
                while (i < objMethods.length) {
                    if (objMethods[i].getName().toString().substring(0, 3).compareTo("get") != 0 && objMethods[i].getName().toString().substring(0, 2).compareTo("is") != 0) {
                        log.debug("skip method: " + objMethods[i].getName());
                    } else {
                        if (objMethods[i].getReturnType().getName().equalsIgnoreCase("java.lang.String") || objMethods[i].getReturnType().getName().equalsIgnoreCase("java.lang.Character") || objMethods[i].getReturnType().getName().equalsIgnoreCase("long") || objMethods[i].getReturnType().getName().equalsIgnoreCase("byte") || objMethods[i].getReturnType().getName().equalsIgnoreCase("int") || objMethods[i].getReturnType().getName().equalsIgnoreCase("boolean")) {
                            log.debug("name of method: " + objMethods[i].getName());
                            try {
                                Object value = objMethods[i].invoke(o, null);
                                log.debug("> value = " + value);
                                if (value == null) {
                                    value = "cmsNull";
                                    log.debug("> value changed to cmsNull");
                                }
                                if (value.toString().equalsIgnoreCase("")) {
                                    value = "cmsSpace";
                                    log.debug("> value changed to cmsSpace");
                                }
                                printWriter.println("<method name=\"" + objMethods[i].getName() + "\"" + " type=\"" + objMethods[i].getReturnType().getName() + "\">");
                                this.stringToXML(value.toString(), printWriter);
                                printWriter.println("</method>");
                            }
                            catch (InvocationTargetException e) {
                                log.error("Exception during invocation of method " + objMethods[i].getName() + " in class " + objClass);
                                throw new CMSEncoderException(e);
                            }
                            catch (IllegalAccessException e) {
                                log.error("No access to method " + objMethods[i].getName() + " of class " + objClass);
                                throw new CMSEncoderException(e);
                            }
                        }
                        if (objMethods[i].getReturnType().getName().equalsIgnoreCase("void")) {
                            log.debug("Name of Method: " + objMethods[i].getName());
                            log.debug("> void");
                        } else {
                            log.debug("Name of Method  : " + objMethods[i].getName());
                            log.debug("Return Type     : " + objMethods[i].getReturnType());
                            log.debug("  Name          : " + objMethods[i].getReturnType().getName());
                            log.debug("  Class         : " + objMethods[i].getReturnType().getClass());
                            log.debug("Parameter Types : " + objMethods[i].getParameterTypes());
                            Class<?>[] pTypes = objMethods[i].getParameterTypes();
                            if (pTypes.length > 0) {
                                log.debug("> skip getters which need parameters");
                            } else if (objMethods[i].getName().equalsIgnoreCase("getReqId")) {
                                log.debug("> skip method " + objMethods[i].getName());
                            } else {
                                log.debug("> next object");
                                printWriter.println("<method name=\"" + objMethods[i].getName() + "\"" + " type=\"object\">");
                                try {
                                    this.objectToXML(objMethods[i].invoke(o, new Object[0]), printWriter, null);
                                }
                                catch (InvocationTargetException e) {
                                    log.error("Exception during invocation of method " + objMethods[i].getName() + " in class " + objClass);
                                    throw new CMSEncoderException(e);
                                }
                                catch (IllegalAccessException e) {
                                    log.error("No access to method " + objMethods[i].getName() + " of class " + objClass);
                                    throw new CMSEncoderException(e);
                                }
                                printWriter.println("</method>");
                            }
                        }
                    }
                    ++i;
                }
            }
            if (id != null) {
                printWriter.println("<id>" + id + "</id>");
            }
            printWriter.println("</object>");
            Object var11_15 = null;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            log.exiting("objectToXML");
            throw throwable;
        }
        log.exiting("objectToXML");
    }

    public void exceptionToXML(Throwable e, PrintWriter printWriter) {
        log.entering("exceptionToXML", new Object[]{e, printWriter});
        try {
            log.debug("convert exception " + e.getClass().getName() + " to XML");
            printWriter.println("<exception>" + e.getClass().getName());
            if (e instanceof CMSUnexpectedException && ((CMSUnexpectedException)e).getCause() != null) {
                this.stringToXML(((CMSUnexpectedException)e).getCause().getClass().getName() + ": " + e.getMessage(), printWriter);
            } else {
                this.stringToXML(e.getMessage(), printWriter);
            }
            printWriter.println("</exception>");
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            log.exiting("exceptionToXML");
            throw throwable;
        }
        log.exiting("exceptionToXML");
    }

    private void stringToXML(String s, PrintWriter printWriter) {
        log.entering("stringToXML", new Object[]{s, printWriter});
        try {
            if (s == null) {
                s = "cmsNull";
                log.debug("> value changed to cmsNull");
            }
            if (s.startsWith("<")) {
                log.debug("encode " + s + " to hex");
                printWriter.print("<value encode=\"true\">");
                int i = 0;
                while (i < s.length()) {
                    printWriter.print(Integer.toHexString(s.charAt(i)) + " ");
                    ++i;
                }
            } else {
                printWriter.print("<value encode=\"false\">");
                int i = 0;
                while (i < s.length()) {
                    switch (s.charAt(i)) {
                        case '&': {
                            printWriter.print("&amp;");
                            break;
                        }
                        case '<': {
                            printWriter.print("&lt;");
                            break;
                        }
                        case '>': {
                            printWriter.print("&gt;");
                            break;
                        }
                        case '\'': {
                            printWriter.print("&apos;");
                            break;
                        }
                        case '\"': {
                            printWriter.print("&quot;");
                            break;
                        }
                        default: {
                            printWriter.print(s.charAt(i));
                        }
                    }
                    ++i;
                }
            }
            printWriter.println("</value>");
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            log.exiting("stringToXML");
            throw throwable;
        }
        log.exiting("stringToXML");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

