/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.connector;

import com.sap.cms.client.connection.ICMSConnectionIdentifier;
import com.sap.cms.client.connector.CMSConnectorException;
import com.sap.cms.client.connector.CMSEncoder;
import com.sap.cms.client.connector.CMSParser;
import com.sap.cms.client.connector.CMSParserException;
import com.sap.cms.util.exception.client.CMSClientInternalServerException;
import com.sap.cms.util.exception.client.CMSClientWrapperException;
import com.sap.cms.util.logging.CmsLogger;
import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IAuthenticator;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.IResponseEntity;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.entities.ByteArrayEntity;
import com.tssap.dtr.client.lib.protocol.pool.OutOfConnectionsException;
import com.tssap.dtr.client.lib.protocol.requests.http.PostRequest;
import com.tssap.dtr.client.lib.protocol.session.BasicAuthenticator;
import com.tssap.dtr.client.lib.protocol.session.SSO2Authenticator;
import com.tssap.dtr.client.lib.protocol.session.SessionContext;
import com.tssap.dtr.client.lib.protocol.templates.InvalidTemplateIDException;
import com.tssap.dtr.client.lib.protocol.templates.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CMSConnector {
    private static final String ORGANIZER_URL_AUTH = "/CMS/OrganizerAuth";
    private static final String ORGANIZER_URL = "/CMS/Organizer";
    private static final String MANAGER_URL_AUTH = "/CMS/ManagerAuth";
    private static final String MANAGER_URL = "/CMS/Manager";
    private String service = null;
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$client$connector$CMSConnector == null ? (class$com$sap$cms$client$connector$CMSConnector = CMSConnector.class$("com.sap.cms.client.connector.CMSConnector")) : class$com$sap$cms$client$connector$CMSConnector).getName());
    private boolean isSecure = false;
    private URL cmsServer = null;
    private String cmsService = null;
    private boolean isSender = false;
    private boolean isReceiver = false;
    private boolean isNewCall = true;
    private boolean isFlushed = false;
    private boolean logToFile = false;
    private IConnection urlConnection;
    private PrintWriter printWriter;
    private InputStream xmlInputStream = null;
    private ByteArrayOutputStream byteOutputStream = null;
    private String xmlFile = null;
    private int fileNo = 0;
    private SAXParser saxParser;
    private CMSParser cmsParser;
    private CMSEncoder cmsEncoder = new CMSEncoder();
    private String user = "";
    private String password = "";
    private KeyStore truststore = null;
    private String url;
    private IConnectionTemplate connectionTemplate = null;
    private ICMSConnectionIdentifier connectionIdentifier = null;
    private String ticket;
    private String servletURL = null;
    static /* synthetic */ Class class$com$sap$cms$client$connector$CMSConnector;

    public CMSConnector() {
        log.entering("CMSConnector");
        this.isReceiver = true;
        log.debug("is a receiver");
        log.exiting("CMSConnector");
    }

    public CMSConnector(String url, String service) throws CMSConnectorException {
        this(url, service, null, null, null, null);
    }

    public CMSConnector(String url, String service, String user, String password, KeyStore truststore) throws CMSConnectorException {
        this(url, service, null, user, password, truststore);
    }

    public CMSConnector(String url, String service, String ticket, String user, String password, KeyStore truststore) throws CMSConnectorException {
        log.entering("CMSConnector", new Object[]{url, service, ticket, user, "***", truststore});
        try {
            try {
                this.url = url;
                this.service = service;
                this.ticket = ticket;
                this.setUser(user);
                this.setPassword(password);
                this.setTruststore(truststore);
                this.isSender = true;
                log.debug("is a sender (service = " + service + ")");
                this.servletURL = service.equalsIgnoreCase("organizer") ? ORGANIZER_URL_AUTH : MANAGER_URL_AUTH;
                this.cmsServer = new URL(url + this.servletURL);
                this.isSecure = "https".equalsIgnoreCase(this.cmsServer.getProtocol());
                if (this.isSecure) {
                    if (truststore == null) {
                        log.error("Impossible to use https without keystore");
                        throw new CMSConnectorException("CMSConnectorException_NullKeystore", null);
                    }
                    log.debug("Using secure connection");
                } else {
                    log.warning("Using insecure connection");
                }
                log.debug("cmsServer = " + this.cmsServer.toString());
                this.cmsService = service;
            }
            catch (MalformedURLException e) {
                log.error("create cms URL failed", (Throwable)e);
                throw new CMSConnectorException("CMSConnectorException_MalformedCMSURL", new Object[]{url}, e);
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            log.exiting("CMSConnector");
            throw throwable;
        }
        log.exiting("CMSConnector");
    }

    public CMSConnector(String service, IConnectionTemplate connectionTemplate) throws CMSConnectorException {
        log.entering("CMSConnector", new Object[]{service, connectionTemplate});
        try {
            try {
                this.service = service;
                this.connectionTemplate = connectionTemplate;
                this.url = connectionTemplate.getUrl();
                this.isSender = true;
                log.debug("is a sender (service = " + service + ")");
                this.servletURL = service.equalsIgnoreCase("organizer") ? ORGANIZER_URL_AUTH : MANAGER_URL_AUTH;
                this.cmsServer = new URL(this.url + this.servletURL);
                this.isSecure = "https".equalsIgnoreCase(this.cmsServer.getProtocol());
                if (this.isSecure) {
                    if (connectionTemplate.getSessionContext().certificates().getServerCertificates() == null) {
                        log.error("Impossible to use https without keystore");
                        throw new CMSConnectorException("CMSConnectorException_NullKeystore", null);
                    }
                    log.debug("Using secure connection");
                } else {
                    log.warning("Using insecure connection");
                }
                log.debug("cmsServer = " + this.cmsServer.toString());
                this.cmsService = service;
            }
            catch (MalformedURLException e) {
                log.error("create cms URL failed", (Throwable)e);
                throw new CMSConnectorException("CMSConnectorException_MalformedCMSURL", new Object[]{this.url}, e);
            }
            catch (KeyStoreException ex) {
                log.error((Throwable)ex);
                throw new CMSConnectorException("Error getting server certificates");
            }
            Object var6_3 = null;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            log.exiting("CMSConnector");
            throw throwable;
        }
        log.exiting("CMSConnector");
    }

    public CMSConnector(String service, ICMSConnectionIdentifier connectionIdentifier) throws CMSConnectorException {
        log.entering("CMSConnector", new Object[]{service, this.connectionTemplate});
        try {
            try {
                this.service = service;
                this.connectionIdentifier = connectionIdentifier;
                this.connectionTemplate = connectionIdentifier.getConnectionPool().getConnectionTemplate(connectionIdentifier.getConnectionTemplateID());
                this.url = this.connectionTemplate.getUrl();
                this.isSender = true;
                log.debug("is a sender (service = " + service + ")");
                this.servletURL = service.equalsIgnoreCase("organizer") ? ORGANIZER_URL_AUTH : MANAGER_URL_AUTH;
                this.cmsServer = new URL(this.url + this.servletURL);
                this.isSecure = "https".equalsIgnoreCase(this.cmsServer.getProtocol());
                if (this.isSecure) {
                    if (this.connectionTemplate.getSessionContext().certificates().getServerCertificates() == null) {
                        log.error("Impossible to use https without keystore");
                        throw new CMSConnectorException("CMSConnectorException_NullKeystore", null);
                    }
                    log.debug("Using secure connection");
                } else {
                    log.warning("Using insecure connection");
                }
                log.debug("cmsServer = " + this.cmsServer.toString());
                this.cmsService = service;
            }
            catch (MalformedURLException e) {
                log.error("create cms URL failed", (Throwable)e);
                throw new CMSConnectorException("CMSConnectorException_MalformedCMSURL", new Object[]{this.url}, e);
            }
            catch (KeyStoreException ex) {
                log.error((Throwable)ex);
                throw new CMSConnectorException("Error getting server certificates");
            }
            catch (InvalidTemplateIDException ex) {
                log.error((Throwable)ex);
                throw new CMSConnectorException("Invalid template ID " + connectionIdentifier.getConnectionTemplateID());
            }
            Object var7_3 = null;
        }
        catch (Throwable throwable) {
            Object var7_4 = null;
            log.exiting("CMSConnector");
            throw throwable;
        }
        log.exiting("CMSConnector");
    }

    public void startLogToFile(String file) throws CMSConnectorException {
        log.entering("startLogToFile");
        if (file == null) {
            log.error("invalid file name " + file);
            throw new CMSConnectorException("CMSConnectorException_InvalidLogFileName", new Object[]{file});
        }
        log.debug("start logging commands to " + file + "_in/out_<no>");
        this.xmlFile = file;
        this.fileNo = 0;
        this.logToFile = true;
        log.exiting("startLogToFile");
    }

    public int endLogToFile() {
        log.entering("endLogToFile");
        --this.fileNo;
        log.debug("stop logging commands to " + this.xmlFile + "_in/out_<no>; last log is " + this.fileNo);
        this.xmlFile = null;
        this.logToFile = false;
        log.exiting("endLogToFile");
        return this.fileNo;
    }

    public void replayFromFile(String file, int from, int to) throws CMSConnectorException {
        log.entering("replayFromFile");
        if (file == null) {
            log.error("invalid file name " + file);
            throw new CMSConnectorException("CMSConnectorException_InvalidLogFileName", new Object[]{file});
        }
        this.logToFile = false;
        int i = from;
        while (i < to + 1) {
            this.xmlFile = file + "_out_" + i + ".xml";
            log.info("replay command from " + this.xmlFile);
            try {
                this.callMethodfromFile(this.xmlFile);
            }
            catch (CMSConnectorException e) {
                log.error("replay " + this.xmlFile + " failed", (Throwable)((Object)e));
            }
            catch (Exception e) {
                log.error("replay " + this.xmlFile + " failed", (Throwable)e);
            }
            ++i;
        }
        this.xmlFile = null;
        log.exiting("replayFromFile");
    }

    public void callMethod(String method) throws CMSConnectorException, Exception {
        log.entering("callMethod", new Object[]{method});
        try {
            this.encodeObject(method, "cmsMethod");
            this.writeXMLFooter();
            this.flushCash();
            log.debug("Synthesize request");
            PostRequest request = new PostRequest(this.servletURL);
            ByteArrayEntity requestEntity = new ByteArrayEntity(this.byteOutputStream.toByteArray(), "text/xml");
            log.debug(this.byteOutputStream.toString());
            request.setRequestEntity((IRequestEntity)requestEntity);
            try {
                log.debug("Send request");
                request.perform(this.urlConnection);
            }
            catch (HTTPException ex) {
                log.error("Send request failed with HTTPException", (Throwable)ex);
                throw new CMSConnectorException(ex);
            }
            catch (IOException ex) {
                log.error("Send request failed with IOException", (Throwable)ex);
                throw new CMSConnectorException(ex);
            }
            log.debug("Read response");
            IResponse response = request.getResponse();
            if (response == null) {
                log.error("No response!");
                throw new CMSConnectorException("CMSConnectorException_NoResponse", null);
            }
            if (response.getStatus() == 404) {
                log.debug("Eventually there is an old server - send request again to URL without authentication");
                this.servletURL = this.service.equalsIgnoreCase("organizer") ? ORGANIZER_URL : MANAGER_URL;
                request = new PostRequest(this.servletURL);
                request.setRequestEntity((IRequestEntity)requestEntity);
                try {
                    log.debug("Send non-authenticated request");
                    request.perform(this.urlConnection);
                }
                catch (HTTPException ex) {
                    log.error("Send request failed with HTTPException", (Throwable)ex);
                    throw new CMSConnectorException(ex);
                }
                catch (IOException ex) {
                    log.error("Send request failed with IOException", (Throwable)ex);
                    throw new CMSConnectorException(ex);
                }
                log.debug("Read response");
                response = request.getResponse();
                if (response == null) {
                    log.error("No response!");
                    throw new CMSConnectorException("CMSConnectorException_NoResponse", null);
                }
            }
            log.debug("Response status: " + response.getStatusDescription());
            IResponseEntity entity = response.getEntity();
            if (ByteArrayEntity.isByteArrayEntity((IResponseEntity)entity)) {
                ByteArrayEntity bae = (ByteArrayEntity)entity;
                byte[] content = bae.getContent();
                if (response.getStatus() != 200) {
                    log.error("HTTP return code " + response.getStatus());
                    if (content == null) {
                        log.error("HTTP response: null");
                    } else {
                        log.error("HTTP response: " + new String(content));
                    }
                    throw new CMSConnectorException("CMSConnectorException_ErrorReturnCode", new Object[]{response.getStatusDescription(), this.url});
                }
                if (!"text/xml".equalsIgnoreCase(response.getContentType())) {
                    log.error("HTTP return code OK, but content type is " + response.getContentType());
                    String contentString = "null";
                    if (content == null) {
                        log.error("HTTP response: null");
                    } else {
                        contentString = new String(content);
                        log.error("HTTP response: " + contentString);
                    }
                    if (contentString.indexOf("<title>Expired Password</title>") >= 0) {
                        throw new CMSConnectorException("Your CMS password has expired.\nPlease log on to the CMS host engine, set a new one and then try again.");
                    }
                    throw new CMSConnectorException("Unexpected reponse from HTTP server:\n" + contentString);
                }
                if (content == null) {
                    throw new CMSConnectorException("HTTP response is null");
                }
                this.xmlInputStream = new ByteArrayInputStream(content);
                if (this.logToFile) {
                    String file = this.xmlFile + "_in_" + this.fileNo + ".xml";
                    try {
                        FileOutputStream fileOut = new FileOutputStream(file);
                        int readXML = this.xmlInputStream.read();
                        while (readXML != -1) {
                            fileOut.write(readXML);
                            readXML = this.xmlInputStream.read();
                        }
                        fileOut.flush();
                        this.xmlInputStream.reset();
                        ++this.fileNo;
                    }
                    catch (FileNotFoundException e) {
                        log.error("log to file failed", (Throwable)e);
                    }
                    catch (IOException e) {
                        log.error("log to file failed", (Throwable)e);
                    }
                }
                try {
                    log.debug("Parse response");
                    this.saxParser.parse(this.xmlInputStream, (DefaultHandler)this.cmsParser);
                }
                catch (SAXException e) {
                    log.error("parse XML stream failed", (Throwable)e);
                    throw new CMSConnectorException(e);
                }
                catch (IOException e) {
                    log.error("parse XML stream failed with IOException", (Throwable)e);
                    throw new CMSConnectorException(e);
                }
                this.closeConnection();
                this.isNewCall = true;
                if (this.cmsParser.isExceptionRaised()) {
                    try {
                        Exception ex = this.cmsParser.getException();
                        if (ex instanceof CMSClientWrapperException) {
                            CMSClientWrapperException cw = (CMSClientWrapperException)ex;
                            if ("com.sap.cms.util.exception.misc.PCSTransactionException".equals(cw.getNestedException())) {
                                throw new CMSClientInternalServerException(cw.getNestedException(), cw.getNestedMessage());
                            }
                            throw cw;
                        }
                        throw ex;
                    }
                    catch (CMSParserException e) {
                        log.error("Reading of exception failed", (Throwable)((Object)e));
                        throw new CMSConnectorException((Throwable)((Object)e));
                    }
                }
            } else {
                log.error("Invalid response entity: " + entity);
                throw new CMSConnectorException("CMSConnectorException_InvalidResponseEntity", new Object[]{entity});
            }
            Object var12_21 = null;
        }
        catch (Throwable throwable) {
            Object var12_22 = null;
            log.exiting("callMethod");
            throw throwable;
        }
        log.exiting("callMethod");
    }

    public void prepareOutput(OutputStream outputStream) throws UnsupportedEncodingException {
        log.entering("prepareOutput");
        try {
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                this.printWriter = new PrintWriter(outputStreamWriter);
            }
            catch (UnsupportedEncodingException e) {
                log.error("create output stream writer failed", (Throwable)e);
                throw e;
            }
            this.writeXMLHeader();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            log.exiting("prepareOutput");
            throw throwable;
        }
        log.exiting("prepareOutput");
    }

    public void parseInput(InputStream inputStream) throws CMSConnectorException {
        log.entering("parseInput");
        this.cmsParser = new CMSParser();
        try {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(inputStream, (DefaultHandler)this.cmsParser);
            }
            catch (FactoryConfigurationError e) {
                log.error("Instantiation of SAXParseFactory failed");
                throw new CMSConnectorException(e);
            }
            catch (ParserConfigurationException e) {
                log.error("Instantiation of SAXParser failed");
                throw new CMSConnectorException(e);
            }
            catch (SAXException e) {
                log.error("parse XML stream failed");
                throw new CMSConnectorException(e);
            }
            catch (IOException e) {
                log.error("parse XML stream failed (IOException)");
                throw new CMSConnectorException(e);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            log.exiting("parseInput");
            throw throwable;
        }
        log.exiting("parseInput");
    }

    public void encodeObject(Object o, String id) throws CMSConnectorException {
        log.entering("encodeObject", new Object[]{o, id});
        try {
            if (this.isSender && this.isNewCall) {
                this.isNewCall = false;
                this.createConnection();
                this.writeXMLHeader();
                this.encodeObject(this.cmsService, "cmsService");
            }
            log.debug("encode object: id = " + id);
            this.cmsEncoder.objectToXML(o, this.printWriter, id);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            log.exiting("encodeObject");
            throw throwable;
        }
        log.exiting("encodeObject");
    }

    public void encodeObject(boolean b, String id) throws CMSConnectorException {
        log.entering("encodeObject", new Object[]{new Boolean(b), id});
        try {
            if (this.isSender && this.isNewCall) {
                this.isNewCall = false;
                this.createConnection();
                this.writeXMLHeader();
                this.encodeObject(this.cmsService, "cmsService");
            }
            log.debug("encode boolean: id = " + id);
            this.cmsEncoder.objectToXML(new Boolean(b), this.printWriter, id);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            log.exiting("encodeObject");
            throw throwable;
        }
        log.exiting("encodeObject");
    }

    public void encodeException(Throwable e) throws CMSConnectorException {
        log.entering("encodeException", new Object[]{e});
        try {
            if (this.isSender && this.isNewCall) {
                this.isNewCall = false;
                this.createConnection();
                this.writeXMLHeader();
            }
            log.debug("encode exception " + e.getClass().getName() + " message = " + e.getMessage());
            this.cmsEncoder.exceptionToXML(e, this.printWriter);
            this.flush();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            log.exiting("encodeException");
            throw throwable;
        }
        log.exiting("encodeException");
    }

    public Object getObject(String id) throws CMSParserException {
        return this.cmsParser.getObject(id);
    }

    public String getService() throws CMSParserException {
        return (String)this.cmsParser.getObject("cmsService");
    }

    public String getMethod() throws CMSParserException {
        return (String)this.cmsParser.getObject("cmsMethod");
    }

    public void flush() {
        log.entering("flush");
        try {
            if (this.isFlushed) {
                log.debug("already flushed");
            } else {
                this.writeXMLFooter();
                this.isFlushed = true;
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            log.exiting("flush");
            throw throwable;
        }
        log.exiting("flush");
    }

    private void writeXMLHeader() {
        log.entering("writeXMLHeader");
        this.isFlushed = false;
        this.printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.printWriter.println("<!DOCTYPE root>");
        this.printWriter.println("<root>");
        log.exiting("writeXMLHeader");
    }

    private void writeXMLFooter() {
        log.entering("writeXMLFooter");
        this.printWriter.println("</root>");
        this.printWriter.flush();
        log.exiting("writeXMLFooter");
    }

    private void createConnection() throws CMSConnectorException {
        try {
            log.entering("createConnection");
            try {
                if (this.connectionIdentifier != null) {
                    this.urlConnection = this.connectionIdentifier.getConnectionPool().acquireConnection(this.connectionIdentifier.getConnectionTemplateID(), this.connectionIdentifier.getConnectionPrincipal());
                    ((Connection)this.urlConnection).setUrl(this.cmsServer);
                } else if (this.connectionTemplate != null) {
                    this.urlConnection = new Connection(this.connectionTemplate);
                    ((Connection)this.urlConnection).setUrl(this.cmsServer);
                } else {
                    SessionContext ctx = new SessionContext(this.user, this.password);
                    SSO2Authenticator authenticator = new SSO2Authenticator((ISessionContext)ctx, this.ticket, (IAuthenticator)new BasicAuthenticator((ISessionContext)ctx));
                    ctx.setAuthenticator((IAuthenticator)authenticator);
                    if (this.isSecure) {
                        ctx.certificates().setAuthenticateThem(true);
                        ctx.certificates().setServerCertificates(this.truststore);
                    }
                    this.urlConnection = new Connection(this.cmsServer.toString(), (ISessionContext)ctx);
                    this.urlConnection.setSocketReadTimeout(60000);
                }
            }
            catch (SecurityException e1) {
                log.error((Throwable)e1);
                throw new CMSConnectorException(e1);
            }
            catch (NumberFormatException e1) {
                log.error((Throwable)e1);
                throw new CMSConnectorException("Illegal connection property for read timeout: must be a number (milliseconds)");
            }
            catch (IllegalArgumentException e1) {
                log.error((Throwable)e1);
                throw new CMSConnectorException(e1);
            }
            catch (KeyStoreException e1) {
                log.error((Throwable)e1);
                throw new CMSConnectorException(e1);
            }
            catch (MalformedURLException e1) {
                log.error((Throwable)e1);
                throw new CMSConnectorException(e1);
            }
            catch (OutOfConnectionsException e1) {
                log.error("No connections left", (Throwable)e1);
                throw new CMSConnectorException(e1);
            }
            catch (TemplateException e1) {
                log.error("Unknown template ID" + this.connectionIdentifier.getConnectionTemplateID(), (Throwable)e1);
                throw new CMSConnectorException(e1);
            }
            catch (ClassCastException e1) {
                log.error((Throwable)e1);
                throw new CMSConnectorException("Illegal connection property for read timeout: must be a String");
            }
            try {
                this.byteOutputStream = new ByteArrayOutputStream();
                this.printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)this.byteOutputStream, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error("Unsupported encoding UTF-8");
                throw new CMSConnectorException(e);
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            SAXParserFactory factory = SAXParserFactory.newInstance();
            Thread.currentThread().setContextClassLoader(cl);
            try {
                this.saxParser = factory.newSAXParser();
            }
            catch (ParserConfigurationException e) {
                log.error("Instantiation of SAX parser failed");
                throw new CMSConnectorException(e);
            }
            catch (SAXException e) {
                log.error("Instantiation of SAX parser failed(SAXException)");
                throw new CMSConnectorException(e);
            }
            this.cmsParser = new CMSParser();
            Object var10_14 = null;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            log.exiting("createConnection");
            throw throwable;
        }
        log.exiting("createConnection");
    }

    private void flushCash() {
        log.entering("flushCash");
        try {
            String file = null;
            OutputStream fileOut = null;
            if (this.logToFile) {
                file = this.xmlFile + "_out_" + this.fileNo + ".xml";
                try {
                    fileOut = new FileOutputStream(file);
                }
                catch (FileNotFoundException e) {
                    log.error("log to file failed" + e);
                }
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.byteOutputStream.toByteArray());
            try {
                int readXML = byteArrayInputStream.read();
                while (readXML != -1) {
                    if (this.logToFile) {
                        ((FileOutputStream)fileOut).write(readXML);
                    }
                    readXML = byteArrayInputStream.read();
                }
                if (this.logToFile) {
                    fileOut.flush();
                }
                this.printWriter.flush();
            }
            catch (IOException e) {
                log.error("log to file failed" + e);
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            log.exiting("flushCash");
            throw throwable;
        }
        log.exiting("flushCash");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeConnection() {
        log.entering("closeConnection");
        try {
            try {
                if (this.xmlInputStream != null) {
                    this.xmlInputStream.close();
                }
                if (this.connectionIdentifier != null) {
                    this.connectionIdentifier.getConnectionPool().releaseConnection(this.urlConnection, false, this.connectionIdentifier.getConnectionPrincipal());
                }
                this.urlConnection.close();
            }
            catch (IOException e) {
                log.error("close input stream failed", (Throwable)e);
                Object var3_2 = null;
                this.printWriter.close();
                log.exiting("closeConnection");
                return;
            }
            Object var3_1 = null;
            this.printWriter.close();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.printWriter.close();
            log.exiting("closeConnection");
            throw throwable;
        }
        log.exiting("closeConnection");
    }

    private void callMethodfromFile(String file) throws CMSConnectorException, Exception {
        IResponseEntity entity;
        log.entering("callMethodfromFile");
        this.createConnection();
        try {
            FileInputStream fileIn = new FileInputStream(file);
            int readXML = fileIn.read();
            while (readXML != -1) {
                this.printWriter.write(readXML);
                readXML = fileIn.read();
            }
            this.printWriter.flush();
            fileIn.close();
        }
        catch (FileNotFoundException e) {
            log.error("read from file failed", (Throwable)e);
            throw new CMSConnectorException("cms_connector_xml_file_not_found", new Object[]{file});
        }
        catch (IOException e) {
            log.error("read from file failed", (Throwable)e);
            throw new CMSConnectorException(e);
        }
        log.debug("Synthesize request");
        PostRequest request = new PostRequest(ORGANIZER_URL);
        ByteArrayEntity requestEntity = new ByteArrayEntity(this.byteOutputStream.toByteArray(), "text/xml");
        log.debug(this.byteOutputStream.toString());
        request.setRequestEntity((IRequestEntity)requestEntity);
        try {
            log.debug("Send request");
            request.perform(this.urlConnection);
        }
        catch (HTTPException ex) {
            log.error((Throwable)ex);
            throw new CMSConnectorException(ex);
        }
        catch (IOException ex) {
            log.error((Throwable)ex);
            throw new CMSConnectorException(ex);
        }
        log.debug("Read response");
        IResponse response = request.getResponse();
        if (response == null) {
            log.error("No response!");
        }
        if (ByteArrayEntity.isByteArrayEntity((IResponseEntity)(entity = response.getEntity()))) {
            ByteArrayEntity bae = (ByteArrayEntity)entity;
            this.xmlInputStream = new ByteArrayInputStream(bae.getContent());
            try {
                log.debug("Parse response");
                this.saxParser.parse(this.xmlInputStream, (DefaultHandler)this.cmsParser);
            }
            catch (FactoryConfigurationError e) {
                log.error("parse XML stream failed", (Throwable)e);
                throw new CMSConnectorException(e);
            }
            catch (SAXException e) {
                log.error("parse XML stream failed", (Throwable)e);
                throw new CMSConnectorException(e);
            }
            catch (IOException e) {
                log.error("parse XML stream failed", (Throwable)e);
                throw new CMSConnectorException(e);
            }
            this.closeConnection();
            this.isNewCall = true;
            if (this.cmsParser.isExceptionRaised()) {
                try {
                    throw this.cmsParser.getException();
                }
                catch (CMSParserException e) {
                    log.error("internal CMS connector error", (Throwable)((Object)e));
                    throw new CMSConnectorException((Throwable)((Object)e));
                }
            }
        }
        log.exiting("callMethodfromFile");
    }

    public void setPassword(String string) {
        this.password = this.password != null ? string : "";
    }

    public void setTruststore(KeyStore store) {
        this.truststore = store;
    }

    public void setUser(String string) {
        this.user = this.user != null ? string : "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

