/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.connection.impl;

import com.sap.cms.client.connection.HTTPAuthenticationScheme;
import com.sap.cms.client.connection.ICMSConnectionPrincipal;
import com.sap.cms.util.logging.CmsLogger;

public class CMSConnectionPrincipal
implements ICMSConnectionPrincipal {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$client$connection$impl$CMSConnectionPrincipal == null ? (class$com$sap$cms$client$connection$impl$CMSConnectionPrincipal = CMSConnectionPrincipal.class$("com.sap.cms.client.connection.impl.CMSConnectionPrincipal")) : class$com$sap$cms$client$connection$impl$CMSConnectionPrincipal).getName());
    private final String user;
    private final String password;
    private final HTTPAuthenticationScheme authenticationScheme;
    private final String sso2Ticket;
    private final int hashCode;
    static /* synthetic */ Class class$com$sap$cms$client$connection$impl$CMSConnectionPrincipal;

    public CMSConnectionPrincipal(String user, String password) {
        this(user, password, HTTPAuthenticationScheme.BASIC_AUTHENTICATION);
    }

    public CMSConnectionPrincipal(String user, String password, HTTPAuthenticationScheme authenticationScheme) {
        log.entering("CMSConnectionPrincipal", new Object[]{user, "***", authenticationScheme});
        try {
            if (authenticationScheme == null) {
                log.error("No authentication theme given");
                throw new IllegalArgumentException("No authentication theme given");
            }
            if (authenticationScheme == HTTPAuthenticationScheme.SSO2_AUTHENTICATION) {
                log.error("No SSO2 ticket given");
                throw new IllegalArgumentException("No SSO2 ticket given");
            }
            this.user = user;
            this.password = password;
            this.authenticationScheme = authenticationScheme;
            this.sso2Ticket = null;
            this.hashCode = this.calculateHashCode();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            log.exiting("CMSConnectionPrincipal");
            throw throwable;
        }
        log.exiting("CMSConnectionPrincipal");
    }

    public CMSConnectionPrincipal(String user, String password, String sso2Ticket) {
        log.entering("CMSConnectionPrincipal", new Object[]{user, "***", sso2Ticket});
        try {
            if (sso2Ticket == null) {
                log.error("No SSO2 ticket given");
                throw new IllegalArgumentException("No SSO2 ticket given");
            }
            this.user = user;
            this.password = password;
            this.authenticationScheme = HTTPAuthenticationScheme.SSO2_AUTHENTICATION;
            this.sso2Ticket = sso2Ticket;
            this.hashCode = this.calculateHashCode();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            log.exiting("CMSConnectionPrincipal");
            throw throwable;
        }
        log.exiting("CMSConnectionPrincipal");
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public HTTPAuthenticationScheme getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public String getSso2Ticket() {
        return this.sso2Ticket;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CMSConnectionPrincipal)) {
            return false;
        }
        ICMSConnectionPrincipal prince = (ICMSConnectionPrincipal)obj;
        if (this.authenticationScheme != prince.getAuthenticationScheme()) {
            return false;
        }
        return this.equalsCheckForStrings(this.user, prince.getUser()) && this.equalsCheckForStrings(this.password, prince.getPassword()) && this.equalsCheckForStrings(this.sso2Ticket, prince.getSso2Ticket());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.user + ", " + this.authenticationScheme + ", " + this.sso2Ticket;
    }

    private boolean equalsCheckForStrings(String string1, String string2) {
        return string1 == null ? string2 == null : string1.equals(string2);
    }

    private int calculateHashCode() {
        int hash = (this.user + this.password + this.sso2Ticket + this.authenticationScheme).hashCode();
        log.debug("Hash code: " + hash);
        return hash;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

