/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.connection.impl;

import com.sap.cms.client.connection.HTTPAuthenticationScheme;
import com.sap.cms.client.connection.ICMSConnectionPool;
import com.sap.cms.client.connection.ICMSConnectionPrincipal;
import com.sap.cms.util.exception.CMSUnexpectedException;
import com.sap.cms.util.logging.CmsLogger;
import com.tssap.dtr.client.lib.protocol.IAuthenticator;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.pool.ConnectionPool;
import com.tssap.dtr.client.lib.protocol.pool.IConnectionPool;
import com.tssap.dtr.client.lib.protocol.pool.OutOfConnectionsException;
import com.tssap.dtr.client.lib.protocol.pool.SynchronizedConnectionPool;
import com.tssap.dtr.client.lib.protocol.session.BasicAuthenticator;
import com.tssap.dtr.client.lib.protocol.session.Cookie;
import com.tssap.dtr.client.lib.protocol.session.DigestAuthenticator;
import com.tssap.dtr.client.lib.protocol.session.SSO2Authenticator;
import com.tssap.dtr.client.lib.protocol.templates.ITemplateProvider;
import com.tssap.dtr.client.lib.protocol.templates.InvalidTemplateIDException;
import com.tssap.dtr.client.lib.protocol.templates.TemplateException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CMSConnectionPool
implements ICMSConnectionPool {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$client$connection$impl$CMSConnectionPool == null ? (class$com$sap$cms$client$connection$impl$CMSConnectionPool = CMSConnectionPool.class$("com.sap.cms.client.connection.impl.CMSConnectionPool")) : class$com$sap$cms$client$connection$impl$CMSConnectionPool).getName());
    private final String name;
    private final ConnectionPool innerPool;
    private final SynchronizedConnectionPool syncPool;
    private final List connectionTemplates = new ArrayList();
    private final Map principalToCookies = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$com$sap$cms$client$connection$impl$CMSConnectionPool;

    public CMSConnectionPool(String name) {
        log.entering("CMSConnectionPool", new Object[]{name});
        this.name = name;
        this.innerPool = new ConnectionPool((ITemplateProvider)this);
        this.syncPool = new SynchronizedConnectionPool((IConnectionPool)this.innerPool);
        log.exiting("CMSConnectionPool");
    }

    public IConnection acquireConnection(int templateID) throws OutOfConnectionsException, TemplateException {
        log.entering("acquireConnection", new Object[]{new Integer(templateID)});
        IConnection connection = null;
        try {
            connection = this.syncPool.acquireConnection(templateID);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            log.exiting("acquireConnection", (Object)connection);
            throw throwable;
        }
        log.exiting("acquireConnection", (Object)connection);
        return connection;
    }

    public IConnection acquireConnection(int templateID, ICMSConnectionPrincipal principal) throws OutOfConnectionsException, TemplateException {
        log.entering("acquireConnection", new Object[]{new Integer(templateID), principal});
        IConnection connection = null;
        try {
            try {
                DigestAuthenticator auth;
                HTTPAuthenticationScheme scheme;
                connection = this.syncPool.acquireConnection(templateID);
                ISessionContext sContext = connection.getSessionContext();
                sContext.setUser(principal.getUser());
                sContext.setPassword(principal.getPassword());
                List allCookies = (List)this.principalToCookies.get(principal);
                if (allCookies != null && allCookies.size() > 0) {
                    Iterator cookieIter = allCookies.iterator();
                    while (cookieIter.hasNext()) {
                        Cookie element = (Cookie)cookieIter.next();
                        sContext.cookies().setCookie(element);
                    }
                }
                if ((scheme = principal.getAuthenticationScheme()) == HTTPAuthenticationScheme.SSO2_AUTHENTICATION) {
                    auth = new SSO2Authenticator(sContext, principal.getSso2Ticket(), (IAuthenticator)new BasicAuthenticator(sContext));
                } else if (scheme == HTTPAuthenticationScheme.DIGEST_AUTHENTICATION) {
                    auth = new DigestAuthenticator(sContext);
                } else if (scheme == HTTPAuthenticationScheme.BASIC_AUTHENTICATION) {
                    auth = new BasicAuthenticator(sContext);
                } else {
                    throw new CMSUnexpectedException("Unknown authentication scheme: " + scheme);
                }
                sContext.setAuthenticator((IAuthenticator)auth);
            }
            catch (OutOfConnectionsException ex) {
                log.error("No connections left", (Throwable)ex);
                throw ex;
            }
            catch (TemplateException ex) {
                log.error("Unknown template", (Throwable)ex);
                throw ex;
            }
            catch (RuntimeException ex) {
                log.error("Unexpected exception", (Throwable)ex);
                throw ex;
            }
            Object var9_11 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            log.exiting("acquireConnection", (Object)connection);
            throw throwable;
        }
        log.exiting("acquireConnection", (Object)connection);
        return connection;
    }

    public void releaseConnection(IConnection connection, boolean closeConnection) {
        log.entering("releaseConnection", new Object[]{connection, new Boolean(closeConnection)});
        try {
            try {
                connection.getSessionContext().cookies().removeAll();
                this.syncPool.releaseConnection(connection, closeConnection);
            }
            catch (RuntimeException ex) {
                log.error("Unexpected exception", (Throwable)ex);
                throw ex;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            log.exiting("releaseConnection");
            throw throwable;
        }
        log.exiting("releaseConnection");
    }

    public void releaseConnection(IConnection connection, boolean closeConnection, ICMSConnectionPrincipal connPrincipal) {
        log.entering("releaseConnection", new Object[]{connection, new Boolean(closeConnection), connPrincipal});
        try {
            try {
                ISessionContext sContext = connection.getSessionContext();
                List allCookies = sContext.cookies().getCookies();
                this.principalToCookies.put(connPrincipal, allCookies);
                this.releaseConnection(connection, closeConnection);
            }
            catch (RuntimeException ex) {
                log.error("Unexpected exception", (Throwable)ex);
                throw ex;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            log.exiting("releaseConnection");
            throw throwable;
        }
        log.exiting("releaseConnection");
    }

    public int addConnectionTemplate(IConnectionTemplate connectionTemplate) {
        log.entering("addConnectionTemplate", new Object[]{connectionTemplate});
        int templateID = -1;
        try {
            List list = this.connectionTemplates;
            synchronized (list) {
                this.connectionTemplates.add(connectionTemplate);
                templateID = this.connectionTemplates.size() - 1;
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            log.exiting("addConnectionTemplate", (Object)new Integer(templateID));
            throw throwable;
        }
        log.exiting("addConnectionTemplate", (Object)new Integer(templateID));
        return templateID;
    }

    public IConnectionTemplate getConnectionTemplate(int templateID) throws InvalidTemplateIDException {
        log.entering("getConnectionTemplate", new Object[]{new Integer(templateID)});
        IConnectionTemplate template = null;
        try {
            try {
                if (templateID < 0 || templateID >= this.connectionTemplates.size()) {
                    throw new InvalidTemplateIDException("Invalid template id");
                }
                template = (IConnectionTemplate)this.connectionTemplates.get(templateID);
            }
            catch (RuntimeException ex) {
                log.error("Unexpected exception", (Throwable)ex);
                throw ex;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            log.exiting("getConnectionTemplate", template);
            throw throwable;
        }
        log.exiting("getConnectionTemplate", (Object)template);
        return template;
    }

    public int[] searchTemplate(String url) throws MalformedURLException {
        log.entering("searchTemplate", new Object[]{url});
        int[] result = null;
        try {
            block10: {
                try {
                    URL theURL = new URL(url);
                    int count = 0;
                    int numberTemplates = this.connectionTemplates.size();
                    BitSet resultSet = new BitSet(numberTemplates);
                    int i = 0;
                    while (i < numberTemplates) {
                        IConnectionTemplate template = (IConnectionTemplate)this.connectionTemplates.get(i);
                        if (theURL.getHost().equals(template.getHost()) && theURL.getPort() == template.getPort() && theURL.getProtocol().equals(template.getProtocol().toString()) && theURL.getPath().startsWith(template.getBasePath())) {
                            resultSet.set(i);
                            ++count;
                        }
                        ++i;
                    }
                    result = new int[count];
                    if (count == 1) {
                        result[0] = resultSet.length() - 1;
                        break block10;
                    }
                    if (count <= 1) break block10;
                    int i2 = 0;
                    int j = 0;
                    while (i2 < numberTemplates) {
                        if (resultSet.get(i2)) {
                            result[j++] = i2;
                        }
                        ++i2;
                    }
                }
                catch (MalformedURLException ex) {
                    log.error("Malformed URL: " + url, (Throwable)ex);
                    throw ex;
                }
                catch (RuntimeException ex) {
                    log.error("Unexpected exception", (Throwable)ex);
                    throw ex;
                }
            }
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            log.exiting("searchTemplate", result);
            throw throwable;
        }
        log.exiting("searchTemplate", (Object)result);
        return result;
    }

    public List listConnectionTemplates() {
        return Collections.unmodifiableList(this.connectionTemplates);
    }

    public void setOverallLimit(int limit) {
        log.entering("setOverallLimit", new Object[]{new Integer(limit)});
        try {
            this.innerPool.setOverallLimit(limit);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            log.exiting("setOverallLimit");
            throw throwable;
        }
        log.exiting("setOverallLimit");
    }

    public int getOverallLimit() {
        return this.innerPool.getOverallLimit();
    }

    public void setDefaultLimit(int limit) {
        log.entering("setDefaultLimit", new Object[]{new Integer(limit)});
        try {
            this.innerPool.setDefaultLimit(limit);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            log.exiting("setDefaultLimit");
            throw throwable;
        }
        log.exiting("setDefaultLimit");
    }

    public int getDefaultLimit() {
        return this.innerPool.getDefaultLimit();
    }

    public int getSize() {
        return this.innerPool.getSize();
    }

    public int getSize(int templateID) {
        return this.innerPool.getSize(templateID);
    }

    public int countUsed(int templateID) throws InvalidTemplateIDException {
        return this.innerPool.countUsed(templateID);
    }

    public int countFree(int templateID) throws InvalidTemplateIDException {
        return this.innerPool.countFree(templateID);
    }

    public String toString() {
        return this.name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

