/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.connection;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HTTPAuthenticationScheme {
    private static final Map NAME_TO_SCHEME = new HashMap();
    public static final HTTPAuthenticationScheme BASIC_AUTHENTICATION = new HTTPAuthenticationScheme("basic");
    public static final HTTPAuthenticationScheme DIGEST_AUTHENTICATION = new HTTPAuthenticationScheme("digest");
    public static final HTTPAuthenticationScheme SSO2_AUTHENTICATION = new HTTPAuthenticationScheme("sso2");
    private final String schemeName;

    protected HTTPAuthenticationScheme(String name) {
        this.schemeName = name;
        NAME_TO_SCHEME.put(this.schemeName, this);
    }

    public String toString() {
        return this.schemeName;
    }

    public static HTTPAuthenticationScheme getScheme(String schemeName) {
        return (HTTPAuthenticationScheme)NAME_TO_SCHEME.get(schemeName);
    }

    public static Map listSchemes() {
        return Collections.unmodifiableMap(NAME_TO_SCHEME);
    }
}

