/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.config.impl;

import com.sap.cms.client.config.ConfigurationAPI;
import com.sap.cms.client.connection.ICMSConnectionIdentifier;
import com.sap.cms.client.connector.CMSConnectorException;
import com.sap.cms.client.managerAPI.CMSConfigurationManagerAPI;
import com.sap.cms.client.managerAPI.CMSConfigurationManagerIF;
import com.sap.cms.client.types.config.CMSDomain;
import com.sap.cms.client.types.config.CMSDomainObject;
import com.sap.cms.client.types.config.CMSServer;
import com.sap.cms.client.types.config.CMSServerObject;
import com.sap.cms.client.types.config.CMSSoftwareComponentVersion;
import com.sap.cms.client.types.config.CMSSystem;
import com.sap.cms.client.types.config.CMSSystemObject;
import com.sap.cms.client.types.config.CMSSystemRole;
import com.sap.cms.client.types.config.CMSTrack;
import com.sap.cms.client.types.config.CMSTrackConfiguration;
import com.sap.cms.client.types.config.CompartmentObject;
import com.sap.cms.client.types.config.TrackConfigurationObject;
import com.sap.cms.client.types.config.TrackObject;
import com.sap.cms.util.exception.CMSUnexpectedException;
import com.sap.cms.util.exception.client.CMSClientTrackNotFoundException;
import com.sap.cms.util.exception.client.CMSClientVersionConflictException;
import com.sap.cms.util.exception.conf.CMSCExtValidateException;
import com.sap.cms.util.exception.conf.CMSCValidateException;
import com.sap.cms.util.exception.conf.CMSConfigurationException;
import com.sap.cms.util.exception.misc.CMSPermissionDeniedException;
import com.sap.cms.util.logging.CmsLogger;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.ejb.CreateException;

public class ConfigurationAPIConnector
implements ConfigurationAPI {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$client$config$impl$ConfigurationAPIConnector == null ? (class$com$sap$cms$client$config$impl$ConfigurationAPIConnector = ConfigurationAPIConnector.class$("com.sap.cms.client.config.impl.ConfigurationAPIConnector")) : class$com$sap$cms$client$config$impl$ConfigurationAPIConnector).getName());
    private CMSConfigurationManagerIF configurationManagerAPI = null;
    static /* synthetic */ Class class$com$sap$cms$client$config$impl$ConfigurationAPIConnector;

    public ConfigurationAPIConnector(IConnectionTemplate connectionTemplate) throws CMSConnectorException {
        log.entering("ConfigurationAPIConnector", new Object[]{connectionTemplate});
        try {
            this.configurationManagerAPI = new CMSConfigurationManagerAPI(connectionTemplate);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            log.exiting("ConfigurationAPIConnector");
            throw throwable;
        }
        log.exiting("ConfigurationAPIConnector");
    }

    public ConfigurationAPIConnector(ICMSConnectionIdentifier connectionIdentifier) throws CMSConnectorException {
        log.entering("ConfigurationAPIConnector", new Object[]{connectionIdentifier});
        try {
            this.configurationManagerAPI = new CMSConfigurationManagerAPI(connectionIdentifier);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            log.exiting("ConfigurationAPIConnector");
            throw throwable;
        }
        log.exiting("ConfigurationAPIConnector");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CMSServer getServerInformation() throws CMSPermissionDeniedException, CMSClientVersionConflictException, CMSUnexpectedException {
        CMSServer cMSServer;
        CMSServer returnValue;
        block9: {
            CMSServer cMSServer2;
            block8: {
                log.entering("getServerInformation", null);
                returnValue = null;
                try {
                    try {
                        CMSServerObject server = this.configurationManagerAPI.readCMSConfiguration();
                        if (server == null) {
                            log.warning("Server is null");
                            cMSServer2 = null;
                            Object var7_7 = null;
                            break block8;
                        }
                        returnValue = new CMSServer();
                        returnValue.setId(server.getCmsName());
                        returnValue.setName(server.getCmsCaption());
                        returnValue.setDescription(server.getCmsDescription());
                        returnValue.setCmsURL(server.getCmsURL());
                        cMSServer = returnValue;
                        break block9;
                    }
                    catch (CMSConfigurationException e) {
                        log.error("Error reading from CMS", (Throwable)e);
                        throw new CMSUnexpectedException((Throwable)e);
                    }
                    catch (CMSConnectorException e) {
                        log.error("Communication error reading from CMS", (Throwable)((Object)e));
                        throw new CMSUnexpectedException((Throwable)((Object)e));
                    }
                    catch (CreateException e) {
                        Object var7_9 = null;
                        log.exiting("getServerInformation", returnValue);
                        return returnValue;
                    }
                    catch (RemoteException e) {
                        Object var7_10 = null;
                        log.exiting("getServerInformation", returnValue);
                        return returnValue;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    log.exiting("getServerInformation", returnValue);
                    throw throwable;
                }
            }
            log.exiting("getServerInformation", (Object)returnValue);
            return cMSServer2;
        }
        Object var7_8 = null;
        log.exiting("getServerInformation", (Object)returnValue);
        return cMSServer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CMSDomain[] getDomains() throws CMSPermissionDeniedException, CMSClientVersionConflictException, CMSUnexpectedException {
        CMSDomain[] cMSDomainArray;
        CMSDomain[] returnValues;
        block11: {
            CMSDomain[] cMSDomainArray2;
            block10: {
                log.entering("getDomains", null);
                returnValues = null;
                try {
                    try {
                        Vector domains = this.configurationManagerAPI.readCMSConfiguration().getDomainVector();
                        if (domains == null) {
                            log.warning("No domains found");
                            cMSDomainArray2 = null;
                            Object var8_7 = null;
                            break block10;
                        }
                        Iterator iter = domains.iterator();
                        returnValues = new CMSDomain[domains.size()];
                        int counter = 0;
                        while (true) {
                            if (!iter.hasNext()) {
                                cMSDomainArray = returnValues;
                                break block11;
                            }
                            CMSDomainObject domain = (CMSDomainObject)iter.next();
                            returnValues[counter] = new CMSDomain(domain.getName(), domain.getCaption(), domain.getDescription());
                            ++counter;
                        }
                    }
                    catch (CMSConfigurationException e) {
                        log.error("Error reading from CMS", (Throwable)e);
                        throw new CMSUnexpectedException((Throwable)e);
                    }
                    catch (CMSConnectorException e) {
                        log.error("Communication error reading from CMS", (Throwable)((Object)e));
                        throw new CMSUnexpectedException((Throwable)((Object)e));
                    }
                    catch (CreateException e) {
                        Object var8_9 = null;
                        log.exiting("getDomains", returnValues);
                        return returnValues;
                    }
                    catch (RemoteException e) {
                        Object var8_10 = null;
                        log.exiting("getDomains", returnValues);
                        return returnValues;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    log.exiting("getDomains", returnValues);
                    throw throwable;
                }
            }
            log.exiting("getDomains", (Object)returnValues);
            return cMSDomainArray2;
        }
        Object var8_8 = null;
        log.exiting("getDomains", (Object)returnValues);
        return cMSDomainArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CMSTrack[] getAllTracks(String domainID) throws CMSPermissionDeniedException, CMSClientVersionConflictException, CMSUnexpectedException {
        log.entering("getAllTracks", new Object[]{domainID});
        CMSTrack[] returnValue = null;
        try {
            try {
                Vector tracks = this.configurationManagerAPI.getTracks();
                returnValue = new CMSTrack[((AbstractCollection)tracks).size()];
                Iterator iter = ((AbstractList)tracks).iterator();
                int index = 0;
                TrackConfigurationObject tco = null;
                TrackObject to = null;
                while (iter.hasNext()) {
                    tco = (TrackConfigurationObject)iter.next();
                    to = tco.getLandscapeObject().getTrackObject();
                    returnValue[index++] = this.trackObject2CMSTrack(to);
                    log.debug("Track[" + (index - 1) + "]: " + returnValue[index - 1]);
                }
            }
            catch (CMSConfigurationException e) {
                log.error("Error reading all tracks from CMS", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CMSConnectorException e) {
                log.error("Communication error reading all tracks from CMS", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CreateException e) {
                Object var9_13 = null;
                log.exiting("getAllTracks", (Object)returnValue);
                return returnValue;
            }
            catch (RemoteException e) {
                Object var9_14 = null;
                log.exiting("getAllTracks", (Object)returnValue);
                return returnValue;
            }
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            log.exiting("getAllTracks", (Object)returnValue);
            throw throwable;
        }
        log.exiting("getAllTracks", (Object)returnValue);
        return returnValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CMSTrackConfiguration getTrackConfiguration(String domainID, String trackID) throws CMSClientTrackNotFoundException, CMSPermissionDeniedException, CMSClientVersionConflictException, CMSUnexpectedException {
        log.entering("getTrackConfiguration", new Object[]{domainID, trackID});
        CMSTrackConfiguration returnValue = null;
        try {
            try {
                TrackConfigurationObject param = new TrackConfigurationObject();
                param.getLandscapeObject().getCmsDomainObject().setName(domainID);
                param.getLandscapeObject().getTrackObject().setName(trackID);
                param = this.configurationManagerAPI.readTrackConfiguration(param);
                returnValue = this.trackConfigurationObject2CMSTrackConfiguration(param);
                Vector systemsList = this.configurationManagerAPI.readSystems(param);
                Iterator iter = ((AbstractList)systemsList).iterator();
                ArrayList<CMSSystem> tempList = new ArrayList<CMSSystem>();
                while (true) {
                    if (!iter.hasNext()) {
                        CMSSystem[] systems = new CMSSystem[tempList.size()];
                        tempList.toArray(systems);
                        returnValue.setSystems(systems);
                        break;
                    }
                    CMSSystemObject sys = (CMSSystemObject)iter.next();
                    if (sys.isImportQueue()) {
                        tempList.add(this.cMSSystemObject2CMSSystem(sys));
                        log.debug("added " + sys);
                        continue;
                    }
                    log.debug("skipped " + sys);
                }
            }
            catch (CMSCExtValidateException e) {
                log.error("Validation error of track id or domain id", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CMSCValidateException e) {
                log.error("Validation error of track id or domain id", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CMSConfigurationException e) {
                log.error("Error reading from CMS", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CMSConnectorException e) {
                log.error("Communication error reading from CMS", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (MalformedURLException e) {
                log.error("Malformed CBS or DTR URL", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CreateException e) {
                Object var12_17 = null;
                log.exiting("getTrackConfiguration", returnValue);
                return returnValue;
            }
            catch (RemoteException e) {
                Object var12_18 = null;
                log.exiting("getTrackConfiguration", returnValue);
                return returnValue;
            }
            Object var12_16 = null;
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            log.exiting("getTrackConfiguration", returnValue);
            throw throwable;
        }
        log.exiting("getTrackConfiguration", (Object)returnValue);
        return returnValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CMSTrackConfiguration getTrackConfigurationByName(String domainID, String trackName) throws CMSClientTrackNotFoundException, CMSPermissionDeniedException, CMSClientVersionConflictException, CMSUnexpectedException {
        CMSTrackConfiguration cMSTrackConfiguration;
        log.entering("getTrackConfigurationByName");
        CMSTrackConfiguration returnValue = null;
        try {
            try {
                Vector tracks = this.configurationManagerAPI.getTracks();
                Iterator iter = ((AbstractList)tracks).iterator();
                TrackConfigurationObject tco = null;
                do {
                    if (iter.hasNext()) continue;
                    throw new CMSClientTrackNotFoundException(domainID, null, trackName);
                } while (!(tco = (TrackConfigurationObject)iter.next()).getLandscapeObject().getTrackObject().getCaption().equals(trackName) || !tco.getLandscapeObject().getCmsDomainObject().getName().equals(domainID));
                cMSTrackConfiguration = this.getTrackConfiguration(domainID, tco.getLandscapeObject().getTrackObject().getName());
                Object var9_12 = null;
            }
            catch (CMSConfigurationException e) {
                log.error("Error reading from CMS", (Throwable)e);
                throw new CMSUnexpectedException((Throwable)e);
            }
            catch (CMSConnectorException e) {
                log.error("Communication error reading from CMS", (Throwable)((Object)e));
                throw new CMSUnexpectedException((Throwable)((Object)e));
            }
            catch (CreateException e) {
                Object var9_13 = null;
                log.exiting("getTrackConfigurationByName", returnValue);
                return returnValue;
            }
            catch (RemoteException e) {
                Object var9_14 = null;
                log.exiting("getTrackConfigurationByName", returnValue);
                return returnValue;
            }
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            log.exiting("getTrackConfigurationByName", returnValue);
            throw throwable;
        }
        log.exiting("getTrackConfigurationByName", returnValue);
        return cMSTrackConfiguration;
    }

    protected CMSTrack trackObject2CMSTrack(TrackObject to) {
        return new CMSTrack(to.getName(), to.getCaption(), to.getDescription());
    }

    protected CMSTrackConfiguration trackConfigurationObject2CMSTrackConfiguration(TrackConfigurationObject tco) throws MalformedURLException {
        CMSTrackConfiguration returnValue = new CMSTrackConfiguration();
        log.debug("Converting track ...");
        returnValue.setTrack(this.trackObject2CMSTrack(tco.getLandscapeObject().getTrackObject()));
        log.debug("Converting CBS URL ...");
        returnValue.setCbsURL(tco.getLandscapeObject().getCbsServerObject().getUrl());
        log.debug("Converting DTR URL ...");
        returnValue.setDtrURL(tco.getLandscapeObject().getDtrServerObject().getUrl());
        log.debug("Converting developed software component versions");
        Vector developed = tco.getLandscapeObject().getDevComponentVector();
        CMSSoftwareComponentVersion[] developedCompartments = new CMSSoftwareComponentVersion[developed.size()];
        int count = 0;
        Iterator iter = developed.iterator();
        while (iter.hasNext()) {
            developedCompartments[count] = this.compartmentObject2CMSSoftwareComponentVersion((CompartmentObject)iter.next());
            ++count;
        }
        returnValue.setDevelopedSoftwareComponentVersions(developedCompartments);
        log.debug("Converting used software component versions");
        Vector used = tco.getLandscapeObject().getDepComponentVector();
        CMSSoftwareComponentVersion[] usedCompartments = new CMSSoftwareComponentVersion[used.size()];
        count = 0;
        Iterator iter2 = used.iterator();
        while (iter2.hasNext()) {
            usedCompartments[count] = this.compartmentObject2CMSSoftwareComponentVersion((CompartmentObject)iter2.next());
            ++count;
        }
        returnValue.setUsedSoftwareComponentVersions(usedCompartments);
        return returnValue;
    }

    protected CMSSoftwareComponentVersion compartmentObject2CMSSoftwareComponentVersion(CompartmentObject co) {
        return new CMSSoftwareComponentVersion(co.getName(), co.getVendor(), co.getReleaseName());
    }

    protected CMSSystem cMSSystemObject2CMSSystem(CMSSystemObject object) {
        CMSSystemRole role;
        String sysRole = object.getRole();
        if ("D".equals(sysRole)) {
            role = CMSSystemRole.DEVELOPMENT;
        } else if ("C".equals(sysRole)) {
            role = CMSSystemRole.CONSOLIDATION;
        } else if ("Q".equals(sysRole)) {
            role = CMSSystemRole.QUALITY;
        } else if ("F".equals(sysRole)) {
            role = CMSSystemRole.FINAL;
        } else {
            log.error("Unknown system role");
            role = null;
        }
        return new CMSSystem(object.getDomname(), object.getTrackName(), role);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

