/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cms.client.config;

import com.sap.cms.client.config.ConfigurationAPI;
import com.sap.cms.client.config.impl.ConfigurationAPIConnector;
import com.sap.cms.client.connection.ICMSConnectionIdentifier;
import com.sap.cms.util.exception.client.CMSClientCreateAPIException;
import com.sap.cms.util.logging.CmsLogger;
import com.tssap.dtr.client.lib.protocol.IAuthenticator;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.URL;
import com.tssap.dtr.client.lib.protocol.session.BasicAuthenticator;
import com.tssap.dtr.client.lib.protocol.session.SSO2Authenticator;
import com.tssap.dtr.client.lib.protocol.session.SessionContext;
import com.tssap.dtr.client.lib.protocol.templates.ConnectionTemplate;
import java.security.KeyStore;

public class ConfigurationAPIFactory {
    private static final CmsLogger log = CmsLogger.getLogger((String)(class$com$sap$cms$client$config$ConfigurationAPIFactory == null ? (class$com$sap$cms$client$config$ConfigurationAPIFactory = ConfigurationAPIFactory.class$("com.sap.cms.client.config.ConfigurationAPIFactory")) : class$com$sap$cms$client$config$ConfigurationAPIFactory).getName());
    protected static ConfigurationAPIFactory instance = null;
    static /* synthetic */ Class class$com$sap$cms$client$config$ConfigurationAPIFactory;

    public static synchronized ConfigurationAPIFactory getInstance() {
        log.entering("getInstance");
        try {
            if (instance == null) {
                instance = new ConfigurationAPIFactory();
            }
            Object var1 = null;
        }
        catch (Throwable throwable) {
            Object var1_1 = null;
            log.exiting("getInstance", (Object)instance);
            throw throwable;
        }
        log.exiting("getInstance", (Object)instance);
        return instance;
    }

    public static synchronized void releaseInstance() {
        log.entering("releaseInstance");
        instance = null;
        log.exiting("releaseInstance");
    }

    protected ConfigurationAPIFactory() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigurationAPI createConfigurationAPI(URL cmsURL, String ticket, String user, String password, KeyStore store) throws CMSClientCreateAPIException {
        ConfigurationAPIConnector configurationAPIConnector;
        log.entering("createConfigurationAPI", new Object[]{cmsURL, ticket, user, "***", store});
        ConfigurationAPIConnector configurationAPI = null;
        try {
            try {
                ConnectionTemplate connectionTemplate = new ConnectionTemplate();
                connectionTemplate.setUrl(cmsURL);
                SessionContext ctx = new SessionContext(user, password);
                SSO2Authenticator authenticator = new SSO2Authenticator((ISessionContext)ctx, ticket, (IAuthenticator)new BasicAuthenticator((ISessionContext)ctx));
                ctx.setAuthenticator((IAuthenticator)authenticator);
                boolean isSecure = "https".equalsIgnoreCase(cmsURL.getProtocol());
                if (isSecure) {
                    if (store == null) {
                        log.error("Impossible to use https without keystore");
                        throw new Exception("No keystore provided, impossible to use HTTPS");
                    }
                    log.debug("Using secure connection");
                } else {
                    log.warning("Using insecure connection");
                }
                if (isSecure) {
                    ctx.certificates().setAuthenticateThem(true);
                    ctx.certificates().setServerCertificates(store);
                }
                connectionTemplate.setSessionContext((ISessionContext)ctx);
                connectionTemplate.setSocketReadTimeout(60000);
                configurationAPIConnector = configurationAPI = new ConfigurationAPIConnector((IConnectionTemplate)connectionTemplate);
                Object var13_13 = null;
            }
            catch (Exception ex) {
                log.error("Creation of ConfigurationAPI failed", (Throwable)ex);
                throw new CMSClientCreateAPIException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            log.exiting("createConfigurationAPI", configurationAPI);
            throw throwable;
        }
        log.exiting("createConfigurationAPI", (Object)configurationAPI);
        return configurationAPIConnector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigurationAPI createConfigurationAPI(IConnectionTemplate connectionTemplate) throws CMSClientCreateAPIException {
        ConfigurationAPIConnector configurationAPIConnector;
        log.entering("createConfigurationAPI", new Object[]{connectionTemplate});
        ConfigurationAPIConnector configurationAPI = null;
        try {
            try {
                configurationAPIConnector = configurationAPI = new ConfigurationAPIConnector(connectionTemplate);
                Object var5_5 = null;
            }
            catch (Exception ex) {
                log.error("Creation of ConfigurationAPI failed", (Throwable)ex);
                throw new CMSClientCreateAPIException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            log.exiting("createConfigurationAPI", (Object)configurationAPI);
            throw throwable;
        }
        log.exiting("createConfigurationAPI", (Object)configurationAPI);
        return configurationAPIConnector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigurationAPI createConfigurationAPI(ICMSConnectionIdentifier connectionIdentifier) throws CMSClientCreateAPIException {
        ConfigurationAPIConnector configurationAPIConnector;
        log.entering("createConfigurationAPI", new Object[]{connectionIdentifier});
        ConfigurationAPIConnector configurationAPI = null;
        try {
            try {
                configurationAPIConnector = configurationAPI = new ConfigurationAPIConnector(connectionIdentifier);
                Object var5_5 = null;
            }
            catch (Exception ex) {
                log.error("Creation of ConfigurationAPI failed", (Throwable)ex);
                throw new CMSClientCreateAPIException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            log.exiting("createConfigurationAPI", (Object)configurationAPI);
            throw throwable;
        }
        log.exiting("createConfigurationAPI", (Object)configurationAPI);
        return configurationAPIConnector;
    }

    public String toString() {
        return "ConfigurationAPIFactory singleton";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

