/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt.output;

import com.sap.engine.lib.xml.parser.handlers.EncodingHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.Encoding;
import com.sap.engine.lib.xml.parser.helpers.UTF8Encoding;
import com.sap.engine.lib.xsl.xpath.StaticInteger;
import com.sap.engine.lib.xsl.xslt.output.DocHandlerSerializer;
import com.sap.engine.lib.xsl.xslt.output.OutputException;
import com.sap.engine.lib.xsl.xslt.output.OutputIOException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public final class Encoder {
    protected DocHandlerSerializer owner = null;
    protected static final String LINE_SEPARATOR = "\n";
    protected Writer writer = null;
    protected OutputStream stream = null;
    protected static final String CDATA_BEGIN = "<![CDATA[";
    protected static final String CDATA_END = "]]>";
    protected static final String CDATA_END_BEGIN = "]]><![CDATA[";
    protected boolean escapingDisabled = false;
    private byte[] bufwritebyte = new byte[20000];
    private char[] bufwritechar = new char[20000];
    private byte[] convarr = new byte[10];
    private int bufwriteidx = 0;
    private EncodingHandler encodingHandler = new EncodingHandler();
    private Encoding encoding = this.encodingHandler.getEncoding(new CharArray("UTF-8"));
    private CharArray chTempOutRef = new CharArray();
    private static final String[] CH_TO_ENT_TEXT = new String[256];
    static /* synthetic */ Class class$com$sap$engine$lib$xml$parser$helpers$UTF8Encoding;
    static /* synthetic */ Class class$com$sap$engine$lib$xml$parser$helpers$SingleByteEncoding;

    private void init() {
        this.writer = null;
        this.stream = null;
        this.escapingDisabled = false;
        this.chTempOutRef.clear();
    }

    protected void init(Writer writer, String enc) throws OutputException {
        this.init();
        this.bufwriteidx = 0;
        this.setWriter(writer);
        this.encoding = this.encodingHandler.getEncoding(new CharArray(enc));
        if (this.encoding == null) {
            this.encoding = this.encodingHandler.getEncoding(UTF8Encoding.NAME);
        }
    }

    public void init(OutputStream outputStream, String enc) {
        this.init();
        this.bufwriteidx = 0;
        this.stream = outputStream;
        if (enc != null) {
            this.encoding = this.encodingHandler.getEncoding(new CharArray(enc));
        }
        if (this.encoding == null) {
            this.encoding = this.encodingHandler.getEncoding(UTF8Encoding.NAME);
        }
    }

    public void init(OutputStream out) {
        this.init(out, null);
    }

    protected void setWriter(Writer writer) {
        this.writer = writer;
    }

    protected String getEncodingName() {
        return this.encoding.getName().toString();
    }

    private void bufferWrite(int b) throws IOException {
        if (this.bufwriteidx == this.bufwritebyte.length) {
            if (this.stream != null) {
                this.stream.write(this.bufwritebyte);
            } else {
                this.writer.write(this.bufwritechar);
            }
            this.bufwriteidx = 0;
        }
        if (this.stream != null) {
            this.bufwritebyte[this.bufwriteidx++] = (byte)b;
        } else {
            this.bufwritechar[this.bufwriteidx++] = (char)b;
        }
    }

    private void bufferWriteStream(int b) throws IOException {
        if (this.bufwriteidx == this.bufwritebyte.length) {
            this.stream.write(this.bufwritebyte);
            this.bufwriteidx = 0;
        }
        this.bufwritebyte[this.bufwriteidx++] = (byte)b;
    }

    public void out(char ch) throws OutputException {
        try {
            this.makeDefaultEncodingCheck(ch);
        }
        catch (IOException e) {
            throw new OutputIOException(e);
        }
    }

    public void outDirect(char ch) throws OutputException {
        try {
            this.bufferWrite((byte)ch);
        }
        catch (IOException e) {
            throw new OutputIOException(e);
        }
    }

    public Encoder enableOutputEscaping() {
        this.escapingDisabled = false;
        return this;
    }

    public Encoder disableOutputEscaping() {
        this.escapingDisabled = true;
        return this;
    }

    public Encoder out(char[] ch, int start, int length) throws OutputException {
        int i = 0;
        while (i < length) {
            this.makeDefaultEncodingCheck(ch[start + i]);
            ++i;
        }
        return this;
    }

    public Encoder out(String s) throws OutputException {
        int i = 0;
        int l = s.length();
        while (i < l) {
            this.makeDefaultEncodingCheck(s.charAt(i));
            ++i;
        }
        return this;
    }

    private void makeDefaultEncodingCheck(char ch) throws OutputException {
        try {
            if (this.stream != null) {
                this.makeDefaultEncodingCheckStream(ch);
            } else {
                this.bufferWrite(ch);
            }
        }
        catch (Exception e) {
            throw new OutputException(e);
        }
    }

    private void makeDefaultEncodingCheckStream(char ch) throws OutputException {
        block9: {
            try {
                if (ch < '\u0080' && (this.encoding.getClass() == (class$com$sap$engine$lib$xml$parser$helpers$UTF8Encoding == null ? (class$com$sap$engine$lib$xml$parser$helpers$UTF8Encoding = Encoder.class$("com.sap.engine.lib.xml.parser.helpers.UTF8Encoding")) : class$com$sap$engine$lib$xml$parser$helpers$UTF8Encoding) || this.encoding.getClass() == (class$com$sap$engine$lib$xml$parser$helpers$SingleByteEncoding == null ? (class$com$sap$engine$lib$xml$parser$helpers$SingleByteEncoding = Encoder.class$("com.sap.engine.lib.xml.parser.helpers.SingleByteEncoding")) : class$com$sap$engine$lib$xml$parser$helpers$SingleByteEncoding))) {
                    this.bufferWriteStream((byte)ch);
                    break block9;
                }
                int len = this.encoding.reverseEncode(this.convarr, ch);
                if (len == -1) {
                    this.outCharRefDec(ch);
                    break block9;
                }
                switch (len) {
                    case 1: {
                        this.bufferWrite(this.convarr[0]);
                        break;
                    }
                    case 2: {
                        this.bufferWrite(this.convarr[0]);
                        this.bufferWrite(this.convarr[1]);
                        break;
                    }
                    default: {
                        int i = 0;
                        while (i < len) {
                            this.bufferWrite(this.convarr[i]);
                            ++i;
                        }
                        break;
                    }
                }
            }
            catch (IOException e) {
                throw new OutputException(e);
            }
        }
    }

    public void outEscaped(char ch) throws OutputException {
        if (this.escapingDisabled) {
            this.makeDefaultEncodingCheck(ch);
            return;
        }
        if (ch < '\u00ff' && CH_TO_ENT_TEXT[ch] != null) {
            this.out(CH_TO_ENT_TEXT[ch]);
            return;
        }
        this.makeDefaultEncodingCheck(ch);
    }

    public Encoder outEscaped(CharArray ca) throws OutputException {
        return this.outEscaped(ca.getData(), ca.getOffset(), ca.length());
    }

    public Encoder outEscaped(String s) throws OutputException {
        if (this.escapingDisabled) {
            return this.out(s);
        }
        if (this.stream != null) {
            int i = 0;
            while (i < s.length()) {
                block7: {
                    char ch;
                    block6: {
                        ch = s.charAt(i);
                        try {
                            if (CH_TO_ENT_TEXT[ch] == null) break block6;
                            this.out(CH_TO_ENT_TEXT[ch]);
                            break block7;
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            // empty catch block
                        }
                    }
                    this.makeDefaultEncodingCheckStream(ch);
                }
                ++i;
            }
            return this;
        }
        int i = 0;
        while (i < s.length()) {
            this.outEscaped(s.charAt(i));
            ++i;
        }
        return this;
    }

    public void outAttribute(String attrib, char delimiter) throws OutputException {
        int len = attrib.length();
        int i = 0;
        while (i < len) {
            char ch = attrib.charAt(i);
            this.outAttribChar(ch, delimiter);
            ++i;
        }
    }

    private void outAttribChar(char ch, char delimiter) throws OutputException {
        switch (ch) {
            case '\'': {
                if (delimiter == '\'') {
                    this.out("&apos;");
                    break;
                }
                this.out('\'');
                break;
            }
            case '\"': {
                if (delimiter == '\"') {
                    this.out("&quot;");
                    break;
                }
                this.out('\"');
                break;
            }
            case '&': {
                this.out("&amp;");
                break;
            }
            case '<': {
                this.out("&lt;");
                break;
            }
            case '>': {
                this.out(">");
                break;
            }
            case '\t': {
                this.out("&#x9;");
                break;
            }
            case '\n': {
                this.out("&#xA;");
                break;
            }
            case '\r': {
                this.out("&#xD;");
                break;
            }
            default: {
                this.makeDefaultEncodingCheck(ch);
            }
        }
    }

    public Encoder outAttribute(CharArray ca, char delimiter) throws OutputException {
        char[] data = ca.getData();
        int offset = ca.getOffset();
        int end = offset + ca.length();
        int i = offset;
        while (i < end) {
            char ch = data[i];
            this.outAttribChar(ch, delimiter);
            ++i;
        }
        return this;
    }

    public Encoder outEscaped(char[] ch, int start, int length) throws OutputException {
        if (this.escapingDisabled) {
            return this.out(ch, start, length);
        }
        int end = start + length;
        int i = start;
        while (i < end) {
            this.outEscaped(ch[i]);
            ++i;
        }
        return this;
    }

    public Encoder out(CharArray ca) throws OutputException {
        return this.out(ca.getData(), ca.getOffset(), ca.length());
    }

    public Encoder outDirect(char[] ch, int start, int len) throws OutputException {
        try {
            int i = start;
            while (i < len) {
                this.bufferWrite((byte)ch[i]);
                ++i;
            }
            return this;
        }
        catch (Exception e) {
            throw new OutputException(e);
        }
    }

    public Encoder outDirect(CharArray ca) throws OutputException {
        return this.outDirect(ca.getData(), ca.getOffset(), ca.getSize());
    }

    protected Encoder outCDATA(char[] ch, int start, int length) throws OutputException {
        this.out(CDATA_BEGIN);
        if (length < 3) {
            this.out(ch, start, length);
        } else {
            char prev2 = ch[start];
            char prev = ch[start + 1];
            this.outEscaped(prev2);
            this.outEscaped(prev);
            int end = start + length;
            int i = start + 2;
            while (i < end) {
                char curr = ch[i];
                if (prev2 == ']' && prev == ']' && curr == '>') {
                    this.out(CDATA_END_BEGIN);
                }
                this.outEscaped(curr);
                prev2 = prev;
                prev = curr;
                ++i;
            }
        }
        this.out(CDATA_END);
        return this;
    }

    protected Encoder outln() throws OutputException {
        return this.out(LINE_SEPARATOR);
    }

    protected Encoder outSpace(int x) throws OutputException {
        int i = 0;
        while (i < x) {
            this.out(' ');
            ++i;
        }
        return this;
    }

    protected Encoder outCharRefHex(char ch) throws OutputException {
        this.out("&#x");
        this.out(Integer.toHexString(ch));
        this.out(';');
        return this;
    }

    protected Encoder outCharRefDec(char ch) throws OutputException {
        this.out("&#");
        this.out(StaticInteger.intToCharArraySync(ch, this.chTempOutRef));
        this.out(';');
        return this;
    }

    protected Encoder outHTMLAttribute(CharArray s, boolean uriflag) throws OutputException {
        char[] data = s.getData();
        int size = s.length();
        int off = s.getOffset();
        int totsize = size + off;
        int i = off;
        while (i < totsize) {
            boolean showEscaped = true;
            if (data[i] == '<') {
                showEscaped = false;
            }
            if (i + 1 < totsize && data[i] == '&' && data[i + 1] == '{') {
                showEscaped = false;
            }
            if (showEscaped) {
                if (uriflag && data[i] > '\u0080') {
                    this.outCharRefHex(data[i]);
                } else if (uriflag && data[i] == ' ') {
                    this.out("%20");
                } else {
                    this.outEscaped(data[i]);
                }
            } else {
                this.out(data[i]);
            }
            ++i;
        }
        return this;
    }

    public Encoder flush() throws OutputIOException {
        try {
            if (this.stream != null) {
                this.stream.write(this.bufwritebyte, 0, this.bufwriteidx);
            } else {
                this.writer.write(this.bufwritechar, 0, this.bufwriteidx);
                this.writer.flush();
            }
            this.bufwriteidx = 0;
        }
        catch (IOException e) {
            throw new OutputIOException(e);
        }
        return this;
    }

    public void close() throws OutputIOException {
        try {
            this.flush();
            if (this.stream != null) {
                this.stream.close();
            } else if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException e) {
            throw new OutputIOException(e);
        }
    }

    protected void setOwner(DocHandlerSerializer owner) {
        this.owner = owner;
    }

    protected DocHandlerSerializer getOwner() {
        return this.owner;
    }

    protected boolean isEscapingEnabled() {
        return !this.escapingDisabled;
    }

    protected void setEscaping(boolean b) {
        this.escapingDisabled = !b;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Encoder.CH_TO_ENT_TEXT[13] = "&#xD;";
        Encoder.CH_TO_ENT_TEXT[38] = "&amp;";
        Encoder.CH_TO_ENT_TEXT[60] = "&lt;";
        Encoder.CH_TO_ENT_TEXT[62] = "&gt;";
    }
}

