/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.DTM;
import com.sap.engine.lib.xsl.xpath.DTMManager;
import com.sap.engine.lib.xsl.xpath.ETObject;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xslt.VariableContext;
import com.sap.engine.lib.xsl.xslt.XSLStylesheet;
import org.w3c.dom.Document;

public class XPathProcessor {
    protected CharArray key = new CharArray();
    public DTM dtm;

    public XPathProcessor() {
    }

    public XPathProcessor(DTM dtm) {
        this.reuse(dtm);
    }

    public void reuse(DTM dtm) {
        this.dtm = dtm;
    }

    public XObject process(ETObject query, XPathContext context) throws XPathException {
        context.globalCurrentNode = context.node;
        context.setXFactProcess();
        XObject x = this.innerProcess(query, context);
        return x;
    }

    public XObject process(ETObject query, XPathContext context, VariableContext vc) throws XPathException {
        context.variableBindings = vc;
        vc.useXPathContext(context);
        return this.process(query, context);
    }

    private XObject innerProcess(ETObject q, XPathContext c) throws XPathException {
        try {
            return q.et.evaluate(c);
        }
        catch (NullPointerException e) {
            throw new XPathException("Error parsing query", e);
        }
    }

    public XObject process(ETObject query) throws XPathException {
        return this.process(query, this.dtm.getInitialContext());
    }

    public void init(String xmlname, XSLStylesheet owner) throws XPathException {
        this.dtm = DTMManager.getDTM(xmlname, owner.getNamespaceManager());
    }

    public void init(Document doc) throws XPathException {
        throw new XPathException("Initializing the XPath processor through DOM is not supported.");
    }

    public DTM getDTM() {
        return this.dtm;
    }

    protected CharArray makeKey(XPathContext x, CharArray query, String mode) {
        this.key.reuse();
        this.key.set(query);
        this.key.append('[');
        this.key.append('[');
        this.key.appendInteger(x.node);
        this.key.append('[');
        this.key.append('[');
        this.key.append(mode);
        return this.key;
    }

    public boolean match(ETObject eo, XPathContext context0, String mode) throws XPathException {
        if (eo.squery.equals("/")) {
            return context0.node == 0;
        }
        if (eo.squery.equals("*|/")) {
            return context0.node == 0 || context0.dtm.nodeType[context0.node] == 1;
        }
        return eo.et.match(context0);
    }

    public void initializeProcess() {
    }

    public void finalizeLocal() {
    }
}

