/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.transform;

import com.sap.engine.lib.schema.regular.RegularExpression;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TransformationFactory {
    public HashMap dataHashmap = new HashMap();
    public Vector customTransforms = new Vector();

    public static TransformationFactory newInstance() {
        return new TransformationFactory();
    }

    protected TransformationFactory() {
    }

    public void registerTransformation(Transformation tr) {
        Vector vector = this.customTransforms;
        synchronized (vector) {
            if (!this.customTransforms.contains(tr)) {
                this.customTransforms.add(tr);
            }
        }
    }

    public Transformation getInstance(String uri, Object[] additionalArgs) throws SignatureException {
        Vector vector = this.customTransforms;
        synchronized (vector) {
            int length = this.customTransforms.size();
            int i = 0;
            while (i < length) {
                Transformation next = (Transformation)this.customTransforms.get(i);
                if (uri.equals(next.uri)) {
                    Transformation cloned;
                    Transformation transformation = cloned = next.defineFrom(additionalArgs, this.dataHashmap);
                    return transformation;
                }
                ++i;
            }
        }
        return Transformation.getInstance(uri, additionalArgs);
    }

    public Transformation getInstance(GenericElement e) throws SignatureException {
        Hashtable attribs;
        String prefixList;
        GenericElement inclusiveNamespaces;
        Transformation custom = this.getCustom(e);
        if (custom != null) {
            return custom;
        }
        String uri = e.getAttribute("Algorithm", null, null);
        if (uri == null) {
            throw new SignatureException("Attribute \"Algorithm \" not found on element " + ((Element)e.getDomRepresentation()).getLocalName(), new Object[]{e});
        }
        Object[] additionalArgs = null;
        if (uri.equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
            GenericElement xpath = e.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "XPath");
            String query = xpath.getNodeValue();
            Hashtable mappings = xpath.getNamespaceMappingsInScope();
            additionalArgs = new Object[]{query, mappings};
        }
        if (uri.startsWith("http://www.w3.org/2001/10/xml-exc-c14n#") && (inclusiveNamespaces = e.getDirectChild("http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces")) != null && (prefixList = (String)(attribs = inclusiveNamespaces.getAttributes()).get("PrefixList")) != null) {
            String[] iN = RegularExpression.compile("\\s").split(prefixList);
            additionalArgs = new Object[]{iN};
        }
        if (uri.startsWith("http://www.w3.org/2002/07/decrypt#")) {
            Element el = (Element)e.getDomRepresentation();
            NodeList except = el.getElementsByTagNameNS("http://www.w3.org/2002/07/decrypt#", "Except");
            additionalArgs = new Object[except.getLength()];
            int i = 0;
            while (i < additionalArgs.length) {
                additionalArgs[i] = ((Element)except.item(i)).getAttribute("URI");
                ++i;
            }
        }
        return this.getInstance(uri, additionalArgs);
    }

    public Transformation getCustom(GenericElement ge) throws SignatureException {
        Vector vector = this.customTransforms;
        synchronized (vector) {
            int length = this.customTransforms.size();
            int i = 0;
            while (i < length) {
                Transformation next = (Transformation)this.customTransforms.get(i);
                Transformation cloned = next.defineFrom(ge, this.dataHashmap);
                if (cloned != null) {
                    Transformation transformation = cloned;
                    return transformation;
                }
                ++i;
            }
        }
        return null;
    }

    public void add(String key, Object value) {
        HashMap hashMap = this.dataHashmap;
        synchronized (hashMap) {
            this.dataHashmap.put(key, value);
        }
    }
}

