/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption;

import com.sap.engine.lib.xml.dom.BinaryTextImpl;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.signature.Configurator;
import com.sap.engine.lib.xml.signature.SignatureContext;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.transform.TransformationFactory;
import com.sap.engine.lib.xml.signature.transform.algorithms.Canonicalization;
import com.sap.engine.lib.xml.util.BASE64Decoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XMLCryptor {
    public TransformationFactory trFact = TransformationFactory.newInstance();
    protected boolean padManually = true;
    protected boolean ivIncluded = true;
    protected String cryptMode = "CBC";
    protected String cryptPadding = "NoPadding";
    protected int mode = -1;
    protected Cipher cipher = null;
    protected Key key = null;
    protected String algorithmURI = null;
    protected byte[] IV = null;
    protected AlgorithmParameters algParams = null;
    protected String primaryEncodingFormat = "ASN.1";
    protected String prngIdentifier = "SHA1PRNG";
    protected byte[] randomSeed = null;
    protected int ivLength = -1;
    protected byte[] toEncrypt;
    static CharArray temp = new CharArray(1000, 1000);

    public void overrideDefaultPadding(String $cryptPadding) {
        this.padManually = false;
        this.cryptPadding = $cryptPadding;
    }

    public void setCryptMode(String cryptMode) {
        this.cryptMode = cryptMode;
    }

    public AlgorithmParameters getAlgorithmParameters() {
        return this.algParams;
    }

    public void specifyRandomness(String identifier, byte[] seed) {
        this.prngIdentifier = identifier;
        this.randomSeed = seed;
    }

    public void setAlgorithmParameters(AlgorithmParameters algParams) {
        this.algParams = algParams;
    }

    public byte[] getIV() {
        return this.IV;
    }

    public void setIV(byte[] IV) {
        this.IV = IV;
    }

    public void createCipher(String $algorithmURI) throws SignatureException {
        try {
            this.algorithmURI = $algorithmURI;
            this.cipher = this.generateCipherInstance($algorithmURI);
            this.cipher.init(this.mode, this.key);
        }
        catch (GeneralSecurityException e) {
            throw new SignatureException("Unable to create cifer:" + $algorithmURI + " mode:" + this.mode, new Object[]{$algorithmURI, this.key}, e);
        }
    }

    public void createCipher() throws SignatureException {
        this.createCipher(this.algorithmURI);
    }

    public void setKey(Key key) {
        this.key = key;
        try {
            this.algorithmURI = Configurator.getCipherURIFromJCE(key.getAlgorithm());
        }
        catch (SignatureException signatureException) {
            // empty catch block
        }
    }

    public void setEncryptionKey(Key key) throws SignatureException {
        this.key = key;
        this.algorithmURI = Configurator.getCipherURIFromJCE(key.getAlgorithm());
    }

    public void setIVLength(int ivLength) {
        this.ivLength = ivLength;
    }

    protected String decrypt0(byte[] content) throws IOException, GeneralSecurityException, SignatureException {
        byte[] encryptedWithIV = BASE64Decoder.decode(content);
        int start = this.getEncryptedNoIV(encryptedWithIV);
        this.initCipher(this.key, this.algParams, this.IV, 2);
        byte[] decryptedContent = this.cipher.doFinal(encryptedWithIV, start, encryptedWithIV.length - start);
        if (this.padManually) {
            return new String(decryptedContent, 0, this.dePad(decryptedContent));
        }
        return new String(decryptedContent);
    }

    protected byte[] decrypt1(byte[] content) throws IOException, GeneralSecurityException, SignatureException {
        byte[] encryptedWithIV = BASE64Decoder.decode(content);
        int start = this.getEncryptedNoIV(encryptedWithIV);
        this.initCipher(this.key, this.algParams, this.IV, 2);
        byte[] decryptedContent = this.cipher.doFinal(encryptedWithIV, start, encryptedWithIV.length - start);
        if (this.padManually) {
            byte[] ret = new byte[this.dePad(decryptedContent)];
            System.arraycopy(decryptedContent, 0, ret, 0, ret.length);
            return ret;
        }
        return decryptedContent;
    }

    protected void encrypt0() throws GeneralSecurityException {
        byte[] arg1 = this.cipher.getIV();
        int index = arg1.length;
        if (this.padManually) {
            int blockSize = this.cipher.getBlockSize();
            int diff = blockSize - this.toEncrypt.length % blockSize;
            byte[] padding = new byte[diff];
            padding[diff - 1] = (byte)diff;
            int i = this.cipher.getOutputSize(this.toEncrypt.length + diff);
            byte[] total = new byte[arg1.length + i];
            System.arraycopy(arg1, 0, total, 0, index);
            index += this.cipher.update(this.toEncrypt, 0, this.toEncrypt.length, total, index);
            this.cipher.doFinal(padding, 0, padding.length, total, index);
            this.toEncrypt = total;
        } else {
            int i = this.cipher.getOutputSize(this.toEncrypt.length);
            byte[] total = new byte[arg1.length + i];
            System.arraycopy(arg1, 0, total, 0, index);
            this.cipher.doFinal(this.toEncrypt, 0, this.toEncrypt.length, total, index);
            this.toEncrypt = total;
        }
    }

    protected byte[] encrypt0(byte[] toEncrypt) throws GeneralSecurityException, SignatureException {
        if (this.padManually) {
            toEncrypt = this.pad(toEncrypt);
        }
        int i = this.cipher.getOutputSize(toEncrypt.length);
        byte[] arg1 = this.cipher.getIV();
        byte[] total = new byte[arg1.length + i];
        this.cipher.doFinal(toEncrypt, 0, toEncrypt.length, total, arg1.length);
        System.arraycopy(arg1, 0, total, 0, arg1.length);
        return total;
    }

    protected byte[] encrypt0(Element el, boolean contentOnly) throws GeneralSecurityException, SignatureException {
        if (el instanceof BinaryTextImpl) {
            this.toEncrypt = ((BinaryTextImpl)((Object)el)).getBinaryData();
            ((BinaryTextImpl)((Object)el)).setBinaryData(null);
        } else if (contentOnly) {
            NodeList children = el.getChildNodes();
            int ln = children.getLength();
            if (ln == 1 && children.item(0) instanceof BinaryTextImpl) {
                this.toEncrypt = ((BinaryTextImpl)children.item(0)).getBinaryData();
                ((BinaryTextImpl)children.item(0)).setBinaryData(null);
            } else {
                DocumentFragment df = el.getOwnerDocument().createDocumentFragment();
                int i = 0;
                while (i < ln) {
                    df.appendChild(children.item(i).cloneNode(true));
                    ++i;
                }
                this.toEncrypt = Canonicalization.canonicalize(df, true);
            }
        } else {
            this.toEncrypt = Canonicalization.canonicalize(el, true);
        }
        this.encrypt0();
        byte[] temp = this.toEncrypt;
        this.toEncrypt = null;
        return temp;
    }

    protected byte[] pad(byte[] toEncrypt) {
        int blockSize = this.cipher.getBlockSize();
        int length = toEncrypt.length;
        int diff = blockSize - length % blockSize;
        int size = length + diff;
        byte[] padded = new byte[length + diff];
        System.arraycopy(toEncrypt, 0, padded, 0, length);
        padded[size - 1] = (byte)diff;
        return padded;
    }

    protected int dePad(byte[] padded) {
        int length = padded.length;
        byte toRemove = padded[length - 1];
        int originalSize = length - toRemove;
        return originalSize;
    }

    protected static byte[] append(byte[] arg1, byte[] arg2) {
        int resLength = arg1.length + arg2.length;
        byte[] result = new byte[resLength];
        System.arraycopy(arg1, 0, result, 0, arg1.length);
        System.arraycopy(arg2, 0, result, arg1.length, arg2.length);
        return result;
    }

    protected int getEncryptedNoIV(byte[] encryptedWithIV) throws SignatureException {
        int wholeLength = encryptedWithIV.length;
        this.ivLength = this.getLength();
        this.IV = new byte[this.ivLength];
        System.arraycopy(encryptedWithIV, 0, this.IV, 0, this.ivLength);
        return this.ivLength;
    }

    protected int getLength() throws SignatureException {
        if (this.ivLength > 0) {
            return this.ivLength;
        }
        return Configurator.getIVLength(this.algorithmURI);
    }

    public static synchronized String gatherText(Node n) {
        temp.clear();
        NodeList nl = n.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node next = nl.item(i);
            if (next.getNodeType() == 3) {
                temp.append(next.getNodeValue());
            }
            ++i;
        }
        return temp.toString();
    }

    public static byte[] gatherBytes(Node n) {
        try {
            NodeList nl = n.getChildNodes();
            ByteArrayOutputStream out = SignatureContext.getByteArrayOutputStreamPool().getInstance();
            int len = nl.getLength();
            if (len > 0) {
                Node nn = nl.item(0);
                if (nn instanceof BinaryTextImpl) {
                    if (len == 1) {
                        return ((BinaryTextImpl)nn).getBinaryData();
                    }
                    out.write(((BinaryTextImpl)nn).getBinaryData());
                } else if (nn.getNodeType() == 3) {
                    if (len == 1) {
                        return nn.getNodeValue().getBytes();
                    }
                    out.write(nn.getNodeValue().getBytes());
                }
            } else {
                return new byte[0];
            }
            int i = 1;
            while (i < len) {
                Node next = nl.item(i);
                if (next instanceof BinaryTextImpl) {
                    out.write(((BinaryTextImpl)next).getBinaryData());
                } else if (next.getNodeType() == 3) {
                    out.write(next.getNodeValue().getBytes());
                }
                ++i;
            }
            return out.toByteArray();
        }
        catch (IOException ex) {
            return null;
        }
    }

    protected static void deleteContent(Element e) {
        NodeList nl = e.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node next = nl.item(i);
            if (next.getNodeType() == 3) {
                e.removeChild(next);
            }
            ++i;
        }
    }

    protected void initCipher(Key $key, AlgorithmParameters params, byte[] $IV, int opMode) throws IOException, GeneralSecurityException, SignatureException {
        if ($IV == null) {
            int $ivLength = this.getLength();
            $IV = new byte[$ivLength];
            this.randomize($IV);
        }
        IvParameterSpec pSpec = new IvParameterSpec($IV);
        if (params == null) {
            this.cipher.init(opMode, $key, pSpec);
        } else {
            this.cipher.init(opMode, $key, params);
        }
        this.updateParameters();
    }

    protected String getAlgOnly(String algWithModePad) {
        return algWithModePad.substring(0, algWithModePad.indexOf("/"));
    }

    protected void randomize(byte[] input) throws GeneralSecurityException {
        SecureRandom rand = SecureRandom.getInstance(this.prngIdentifier);
        if (this.randomSeed != null) {
            rand.setSeed(this.randomSeed);
        }
        rand.nextBytes(input);
    }

    protected void updateParameters() throws IOException {
        try {
            this.IV = this.cipher.getIV();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.algParams = this.cipher.getParameters();
    }

    protected Cipher generateCipherInstance(String $algorithmURI) throws SignatureException, GeneralSecurityException {
        return SignatureContext.getCryptographicPool().generateCipherInstance($algorithmURI, this.cryptMode, this.cryptPadding);
    }

    public void releaseCipher() {
        if (this.cipher == null) {
            return;
        }
        SignatureContext.getCryptographicPool().releaseCipher(this.cipher);
        this.cipher = null;
    }

    public static int decryptBuffer(Cipher cipher, byte[] encoded, int start, int length, byte[] decoded, int offset, int max_size) throws IllegalStateException, IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        int read;
        int toRead = max_size < length ? max_size : length;
        do {
            read = cipher.update(encoded, start, toRead, decoded, offset);
            start += toRead;
            offset += read;
        } while ((toRead = max_size < (length -= toRead) ? max_size : length) > 0);
        read = cipher.doFinal(decoded, offset);
        return offset += read;
    }
}

