/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature;

import com.sap.engine.lib.xml.SystemProperties;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.transform.algorithms.Canonicalization;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.w3c.dom.Node;

public class Data {
    public String mimeType = "";
    private byte[] data = null;
    private Node domRepr = null;
    private InputStream stream = null;

    public Data(String urlString, String proxyHost, String proxyPort) throws MalformedURLException, IOException {
        URL url;
        URLConnection con;
        String contentType;
        if (proxyHost != null && proxyPort != null) {
            SystemProperties.setProperty("http.proxyHost", proxyHost);
            SystemProperties.setProperty("http.proxyPort", proxyPort);
        }
        this.mimeType = (contentType = (con = (url = new URL(urlString)).openConnection()).getContentType()) == null ? "" : (contentType.indexOf("xml") >= 0 || contentType.indexOf("xhtml") >= 0 ? "xml" : (contentType.indexOf("html") >= 0 ? "html" : "html"));
        this.stream = con.getInputStream();
    }

    public Data(byte[] constructor) {
        this.data = constructor;
    }

    public Data(InputStream is) {
        this.stream = is;
    }

    public Data(Node node) {
        this.mimeType = "xml";
        this.domRepr = node;
    }

    private void buildFromDOM() throws SignatureException {
        if (this.domRepr == null) {
            this.buildFromIS();
            return;
        }
        this.data = Canonicalization.canonicalize(this.domRepr, true);
    }

    /*
     * WARNING - void declaration
     */
    private void buildFromIS() throws SignatureException {
        try {
            int read;
            byte[] temp = new byte[]{};
            byte[] buffer = new byte[5000];
            while ((read = this.stream.read(buffer)) != -1) {
                void var3_4;
                byte[] temp1 = new byte[temp.length + var3_4];
                System.arraycopy(temp, 0, temp1, 0, temp.length);
                System.arraycopy(buffer, 0, temp1, temp.length, (int)var3_4);
                temp = temp1;
            }
            this.data = temp;
        }
        catch (Exception ex) {
            throw new SignatureException("Error reading stream", new Object[]{this.stream}, ex);
        }
    }

    private void buildFromOctets() throws SignatureException {
        if (this.data == null) {
            this.buildFromIS();
        }
        this.domRepr = Canonicalization.canonicalizeToNode(this.data, true);
    }

    public InputStream getInputStream() throws SignatureException {
        if (this.data == null) {
            this.buildFromDOM();
        }
        return new ByteArrayInputStream(this.data);
    }

    public Node getNode() throws SignatureException {
        if (this.domRepr == null) {
            this.buildFromOctets();
        }
        return this.domRepr;
    }

    public byte[] getOctets() throws SignatureException {
        if (this.data == null) {
            this.buildFromDOM();
        }
        return this.data;
    }

    public void reuse() {
        this.mimeType = "";
        this.data = null;
        this.domRepr = null;
        this.stream = null;
    }

    public void setInputStream(InputStream is) {
        this.reuse();
        this.stream = is;
    }

    public void setNode(Node node) {
        this.reuse();
        this.mimeType = "xml";
        this.domRepr = node;
    }

    public void setOctets(byte[] octets) {
        this.reuse();
        this.data = octets;
    }

    public void synch() throws SignatureException {
        if (this.data == null) {
            this.buildFromDOM();
        } else if (this.domRepr == null) {
            this.buildFromOctets();
        }
    }
}

