/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.handlers;

import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.Entity;
import com.sap.engine.lib.xml.parser.helpers.Reference;
import java.util.Hashtable;
import java.util.Stack;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributeListImpl;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public final class SAXDocHandler
implements DocHandler {
    private LexicalHandler lexicalHandler = null;
    private DocumentHandler documentHandler = null;
    private DeclHandler declHandler = null;
    private ContentHandler contentHandler = null;
    private DTDHandler dtdHandler = null;
    private ErrorHandler errorHandler = null;
    private Stack namestack = new Stack();
    public static final boolean DEBUG = true;
    boolean wroteDTDKv = false;
    private Hashtable hash = new Hashtable();
    Object tmp = null;
    CharArray tmp2 = null;
    String tmps = null;
    private int maxsize = 300;
    private int cursize = 0;
    int se = 0;
    int cd = 0;
    int pi = 0;
    int cm = 0;
    int at = 0;
    String stLN;
    String stQN;
    String stUR;
    AttributesImpl attImpl = new AttributesImpl();
    AttributeListImpl attListImpl = new AttributeListImpl();

    public SAXDocHandler() {
    }

    public SAXDocHandler(DefaultHandler h) {
        this.setContentHandler(h);
        this.setDTDHandler(h);
    }

    public String get(CharArray item) {
        item.bufferHash();
        this.tmp = this.hash.get(item);
        item.clearHashReady();
        if (this.tmp == null && this.cursize < this.maxsize) {
            this.tmp2 = item.copy();
            this.tmps = this.tmp2.getString();
            this.tmp2.bufferHash();
            this.hash.put(this.tmp2, this.tmps);
            ++this.cursize;
            return this.tmps;
        }
        if (this.cursize == this.maxsize) {
            return item.getString();
        }
        return (String)this.tmp;
    }

    public String mq(String str) {
        if (str.indexOf("\"") != -1) {
            return "'" + str + "'";
        }
        return "\"" + str + "\"";
    }

    public void onXMLDecl(String v, String e, String s) {
    }

    public void startElementStart(CharArray uri, CharArray localName, CharArray qname) throws Exception {
        ++this.se;
        if (this.contentHandler != null || this.documentHandler != null) {
            this.stUR = this.get(uri != null ? uri : CharArray.EMPTY);
            this.stLN = this.get(localName);
            this.stQN = this.get(qname);
            this.attImpl.clear();
            this.attListImpl.clear();
        }
    }

    public void addAttribute(CharArray uri, CharArray prefix, CharArray localName, CharArray qname, String type, CharArray value) throws Exception {
        if (this.contentHandler != null || this.documentHandler != null) {
            ++this.at;
            String sURI = this.get(uri != null ? uri : CharArray.EMPTY);
            String sQname = this.get(qname);
            String sValue = this.get(value);
            String sType = type;
            if (this.contentHandler != null) {
                String sLname = null;
                sLname = localName.length() > 0 ? this.get(localName) : sQname;
                this.attImpl.addAttribute(sURI, sLname, sQname, sType, sValue);
            }
            if (this.documentHandler != null) {
                this.attListImpl.addAttribute(sQname, sType, sValue);
            }
        }
    }

    public void startElementEnd(boolean isEmpty) throws Exception {
        if (this.contentHandler != null) {
            this.contentHandler.startElement(this.stUR, this.stLN, this.stQN, this.attImpl);
        }
        if (this.documentHandler != null) {
            this.documentHandler.startElement(this.stQN, this.attListImpl);
        }
    }

    public void endElement(CharArray uri, CharArray localName, CharArray qname, boolean isEmpty) throws Exception {
        if (this.contentHandler != null) {
            this.contentHandler.endElement(this.get(uri != null ? uri : CharArray.EMPTY), this.get(localName), this.get(qname));
        }
        if (this.documentHandler != null) {
            this.documentHandler.endElement(this.get(qname));
        }
    }

    public void endElement(CharArray QName2, CharArray prefix, CharArray localName, String uri) throws Exception {
        if (this.contentHandler != null) {
            this.contentHandler.endElement(uri, this.get(localName), this.get(QName2));
        }
        if (this.documentHandler != null) {
            this.documentHandler.endElement(this.get(QName2));
        }
    }

    public void startDocument() throws Exception {
        this.namestack.clear();
        this.cursize = 0;
        if (this.contentHandler != null) {
            this.contentHandler.startDocument();
        }
        if (this.documentHandler != null) {
            this.documentHandler.startDocument();
        }
    }

    public void endDocument() throws Exception {
        if (this.contentHandler != null) {
            this.contentHandler.endDocument();
        }
        if (this.documentHandler != null) {
            this.documentHandler.endDocument();
        }
    }

    public void charData(CharArray data, boolean bDisableOutputEscaping) throws Exception {
        ++this.cd;
        if (this.contentHandler != null) {
            this.contentHandler.characters(data.getData(), data.getOffset(), data.getSize());
        }
        if (this.documentHandler != null) {
            this.documentHandler.characters(data.getData(), data.getOffset(), data.getSize());
        }
    }

    public void onPI(CharArray target, CharArray data) throws Exception {
        ++this.pi;
        if (this.contentHandler != null) {
            this.contentHandler.processingInstruction(target.getString(), data.getString());
        }
        if (this.documentHandler != null) {
            this.documentHandler.processingInstruction(target.getString(), data.getString());
        }
    }

    public void onComment(CharArray text) throws Exception {
        ++this.cm;
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(text.getData(), text.getOffset(), text.getSize());
        }
    }

    public void onCDSect(CharArray text) throws Exception {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
        if (this.contentHandler != null) {
            this.contentHandler.characters(text.getData(), text.getOffset(), text.getSize());
        }
        if (this.documentHandler != null) {
            this.documentHandler.characters(text.getData(), text.getOffset(), text.getSize());
        }
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    public void onDTDElement(CharArray name, CharArray model) throws Exception {
        if (this.declHandler != null) {
            this.declHandler.elementDecl(name.getString(), model.getString());
        }
    }

    public void onDTDAttListStart(CharArray name) throws Exception {
    }

    public void onDTDAttListItem(CharArray name, CharArray attName, String type, String defDecl, CharArray vAttValue, String note) throws Exception {
        if (this.declHandler != null) {
            if (defDecl != null && defDecl.length() == 0) {
                defDecl = null;
            }
            this.declHandler.attributeDecl(name.getString(), attName.getString(), type, defDecl, vAttValue.length() > 0 ? vAttValue.getString() : null);
        }
    }

    public void onDTDAttListEnd() throws Exception {
    }

    public void onDTDEntity(Entity ent) throws Exception {
        if (ent.isInternal()) {
            if (this.declHandler != null) {
                this.declHandler.internalEntityDecl(ent.getName().toString(), ent.getValue().toString());
            }
        } else if (!ent.isInternal() && !ent.isUnparsed()) {
            if (this.declHandler != null) {
                this.declHandler.externalEntityDecl(ent.getName().toString(), ent.getPub().toString(), ent.getSys().toString());
            }
        } else if (ent.isUnparsed() && this.dtdHandler != null) {
            this.dtdHandler.unparsedEntityDecl(ent.getName().toString(), ent.getPub().toString(), ent.getSys().toString(), ent.getNote().toString());
        }
    }

    public void onDTDNotation(CharArray name, CharArray pub, CharArray sys) throws Exception {
        if (this.dtdHandler != null) {
            String ps = pub.length() == 0 ? null : pub.getString();
            String ss = sys.length() == 0 ? null : sys.getString();
            this.dtdHandler.notationDecl(name.getString(), ps, ss);
        }
    }

    public void startDTD(CharArray name, CharArray pub, CharArray sys) throws Exception {
        if (this.lexicalHandler != null) {
            String ps = pub.length() == 0 ? null : pub.getString();
            String ss = sys.length() == 0 ? null : sys.getString();
            this.lexicalHandler.startDTD(name.getString(), ps, ss);
        }
    }

    public void endDTD() throws Exception {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endDTD();
        }
    }

    public void onContentReference(Reference ref) throws Exception {
        if (this.lexicalHandler != null && this.contentHandler != null) {
            this.lexicalHandler.startEntity(ref.getName().toString());
            String res = ref.resolve();
            char[] data = new char[res.length()];
            res.getChars(0, data.length, data, 0);
            this.contentHandler.characters(data, 0, data.length);
            this.lexicalHandler.endEntity(ref.getName().toString());
        }
    }

    public void startPrefixMapping(CharArray prefix, CharArray uri) throws Exception {
        if (this.contentHandler != null) {
            this.contentHandler.startPrefixMapping(this.get(prefix), this.get(uri != null ? uri : CharArray.EMPTY));
        }
    }

    public void endPrefixMapping(CharArray prefix) throws Exception {
        if (this.contentHandler != null) {
            this.contentHandler.endPrefixMapping(prefix.toString());
        }
    }

    public DeclHandler getDeclHandler() {
        return this.declHandler;
    }

    public void setDeclHandler(DeclHandler declHandler) {
        this.declHandler = declHandler;
    }

    public DocumentHandler getDocumentHandler() {
        return this.documentHandler;
    }

    public void setDocumentHandler(DocumentHandler documentHandler) {
        this.documentHandler = documentHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setDTDHandler(DTDHandler dtdHandler) {
        this.dtdHandler = dtdHandler;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void onWarning(String warning) throws Exception {
        if (this.errorHandler != null) {
            this.errorHandler.warning(new SAXParseException(warning, new LocatorImpl()));
        }
    }

    public void onStartContentEntity(CharArray name, boolean isExpanding) throws Exception {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(this.get(name));
        }
    }

    public void onEndContentEntity(CharArray name) throws Exception {
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(this.get(name));
        }
    }

    public void onCustomEvent(int eventId, Object obj) throws Exception {
        if (eventId == 1003 && this.contentHandler != null) {
            this.contentHandler.skippedEntity(((CharArray)obj).toString());
        }
    }
}

