/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.binary.util.base;

import com.sap.engine.lib.xml.parser.binary.util.AbstractDataStructure;
import com.sap.engine.lib.xml.parser.binary.util.base.NextItem;
import com.sap.engine.lib.xml.parser.binary.util.iterators.ForwardIterator;
import com.sap.engine.lib.xml.parser.binary.util.iterators.IteratorException;
import com.sap.engine.lib.xml.parser.binary.util.iterators.RootIterator;

public class BaseLinkedList
extends AbstractDataStructure {
    protected NextItem first = null;
    protected NextItem last = null;
    protected int limit;

    public BaseLinkedList(int limit) {
        this.setLimit(limit);
    }

    protected void addFirst_(NextItem item) {
        item.setNext(this.first);
        this.first = item;
        if (this.last == null) {
            this.last = this.first;
        }
        ++this.count;
    }

    protected void addLast_(NextItem item) {
        if (this.count == 0) {
            item.setNext(null);
            this.first = item;
            this.last = item;
        } else {
            this.last.setNext(item);
            item.setNext(null);
            this.last = item;
        }
        ++this.count;
    }

    public NextItem removeFirstItem() {
        if (this.count == 0) {
            return null;
        }
        NextItem temp = this.first;
        this.first = this.first.getNext();
        --this.count;
        if (this.count == 0) {
            this.last = null;
        }
        temp.clearItem();
        return temp;
    }

    public void clear() {
        this.first = null;
        this.last = null;
        this.count = 0;
    }

    public void setLimit(int limit) {
        this.limit = limit <= 0 ? Integer.MAX_VALUE : limit;
    }

    protected NextItem iterNext(RootIterator rootIter, int offset) {
        BaseLinkedListIterator iter = (BaseLinkedListIterator)rootIter;
        NextItem endNext = iter.end.getNext();
        if (offset < 0) {
            throw new IteratorException("Invalid argument: " + offset + " < 0");
        }
        if (iter.pointer == endNext) {
            throw new IteratorException("End of Iterator reached!");
        }
        int i = 0;
        while (i < offset) {
            if (iter.pointer == endNext) {
                throw new IteratorException("Specified position exceeds the end of Iterator!");
            }
            ++i;
            iter.pointer = iter.pointer.getNext();
        }
        iter.beforePointer = iter.pointer;
        iter.pointer = iter.pointer.getNext();
        return iter.beforePointer;
    }

    protected class BaseLinkedListIterator
    implements ForwardIterator {
        protected NextItem start;
        protected NextItem end;
        protected NextItem pointer;
        protected NextItem beforePointer;

        protected BaseLinkedListIterator() {
            this.start = BaseLinkedList.this.first;
            this.end = BaseLinkedList.this.last;
            this.pointer = this.start;
            this.beforePointer = null;
        }

        public boolean isAtEnd() {
            return this.end == null ? true : this.pointer == this.end.getNext();
        }

        public Object next() {
            return BaseLinkedList.this.iterNext(this, 0);
        }
    }
}

