/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.xpath;

import com.sap.engine.lib.schema.util.Tools;

public class XPathStepObject {
    public static final String PREDICATE_START_IDENTIFIER = "[";
    public static final String PREDICATE_END_IDENTIFIER = "]";
    static final String ATTRIBUTE_IDENTIFIER = "@";
    private static final String PREFIX_DELIMITER = ":";
    private String qNameWithPrefix;
    private String qNameWithUri;
    private String qNameWithUriWithoutPosition;
    private String uri;
    private String localName;
    private String prefix;
    private int position;
    private boolean isAttribute;

    public XPathStepObject(String qName, String uri) {
        this(qName, 0, uri);
    }

    public XPathStepObject(String qName, int position, String uri) {
        this.uri = uri;
        this.init(qName, position);
    }

    private void init(String qName, int position) {
        this.isAttribute = qName.startsWith(ATTRIBUTE_IDENTIFIER);
        if (this.isAttribute) {
            qName = qName.substring(1);
        }
        String[] prefixAndLocalName = Tools.parseQName(qName);
        this.prefix = prefixAndLocalName[0];
        this.localName = prefixAndLocalName[1];
        this.qNameWithPrefix = this.isAttribute ? ATTRIBUTE_IDENTIFIER + Tools.formatQNameWithPrefix(this.prefix, this.localName) : Tools.formatQNameWithPrefix(this.prefix, this.localName);
        this.qNameWithUriWithoutPosition = this.isAttribute ? ATTRIBUTE_IDENTIFIER + Tools.formatQNameWithUri(this.uri, this.localName) : Tools.formatQNameWithUri(this.uri, this.localName);
        this.position = position;
        this.qNameWithUri = this.qNameWithUriWithoutPosition + (position > 0 ? PREDICATE_START_IDENTIFIER + position + PREDICATE_END_IDENTIFIER : "");
    }

    public String getQNameWithUri() {
        return this.qNameWithUri;
    }

    public String getQNameWithPrefix() {
        return this.qNameWithPrefix;
    }

    public String getQNameWithoutPosition() {
        return this.qNameWithUriWithoutPosition;
    }

    public String getUri() {
        return this.uri;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean isAttribute() {
        return this.isAttribute;
    }

    public String toString() {
        return this.qNameWithUri;
    }
}

