/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ModelGroup;
import com.sap.engine.lib.schema.components.Particle;
import com.sap.engine.lib.schema.components.impl.BaseInfo;
import com.sap.engine.lib.schema.components.impl.SchemaStructuresFactory;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.ParticleImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ModelGroupImpl
extends BaseImpl
implements ModelGroup {
    protected static final int ALL = 1;
    protected static final int CHOICE = 2;
    protected static final int SEQUENCE = 3;
    protected int compositor;
    protected Vector particlesCollector = new Vector();

    public ModelGroupImpl() {
        this(null);
    }

    public ModelGroupImpl(BaseInfo baseInfo) {
        this(null, baseInfo);
    }

    public ModelGroupImpl(Node associatedNode, BaseInfo baseInfo) {
        super(associatedNode, baseInfo);
    }

    public boolean isCompositorAll() {
        return this.compositor == 1;
    }

    public boolean isCompositorChoice() {
        return this.compositor == 2;
    }

    public boolean isCompositorSequence() {
        return this.compositor == 3;
    }

    public void getParticles(Vector collector) {
        Tools.removeFromVectorToVector(this.particlesCollector, collector);
    }

    public Particle[] getParticlesArray() {
        Object[] result = new Particle[this.particlesCollector.size()];
        this.particlesCollector.copyInto(result);
        return result;
    }

    public int getTypeOfComponent() {
        return 7;
    }

    public boolean match(Base modelGroup) {
        if (!super.match(modelGroup)) {
            return false;
        }
        ModelGroupImpl targetModelGroup = (ModelGroupImpl)modelGroup;
        if (this.compositor != targetModelGroup.compositor) {
            return false;
        }
        if (this.compositor == 3) {
            return Tools.compareOrderedSetsOfBases(this.particlesCollector, targetModelGroup.particlesCollector);
        }
        return Tools.compareUnorderdSetsOfBases(this.particlesCollector, targetModelGroup.particlesCollector);
    }

    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            this.id = this.loadAttribsCollector.getProperty("id");
            String associatedNodeLocalName = this.associatedNode.getLocalName();
            if (associatedNodeLocalName.equals("all")) {
                this.compositor = 1;
            } else if (associatedNodeLocalName.equals("choice")) {
                this.compositor = 2;
            } else if (associatedNodeLocalName.equals("sequence")) {
                this.compositor = 3;
            }
            NodeList nodeList = this.associatedNode.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                String nodeUri;
                Node node = nodeList.item(i);
                if (node instanceof Element && (nodeUri = node.getNamespaceURI()) != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema")) {
                    String nodeLocalName = node.getLocalName();
                    if (nodeLocalName.equals("element") || nodeLocalName.equals("choice") || nodeLocalName.equals("sequence") || nodeLocalName.equals("group") || nodeLocalName.equals("any")) {
                        ParticleImpl particle = SchemaStructuresFactory.createParticle(node, this.baseInfo);
                        SchemaStructuresFactory.loadBase(particle);
                        this.particlesCollector.add(particle);
                    } else if (nodeLocalName.equals("annotation")) {
                        this.annotation = SchemaStructuresFactory.createAnnotation(node, this.baseInfo);
                        SchemaStructuresFactory.loadBase(this.annotation);
                    }
                }
                ++i;
            }
        }
    }

    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        ModelGroupImpl result = (ModelGroupImpl)super.initializeBase(base, clonedCollector);
        result.compositor = this.compositor;
        Tools.cloneVectorWithBases(this.particlesCollector, result.particlesCollector, clonedCollector);
        return result;
    }
}

