/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.ElementDeclaration;
import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.components.impl.BaseInfo;
import com.sap.engine.lib.schema.components.impl.SchemaStructuresFactory;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.ComplexTypeDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.IdentityConstraintDefinitionImpl;
import com.sap.engine.lib.schema.components.impl.structures.InfoItemDeclarationBaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.TypeDefinitionBaseImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.schema.util.Tools;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class ElementDeclarationImpl
extends InfoItemDeclarationBaseImpl
implements ElementDeclaration {
    protected boolean isNillable;
    protected ElementDeclarationImpl substitutionGroupAffiliation;
    protected boolean isAbstract;
    protected Vector identityConstrDefsCollector = new Vector();
    protected Hashtable substitutableElemDeclrsCollector = new Hashtable();
    protected boolean isSubstitutionGroupExclusionExtension;
    protected boolean isSubstitutionGroupExclusionRestriction;
    protected boolean isDisallowedSubstitutionSubstitution;
    protected boolean isDisallowedSubstitutionExtension;
    protected boolean isDisallowedSubstitutionRestriction;

    public ElementDeclarationImpl() {
        this(null, null);
    }

    public ElementDeclarationImpl(Node associatedNode, BaseInfo baseInfo) {
        this(associatedNode, baseInfo, false);
    }

    public ElementDeclarationImpl(Node associatedNode, BaseInfo baseInfo, boolean isTopLevel) {
        super(associatedNode, baseInfo, isTopLevel);
    }

    public boolean isNillable() {
        return this.isNillable;
    }

    public void getIdentityConstraintDefinitions(Vector collector) {
        Tools.removeFromVectorToVector(this.identityConstrDefsCollector, collector);
    }

    public IdentityConstraintDefinition[] getIdentityConstraintDefinitionsArray() {
        Object[] result = new IdentityConstraintDefinition[this.identityConstrDefsCollector.size()];
        this.identityConstrDefsCollector.copyInto(result);
        return result;
    }

    public void getSubstitutableElementDeclarations(Vector collector) {
        Tools.removeFromHashtableToVector(this.substitutableElemDeclrsCollector, collector);
    }

    public ElementDeclaration[] getSubstitutableElementDeclarationsArray() {
        Vector substitutableElemDeclrsCollectorVector = new Vector();
        this.getSubstitutableElementDeclarations(substitutableElemDeclrsCollectorVector);
        Object[] result = new ElementDeclaration[substitutableElemDeclrsCollectorVector.size()];
        substitutableElemDeclrsCollectorVector.copyInto(result);
        return result;
    }

    public ElementDeclaration getSubstitutableElementDeclaration(String targetNamespace, String name) {
        return (ElementDeclaration)this.substitutableElemDeclrsCollector.get(Tools.generateKey(targetNamespace, name));
    }

    public ElementDeclaration getSubstitutionGroupAffiliation() {
        return this.substitutionGroupAffiliation;
    }

    public boolean isSubstitutionGroupExclusionExtension() {
        return this.isSubstitutionGroupExclusionExtension;
    }

    public boolean isSubstitutionGroupExclusionRestriction() {
        return this.isSubstitutionGroupExclusionRestriction;
    }

    public boolean isDisallowedSubstitutionSubstitution() {
        return this.isDisallowedSubstitutionSubstitution;
    }

    public boolean isDisallowedSubstitutionExtension() {
        return this.isDisallowedSubstitutionExtension;
    }

    public boolean isDisallowedSubstitutionRestriction() {
        return this.isDisallowedSubstitutionRestriction;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public int getTypeOfComponent() {
        return 3;
    }

    public boolean match(Base elementDeclr) {
        if (!super.match(elementDeclr)) {
            return false;
        }
        ElementDeclarationImpl targetElemDeclr = (ElementDeclarationImpl)elementDeclr;
        return this.isNillable == targetElemDeclr.isNillable && this.isAbstract == targetElemDeclr.isAbstract && Tools.compareUnorderdSetsOfBases(this.identityConstrDefsCollector, targetElemDeclr.identityConstrDefsCollector) && Tools.compareBases(this.substitutionGroupAffiliation, targetElemDeclr.substitutionGroupAffiliation) && this.isSubstitutionGroupExclusionExtension == targetElemDeclr.isSubstitutionGroupExclusionExtension && this.isSubstitutionGroupExclusionRestriction == targetElemDeclr.isSubstitutionGroupExclusionRestriction && this.isDisallowedSubstitutionSubstitution == targetElemDeclr.isDisallowedSubstitutionSubstitution && this.isDisallowedSubstitutionExtension == targetElemDeclr.isDisallowedSubstitutionExtension && this.isDisallowedSubstitutionRestriction == targetElemDeclr.isDisallowedSubstitutionRestriction;
    }

    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            String substGroupAffilAttribValue;
            String blockAttribValue;
            String abstractAttribValue;
            String typeDefAttribValue = this.loadAttribsCollector.getProperty("type");
            if (typeDefAttribValue != null) {
                this.typeDefinition = (TypeDefinitionBaseImpl)this.getTopLevelBase(this.associatedNode, typeDefAttribValue, 16);
                SchemaStructuresFactory.loadBase(this.typeDefinition);
            }
            this.defaultValue = this.loadAttribsCollector.getProperty("default");
            this.fixedValue = this.loadAttribsCollector.getProperty("fixed");
            this.id = this.loadAttribsCollector.getProperty("id");
            String nillableAttribValue = this.loadAttribsCollector.getProperty("nillable");
            if (nillableAttribValue != null) {
                this.isNillable = nillableAttribValue.equals("true");
                if (this.isNillable && this.fixedValue != null) {
                    throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Defintion of element declaration " + DOM.toXPath(this.associatedNode) + " is not correct. If there is an {nillable}, which is set to 'true', there must not be fixed {value constraint}.");
                }
            }
            if ((abstractAttribValue = this.loadAttribsCollector.getProperty("abstract")) != null) {
                this.isAbstract = abstractAttribValue.equals("true");
            }
            if ((blockAttribValue = this.loadAttribsCollector.getProperty("block")) != null) {
                if (blockAttribValue.equals("#all")) {
                    this.isDisallowedSubstitutionSubstitution = true;
                    this.isDisallowedSubstitutionExtension = true;
                    this.isDisallowedSubstitutionRestriction = true;
                } else {
                    StringTokenizer tokenizer = new StringTokenizer(blockAttribValue);
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (token.equals("substitution")) {
                            this.isDisallowedSubstitutionSubstitution = true;
                            continue;
                        }
                        if (token.equals("extension")) {
                            this.isDisallowedSubstitutionExtension = true;
                            continue;
                        }
                        if (!token.equals("restriction")) continue;
                        this.isDisallowedSubstitutionRestriction = true;
                    }
                }
            } else {
                this.isDisallowedSubstitutionSubstitution = this.baseInfo.isProhibitedSubstitution();
                this.isDisallowedSubstitutionRestriction = this.baseInfo.isProhibitedRestriction();
                this.isDisallowedSubstitutionExtension = this.baseInfo.isProhibitedExtension();
            }
            String finalAttribValue = this.loadAttribsCollector.getProperty("final");
            if (finalAttribValue != null) {
                if (finalAttribValue.equals("#all")) {
                    this.isSubstitutionGroupExclusionExtension = true;
                    this.isSubstitutionGroupExclusionRestriction = true;
                } else {
                    StringTokenizer tokenizer = new StringTokenizer(finalAttribValue);
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (token.equals("extension")) {
                            this.isSubstitutionGroupExclusionExtension = true;
                            continue;
                        }
                        if (!token.equals("restriction")) continue;
                        this.isSubstitutionGroupExclusionRestriction = true;
                    }
                }
            } else {
                this.isSubstitutionGroupExclusionExtension = this.baseInfo.isFinalExtension();
                this.isSubstitutionGroupExclusionRestriction = this.baseInfo.isFinalRestriction();
            }
            NodeList nodeList = this.associatedNode.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                String nodeUri;
                Node node = nodeList.item(i);
                if (node instanceof Element && (nodeUri = node.getNamespaceURI()) != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema")) {
                    String nodeLocalName = node.getLocalName();
                    if (nodeLocalName.equals("simpleType")) {
                        if (this.typeDefinition != null) {
                            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of attribute declaration " + DOM.toXPath(this.associatedNode) + " is not correct. 'Type', <simpleType> and <complexType> are exclusive.");
                        }
                        this.typeDefinition = SchemaStructuresFactory.createSimpleTypeDefinition(node, this.baseInfo);
                        SchemaStructuresFactory.loadBase(this.typeDefinition);
                    } else if (nodeLocalName.equals("complexType")) {
                        if (this.typeDefinition != null) {
                            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of attribute declaration " + DOM.toXPath(this.associatedNode) + " is not correct. 'Type', <simpleType> and <complexType> are exclusive.");
                        }
                        this.typeDefinition = SchemaStructuresFactory.createComplexTypeDefinition(node, this.baseInfo);
                        SchemaStructuresFactory.loadBase(this.typeDefinition);
                    } else if (nodeLocalName.equals("key") || nodeLocalName.equals("keyref") || nodeLocalName.equals("unique")) {
                        IdentityConstraintDefinitionImpl identConstrDef = new IdentityConstraintDefinitionImpl(node, this.baseInfo);
                        identConstrDef.owner = this;
                        this.identityConstrDefsCollector.add(identConstrDef);
                        this.baseInfo.getSchema().addIdentityConstraintDefinition(identConstrDef);
                    } else if (nodeLocalName.equals("annotation")) {
                        this.annotation = SchemaStructuresFactory.createAnnotation(node, this.baseInfo);
                        SchemaStructuresFactory.loadBase(this.annotation);
                    }
                }
                ++i;
            }
            if (this.typeDefinition == null) {
                this.typeDefinition = (TypeDefinitionBaseImpl)this.baseInfo.getSchema().getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "anyType");
            }
            if ((substGroupAffilAttribValue = this.loadAttribsCollector.getProperty("substitutionGroup")) != null) {
                this.substitutionGroupAffiliation = (ElementDeclarationImpl)this.getTopLevelBase(this.associatedNode, substGroupAffilAttribValue, 3);
                SchemaStructuresFactory.loadBase(this.substitutionGroupAffiliation);
                boolean disallowedRestriction = this.substitutionGroupAffiliation.isSubstitutionGroupExclusionRestriction;
                boolean disallowedExtension = this.substitutionGroupAffiliation.isSubstitutionGroupExclusionExtension;
                if (this.substitutionGroupAffiliation.typeDefinition instanceof ComplexTypeDefinitionImpl) {
                    disallowedRestriction = disallowedRestriction || ((ComplexTypeDefinitionImpl)this.substitutionGroupAffiliation.typeDefinition).isFinalRestriction;
                    boolean bl = disallowedExtension = disallowedExtension || ((ComplexTypeDefinitionImpl)this.substitutionGroupAffiliation.typeDefinition).isFinalExtension;
                }
                if (!this.typeDefinition.isDerivedFrom(this.substitutionGroupAffiliation.typeDefinition, disallowedRestriction, disallowedExtension)) {
                    throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Defintion of element declaration " + DOM.toXPath(this.associatedNode) + " is not correct. If there is an {substitution group affiliation}, the {type definition} of the element declaration must be validly derived from the {type definition} of the {substitution group affiliation}.");
                }
                this.substitutionGroupAffiliation.substitutableElemDeclrsCollector.put(this.qualifiedKey, this);
            }
            this.checkValueConstraint();
            this.baseInfo.getSchema().allComponentsCollector.add(this);
        }
    }

    protected BaseImpl initializeBase(BaseImpl base, Hashtable clonedCollector) {
        ElementDeclarationImpl result = (ElementDeclarationImpl)super.initializeBase(base, clonedCollector);
        result.isNillable = this.isNillable;
        if (this.substitutionGroupAffiliation != null) {
            result.substitutionGroupAffiliation = (ElementDeclarationImpl)this.substitutionGroupAffiliation.clone(clonedCollector);
        }
        result.isAbstract = this.isAbstract;
        Tools.cloneVectorWithBases(this.identityConstrDefsCollector, result.identityConstrDefsCollector, clonedCollector);
        Tools.cloneHashtableWithBases(this.substitutableElemDeclrsCollector, result.substitutableElemDeclrsCollector, clonedCollector);
        result.isSubstitutionGroupExclusionExtension = this.isSubstitutionGroupExclusionExtension;
        result.isSubstitutionGroupExclusionRestriction = this.isSubstitutionGroupExclusionRestriction;
        result.isDisallowedSubstitutionSubstitution = this.isDisallowedSubstitutionSubstitution;
        result.isDisallowedSubstitutionExtension = this.isDisallowedSubstitutionExtension;
        result.isDisallowedSubstitutionRestriction = this.isDisallowedSubstitutionRestriction;
        return result;
    }
}

