/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xsl.xpath;

import com.inqmy.lib.xsl.xpath.SegmentedIntSetIterator;

public final class SegmentedIntSetIteratorPool {
    private int initialSize;
    private int resizeStep = 100;
    private int pos;
    private SegmentedIntSetIterator[] arrayOfObjects;
    private SegmentedIntSetIterator temp;

    public int getPos() {
        return this.pos;
    }

    public void releasePool() {
        this.pos = this.arrayOfObjects.length - 1;
    }

    public SegmentedIntSetIteratorPool(int initSize, int step) {
        if (step < 1 || initSize < 1) {
            throw new IllegalArgumentException("Wrong value of initialSize or resizeStep parameter");
        }
        this.initialSize = initSize;
        this.resizeStep = step;
        this.arrayOfObjects = new SegmentedIntSetIterator[this.initialSize];
        int i = 0;
        while (i < this.initialSize) {
            this.arrayOfObjects[i] = new SegmentedIntSetIterator();
            ++i;
        }
        this.pos = this.initialSize - 1;
    }

    public SegmentedIntSetIterator getObject() {
        if (this.pos < 0) {
            this.autoResize();
        }
        return this.arrayOfObjects[this.pos--];
    }

    public synchronized void releaseObject(SegmentedIntSetIterator obj) {
        if (this.pos < this.arrayOfObjects.length - 1) {
            ++this.pos;
            this.arrayOfObjects[this.pos] = obj;
        }
    }

    public synchronized void setResizeStep(int step) {
        if (step < 1) {
            throw new IllegalArgumentException("Wrong value of resizeStep parameter");
        }
        this.resizeStep = step;
    }

    public int getResizeStep() {
        return this.resizeStep;
    }

    public synchronized void setInitialSize(int initSize) {
        if (initSize < 1) {
            throw new IllegalArgumentException("Wrong value of initSize parameter");
        }
        this.initialSize = initSize;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void release() {
        int i = 0;
        while (i < this.pos) {
            this.arrayOfObjects[i] = null;
            ++i;
        }
    }

    public synchronized void forceShrink() {
        int usedElements = this.arrayOfObjects.length - this.pos - 1;
        if (usedElements >= this.initialSize) {
            if (this.pos >= 0) {
                this.arrayOfObjects = new SegmentedIntSetIterator[usedElements];
                this.pos = -1;
            }
        } else if (this.arrayOfObjects.length != this.initialSize) {
            SegmentedIntSetIterator[] tempArr = new SegmentedIntSetIterator[this.initialSize];
            int newPos = this.initialSize - usedElements - 1;
            if (newPos <= this.pos) {
                System.arraycopy(this.arrayOfObjects, 0, tempArr, 0, newPos + 1);
            } else {
                if (this.pos >= 0) {
                    System.arraycopy(this.arrayOfObjects, 0, tempArr, 0, this.pos + 1);
                }
                int i = this.pos + 1;
                while (i < newPos) {
                    tempArr[i] = new SegmentedIntSetIterator();
                    ++i;
                }
            }
            this.arrayOfObjects = tempArr;
            this.pos = newPos;
        }
    }

    private void autoResize() {
        SegmentedIntSetIterator[] tempArr = new SegmentedIntSetIterator[this.arrayOfObjects.length + this.resizeStep];
        int i = 0;
        while (i < this.resizeStep) {
            tempArr[i] = new SegmentedIntSetIterator();
            ++i;
        }
        int i2 = 0;
        while (i2 < this.arrayOfObjects.length) {
            tempArr[i2 + this.resizeStep] = this.arrayOfObjects[i2];
            ++i2;
        }
        this.arrayOfObjects = tempArr;
        this.pos = this.resizeStep - 1;
    }

    public void check() throws Exception {
        int i = 0;
        while (i < this.arrayOfObjects.length) {
            int j = i + 1;
            while (j < this.arrayOfObjects.length) {
                if (this.arrayOfObjects[i] == this.arrayOfObjects[j]) {
                    throw new Exception("they are equal:" + i + "," + j + " " + this.arrayOfObjects[i] + ", " + this.arrayOfObjects[j]);
                }
                ++j;
            }
            ++i;
        }
    }
}

