/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xml.parser.handlers;

import java.io.IOException;
import java.io.InputStream;

public class UTF16Handler {
    InputStream is = null;
    byte[] buffer = new byte[512];
    int buffertop = 0;
    int bufferindex = 0;
    boolean endofstream = false;
    boolean littleendian = false;

    public UTF16Handler(InputStream istream) throws IOException {
        this.is = istream;
        byte[] byteordermark = new byte[2];
        this.is.read(byteordermark);
        if (byteordermark[0] == 255 && byteordermark[1] == 254) {
            this.littleendian = true;
        } else if (byteordermark[0] == 254 && byteordermark[1] == 255) {
            this.littleendian = false;
        }
    }

    public char nextCharacter() throws IOException {
        if (!this.endofstream) {
            if (this.bufferindex >= this.buffertop) {
                this.buffertop = this.is.read(this.buffer);
                if (this.buffertop > -1 && this.buffertop % 2 == 1) {
                    --this.buffertop;
                }
                --this.buffertop;
                this.bufferindex = 0;
            }
            if (this.bufferindex < this.buffertop) {
                if (this.littleendian) {
                    char c = (char)(this.buffer[this.bufferindex + 1] << 8 + this.buffer[this.bufferindex]);
                    this.bufferindex += 2;
                    return c;
                }
                char c = (char)(this.buffer[this.bufferindex] << 8 + this.buffer[this.bufferindex + 1]);
                this.bufferindex += 2;
                return c;
            }
            this.endofstream = true;
        }
        return '\u0000';
    }

    public int decodeToUCS4(int[] buf, int length) throws IOException {
        boolean illegalcharacter = false;
        char c = '\u0000';
        char c1 = '\u0000';
        int bufindex = 0;
        while (bufindex < length) {
            if (illegalcharacter) {
                c = c1;
                illegalcharacter = false;
            } else {
                c = this.nextCharacter();
            }
            if (!this.endofstream) {
                if ((c & 0xD800) == 55296) {
                    c1 = this.nextCharacter();
                    if (!this.endofstream) {
                        if ((c1 & 0xDC00) == 56320) {
                            buf[bufindex] = (c & 0x3FF) << 10 + (c1 & 0x3FF) + 65536;
                        } else {
                            illegalcharacter = true;
                            buf[bufindex] = c;
                        }
                    } else {
                        illegalcharacter = true;
                        buf[bufindex] = c;
                    }
                } else {
                    buf[bufindex] = c;
                }
                ++bufindex;
            }
            ++bufindex;
        }
        return bufindex;
    }
}

