/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.components.impl0;

import com.inqmy.lib.schema.components.Base;
import com.inqmy.lib.schema.components.Facet;
import com.inqmy.lib.schema.components.Schema;
import com.inqmy.lib.schema.components.SchemaComponentException;
import com.inqmy.lib.schema.components.impl0.AnnotationImpl;
import com.inqmy.lib.schema.components.impl0.AttributeDeclarationImpl;
import com.inqmy.lib.schema.components.impl0.AttributeGroupDefinitionImpl;
import com.inqmy.lib.schema.components.impl0.AttributeUseImpl;
import com.inqmy.lib.schema.components.impl0.BaseImpl;
import com.inqmy.lib.schema.components.impl0.ComplexTypeDefinitionImpl;
import com.inqmy.lib.schema.components.impl0.ComponentPrinter;
import com.inqmy.lib.schema.components.impl0.ComponentPrinterToHTML;
import com.inqmy.lib.schema.components.impl0.ElementDeclarationImpl;
import com.inqmy.lib.schema.components.impl0.FacetImpl;
import com.inqmy.lib.schema.components.impl0.IdentityConstraintDefinitionImpl;
import com.inqmy.lib.schema.components.impl0.ModelGroupDefinitionImpl;
import com.inqmy.lib.schema.components.impl0.ModelGroupImpl;
import com.inqmy.lib.schema.components.impl0.NotationDeclarationImpl;
import com.inqmy.lib.schema.components.impl0.ParticleImpl;
import com.inqmy.lib.schema.components.impl0.Ref;
import com.inqmy.lib.schema.components.impl0.SchemaImpl;
import com.inqmy.lib.schema.components.impl0.SchemaInfoImpl;
import com.inqmy.lib.schema.components.impl0.SimpleTypeDefinitionImpl;
import com.inqmy.lib.schema.components.impl0.WildcardImpl;
import com.inqmy.lib.xml.dom.DOM;
import com.inqmy.lib.xml.names.EditDistance;
import com.inqmy.lib.xml.parser.URLLoaderBase;
import com.inqmy.lib.xml.util.ListSplitter;
import com.inqmy.lib.xml.util.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public final class LoaderImpl {
    protected static final boolean DEBUG = true;
    private static final String S_ABSTRACT = "abstract";
    private static final String S_ALL = "all";
    private static final String S_ANNOTATION = "annotation";
    private static final String S_ANY = "any";
    private static final String S_ATTRIBUTE = "attribute";
    private static final String S_ATTRIBUTE_FORM_DEFAULT = "attributeFormDefault";
    private static final String S_ATTRIBUTE_GROUP = "attributeGroup";
    private static final String S_BASE = "base";
    private static final String S_BLOCK = "block";
    private static final String S_BLOCK_DEFAULT = "blockDefault";
    private static final String S_CHOICE = "choice";
    private static final String S_COMPLEX_TYPE = "complexType";
    private static final String S_DEFAULT = "default";
    private static final String S_ELEMENT = "element";
    private static final String S_ELEMENT_FORM_DEFAULT = "elementFormDefault";
    private static final String S_EXTENSION = "extension";
    private static final String S_FALSE = "false";
    private static final String S_FINAL = "final";
    private static final String S_FIXED = "fixed";
    private static final String S_FINAL_DEFAULT = "finalDefault";
    private static final String S_FORM = "form";
    private static final String S_GROUP = "group";
    private static final String S_ID = "id";
    private static final String S_IMPORT = "import";
    private static final String S_INCLUDE = "include";
    private static final String S_MIN_OCCURS = "minOccurs";
    private static final String S_MAX_OCCURS = "maxOccurs";
    private static final String S_NAME = "name";
    private static final String S_NAMESPACE = "namespace";
    private static final String S_NOTATION = "notation";
    private static final String S_LIST = "list";
    private static final String S_REF = "ref";
    private static final String S_RESTRICTION = "restriction";
    private static final String S_REDEFINE = "redefine";
    private static final String S_SCHEMA = "schema";
    private static final String S_SCHEMA_LOCATION = "schemaLocation";
    private static final String S_SEQUENCE = "sequence";
    private static final String S_SIMPLE_TYPE = "simpleType";
    private static final String S_SUBSTITUTION = "substitution";
    private static final String S_TARGET_NAMESPACE = "targetNamespace";
    private static final String S_TRUE = "true";
    private static final String S_TYPE = "type";
    private static final String S_QUALIFIED = "qualified";
    private static final String S_UNQUALIFIED = "unqualified";
    private static final String S_USE = "use";
    private static final String S_UNION = "union";
    private static final String S_VALUE = "value";
    private static final String S_VERSION = "version";
    private static final String S_0 = "0";
    private static final String S_1 = "1";
    protected static final boolean ALLOW_ASSOCIATIONS_WITH_DOM = true;
    private static final String[] XS_NAMESPACES = new String[]{"http://www.w3.org/2001/XMLSchema", "http://www.w3.org/2000/10/XMLSchema", "http://www.w3.org/1999/XMLSchema"};
    private SchemaImpl schema;
    private ComponentPrinter printer = null;
    private ComponentPrinterToHTML printerToHTML = null;
    private String currentTargetNamespace;
    private boolean isAttributeFormDefaultQualified;
    private boolean isBlockDefaultExtension;
    private boolean isBlockDefaultRestriction;
    private boolean isBlockDefaultSubstitution;
    private boolean isElementFormDefaultQualified;
    private boolean isFinalDefaultExtension;
    private boolean isFinalDefaultRestriction;
    private Vector refs = new Vector();
    private Vector schemaInfos = new Vector();
    private SchemaInfoImpl currentSchemaInfo = null;
    private URIResolver uriResolver = null;
    private EntityResolver entityResolver = null;
    private Transformer transformer = null;
    private static final String[] ARR_E_R_S = new String[]{"extension", "restriction", "substitution"};
    private static final String[] ARR_E_R = new String[]{"extension", "restriction"};
    private static final String[] ARR_Q_U = new String[]{"qualified", "unqualified"};
    private static final String[] ATTRS_SCH = new String[]{"attributeFormDefault", "blockDefault", "elementFormDefault", "finalDefault", "targetNamespace", "version", "id"};
    private static final String[] ATTRS_INCLUDE = new String[]{"schemaLocation", "id"};
    private static final String[] ATTRS_IMPORT = new String[]{"schemaLocation", "namespace", "id"};
    private static final String[] ATTRS_AD = new String[]{"default", "fixed", "form", "name", "ref", "type", "use", "id"};
    private static final String[] ELTS_AD = new String[]{"annotation", "simpleType"};
    private static final String[] ATTRS_ED = new String[]{"abstract", "block", "default", "final", "fixed", "form", "maxOccurs", "minOccurs", "name", "nillable", "ref", "substitutionGroup", "type", "id"};
    private static final String[] ELTS_ED = new String[]{"annotation", "simpleType", "complexType", "unique", "key", "keyref"};
    private static final String[] ATTRS_CTD = new String[]{"abstract", "block", "final", "mixed", "name", "id"};
    private static final String[] ATTRS_MGD = new String[]{"name"};
    private static final String[] ATTRS_STD = new String[]{"final", "name"};
    private static final String[] ARR_E_L_R_U = new String[]{"extension", "list", "restriction", "union", "id"};
    private static final String[] SCHEMA_ELEMENT_NAMES = new String[]{"element", "complexType", "simpleType", "group", "attributeGroup", "notation", "include", "import", "attribute", "redefine", "annotation"};
    private static final String[] STRING_ARRAY_0 = new String[0];
    private static final Element[] ELEMENT_ARRAY_0 = new Element[0];
    static /* synthetic */ Class class$javax$xml$transform$TransformerFactory;
    static /* synthetic */ Class class$com$inqmy$lib$jaxp$TransformerFactoryImpl;

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public Schema load(Node node) throws SchemaComponentException {
        return this.load(new DOMSource(node));
    }

    private Schema load(String systemId, Node node) throws SchemaComponentException {
        return this.load(new DOMSource(node, systemId));
    }

    public Schema load(Source source) throws SchemaComponentException {
        this.schemaInfos.clear();
        this.schemaInfos.add(new SchemaInfoImpl(this, this.schema, null, null, null, source));
        this.process();
        return this.schema;
    }

    public Schema load(String[] systemIds, Node[] nodes) throws SchemaComponentException {
        if (systemIds == null || nodes == null || systemIds.length != nodes.length) {
            throw new IllegalArgumentException();
        }
        this.schemaInfos.clear();
        int n = nodes.length;
        int i = 0;
        while (i < n) {
            this.schemaInfos.add(new SchemaInfoImpl(this, this.schema, null, null, null, new DOMSource(nodes[i], systemIds[i])));
            ++i;
        }
        this.process();
        return this.schema;
    }

    private Schema process() throws SchemaComponentException {
        this.schema = new SchemaImpl();
        this.schema.setOwnerSchema(this.schema);
        this.refs.clear();
        block4: while (true) {
            int nSchemaInfos = this.schemaInfos.size();
            SchemaInfoImpl info = null;
            boolean found = false;
            int i = 0;
            while (i < nSchemaInfos) {
                info = (SchemaInfoImpl)this.schemaInfos.get(i);
                if (!info.isResolutionAttempted()) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) {
                Element element;
                info.resolve();
                this.currentSchemaInfo = info;
                if (!info.isSuccessfullyResolved()) continue;
                Node node = info.getNode();
                if (node instanceof Document) {
                    element = ((Document)node).getDocumentElement();
                } else if (node instanceof Element) {
                    element = (Element)node;
                } else {
                    throw new SchemaComponentException("The DOM node for the schema must be either an Element or a Document");
                }
                this.processSchema(element);
                continue;
            }
            int nRefs = this.refs.size();
            int i2 = 0;
            while (i2 < nRefs) {
                Ref ref = (Ref)this.refs.get(i2);
                int r = ref.resolve(this);
                if (r == 3) {
                    throw new SchemaComponentException("Contour in refs");
                }
                if (r == 2) {
                    block19: {
                        Source actualSource;
                        if (this.uriResolver != null) {
                            actualSource = null;
                            try {
                                actualSource = this.uriResolver.resolve(ref.getUri(), "xsd://");
                                if (actualSource != null) {
                                    this.schemaInfos.add(new SchemaInfoImpl(this, this.schema, this.currentSchemaInfo, null, null, actualSource));
                                    continue block4;
                                }
                                break block19;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                break block19;
                            }
                        }
                        if (this.entityResolver != null) {
                            actualSource = null;
                            try {
                                InputSource ins = this.entityResolver.resolveEntity("", ref.getUri());
                                if (actualSource == null) break block19;
                                StreamSource s = new StreamSource();
                                s.setSystemId(ins.getSystemId());
                                s.setInputStream(ins.getByteStream());
                                s.setReader(ins.getCharacterStream());
                                actualSource = s;
                                this.schemaInfos.add(new SchemaInfoImpl(this, this.schema, this.currentSchemaInfo, null, null, actualSource));
                                continue block4;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    throw new SchemaComponentException("Missing top level component: " + Base.NAMES_OF_COMPONENTS[ref.getToWhat()] + " {" + ref.getUri() + "}:" + ref.getLocal() + " (It has been referred from " + DOM.toXPath(ref.getElement()) + ")");
                }
                ++i2;
            }
            break;
        }
        Vector c = this.schema.components;
        int nC = c.size();
        int i = 0;
        while (i < nC) {
            ((BaseImpl)c.get(i)).finalizeResolution();
            ++i;
        }
        return this.schema;
    }

    private void processSchema(Element xsSchema) throws SchemaComponentException {
        int i;
        String[] x;
        if (!xsSchema.getLocalName().equals(S_SCHEMA)) {
            xsSchema = this.findXSSchema0(xsSchema);
        }
        String[] attrs = LoaderImpl.extractAttrs(xsSchema, ATTRS_SCH);
        String attrAttributeFormDefault = attrs[0];
        String attrBlockDefault = attrs[1];
        String attrElementFormDefault = attrs[2];
        String attrFinalDefault = attrs[3];
        String attrTargetNamespace = attrs[4];
        String attrVersion = attrs[5];
        if (attrAttributeFormDefault == null) {
            this.isAttributeFormDefaultQualified = false;
        } else if (attrAttributeFormDefault.equals(S_QUALIFIED)) {
            this.isAttributeFormDefaultQualified = true;
        } else if (attrAttributeFormDefault.equals(S_UNQUALIFIED)) {
            this.isAttributeFormDefaultQualified = false;
        } else {
            String mp = EditDistance.getMostProbable(attrAttributeFormDefault, ARR_Q_U, 2);
            throw new SchemaComponentException("attributeFormDefault should be either 'qualified' or 'unqualified', " + DOM.toXPath(xsSchema) + "." + (mp == null ? "" : " (Did you mean '" + mp + "'?)"));
        }
        if (attrElementFormDefault == null) {
            this.isElementFormDefaultQualified = false;
        } else if (attrElementFormDefault.equals(S_QUALIFIED)) {
            this.isElementFormDefaultQualified = true;
        } else if (attrElementFormDefault.equals(S_UNQUALIFIED)) {
            this.isElementFormDefaultQualified = false;
        } else {
            String mp = EditDistance.getMostProbable(attrElementFormDefault, ARR_Q_U, 2);
            throw new SchemaComponentException("elementFormDefault should be either 'qualified' or 'unqualified', " + DOM.toXPath(xsSchema) + "." + (mp == null ? "" : " (Did you mean '" + mp + "'?)"));
        }
        this.isBlockDefaultSubstitution = false;
        this.isBlockDefaultRestriction = false;
        this.isBlockDefaultExtension = false;
        if (attrBlockDefault != null) {
            x = StringUtils.split(attrBlockDefault);
            i = 0;
            while (i < x.length) {
                if (x[i].equals(S_EXTENSION)) {
                    this.isBlockDefaultExtension = true;
                } else if (x[i].equals(S_RESTRICTION)) {
                    this.isBlockDefaultRestriction = true;
                } else if (x[i].equals(S_SUBSTITUTION)) {
                    this.isBlockDefaultSubstitution = true;
                } else {
                    String mp = EditDistance.getMostProbable(x[i], ARR_E_R_S, 2);
                    throw new SchemaComponentException("blockDefault should be a list of { 'extension', 'restriction', 'substitution' } but contains an invalid token '" + x[i] + "' " + (mp == null ? "" : "(Did you mean '" + mp + "'?)") + ", " + DOM.toXPath(xsSchema));
                }
                ++i;
            }
        }
        this.isFinalDefaultRestriction = false;
        this.isFinalDefaultExtension = false;
        if (attrFinalDefault != null) {
            x = StringUtils.split(attrFinalDefault);
            i = 0;
            while (i < x.length) {
                if (x[i].equals(S_EXTENSION)) {
                    this.isFinalDefaultExtension = true;
                } else if (x[i].equals(S_RESTRICTION)) {
                    this.isFinalDefaultRestriction = true;
                } else {
                    String mp = EditDistance.getMostProbable(x[i], ARR_E_R, 2);
                    throw new SchemaComponentException("finalDefault should be a list of { 'extension', 'restriction' } but contains an invalid token '" + x[i] + "' " + (mp == null ? "" : "(Did you mean '" + mp + "'?)") + ", " + DOM.toXPath(xsSchema));
                }
                ++i;
            }
        }
        this.currentTargetNamespace = attrTargetNamespace == null ? "" : attrTargetNamespace;
        NodeList list = xsSchema.getChildNodes();
        int nList = list.getLength();
        int i2 = 0;
        while (i2 < nList) {
            Node node = list.item(i2);
            if (node.getNodeType() == 1) {
                String attrSchemaLocation;
                String[] attrs1;
                Element e = (Element)node;
                if (!LoaderImpl.isSchemaQualified(e.getNamespaceURI())) {
                    throw new SchemaComponentException("Element " + DOM.toXPath(e) + " is not schema-qualified.");
                }
                String s = node.getLocalName();
                if (s.equals(S_ELEMENT)) {
                    this.schema.add(this.processElementDeclaration(e, null));
                } else if (s.equals(S_COMPLEX_TYPE)) {
                    this.schema.add(this.processComplexTypeDefinition(e));
                } else if (s.equals(S_SIMPLE_TYPE)) {
                    this.schema.add(this.processSimpleTypeDefinition(e));
                } else if (s.equals(S_GROUP)) {
                    this.schema.add(this.processModelGroupDefinition(e));
                } else if (s.equals(S_ATTRIBUTE_GROUP)) {
                    this.schema.add(this.processAttributeGroupDefinition(e));
                } else if (s.equals(S_NOTATION)) {
                    this.schema.add(this.processNotationDeclaration(e));
                } else if (s.equals(S_INCLUDE)) {
                    attrs1 = LoaderImpl.extractAttrs(e, ATTRS_INCLUDE);
                    attrSchemaLocation = attrs1[0];
                    if (attrSchemaLocation != null) {
                        SchemaInfoImpl info = new SchemaInfoImpl(this, this.schema, this.currentSchemaInfo, this.currentTargetNamespace, attrSchemaLocation, null);
                        this.schemaInfos.add(info);
                    }
                } else if (s.equals(S_IMPORT)) {
                    attrs1 = LoaderImpl.extractAttrs(e, ATTRS_IMPORT);
                    attrSchemaLocation = attrs1[0];
                    String attrNamespace = attrs1[1];
                    if (attrSchemaLocation != null) {
                        SchemaInfoImpl info = new SchemaInfoImpl(this, this.schema, this.currentSchemaInfo, attrNamespace, attrSchemaLocation, null);
                        this.schemaInfos.add(info);
                    }
                } else if (s.equals(S_ATTRIBUTE)) {
                    this.schema.add(this.processAttributeDeclaration(e, null));
                } else if (!s.equals(S_REDEFINE)) {
                    if (s.equals(S_ANNOTATION)) {
                        this.processAnnotation(this.schema, e);
                    } else {
                        String mp = EditDistance.getMostProbable(s, SCHEMA_ELEMENT_NAMES, 2);
                        throw new SchemaComponentException("Not a schema element: " + DOM.toXPath(e) + (mp != null ? "   (Did you mean '" + mp + "'?)" : ""));
                    }
                }
            }
            ++i2;
        }
    }

    private AttributeDeclarationImpl processAttributeDeclaration(Element xsAttribute, ComplexTypeDefinitionImpl scope) throws SchemaComponentException {
        String[] attrs = LoaderImpl.extractAttrs(xsAttribute, ATTRS_AD);
        String attrDefault = attrs[0];
        String attrFixed = attrs[1];
        String attrForm = attrs[2];
        String attrName = attrs[3];
        String attrRef = attrs[4];
        String attrType = attrs[5];
        String attrUse = attrs[6];
        Element[] elts = LoaderImpl.extractElements(xsAttribute, ELTS_AD);
        Element eltAnnotation = LoaderImpl.findSingleElement(S_ANNOTATION, elts, xsAttribute, false);
        Element eltSimpleType = LoaderImpl.findSingleElement(S_SIMPLE_TYPE, elts, xsAttribute, false);
        AttributeDeclarationImpl r = new AttributeDeclarationImpl();
        this.initComponent(r, xsAttribute);
        if (attrName == null) {
            throw new SchemaComponentException("Attribute declaration without a name, " + DOM.toXPath(xsAttribute));
        }
        r.name = attrName;
        if (attrForm == null) {
            r.targetNamespace = scope == null ? this.currentTargetNamespace : (this.isAttributeFormDefaultQualified ? this.currentTargetNamespace : "");
        } else if (attrForm.equals(S_QUALIFIED)) {
            r.targetNamespace = this.currentTargetNamespace;
        } else if (attrForm.equals(S_UNQUALIFIED)) {
            r.targetNamespace = "";
        } else {
            String mp = EditDistance.getMostProbable(attrForm, ARR_Q_U, 2);
            throw new SchemaComponentException("attributeFormDefault should be either 'qualified' or 'unqualified', " + DOM.toXPath(xsAttribute) + "." + (mp == null ? "" : " (Did you mean '" + mp + "'?)"));
        }
        r.typeDefinition = null;
        if (attrType != null) {
            this.addRef(r, attrType, xsAttribute, 1, "type definition");
        } else if (eltSimpleType != null) {
            r.typeDefinition = this.processSimpleTypeDefinition(eltSimpleType);
        }
        r.scope = scope;
        r.defaultValue = attrDefault;
        r.fixedValue = attrFixed;
        return r;
    }

    private ElementDeclarationImpl processElementDeclaration(Element xsElement, ComplexTypeDefinitionImpl scope) throws SchemaComponentException {
        String[] attrs = LoaderImpl.extractAttrs(xsElement, ATTRS_ED);
        String attrAbstract = attrs[0];
        String attrBlock = attrs[1];
        String attrDefault = attrs[2];
        String attrFinal = attrs[3];
        String attrFixed = attrs[4];
        String attrForm = attrs[5];
        String attrMaxOccurs = attrs[6];
        String attrMinOccurs = attrs[7];
        String attrName = attrs[8];
        String attrNillable = attrs[9];
        String attrRef = attrs[10];
        String attrSubstitutionGroup = attrs[11];
        String attrType = attrs[12];
        Element[] elts = LoaderImpl.extractElements(xsElement, ELTS_ED);
        Element eltSimpleType = LoaderImpl.findSingleElement(S_SIMPLE_TYPE, elts, xsElement, false);
        Element eltComplexType = LoaderImpl.findSingleElement(S_COMPLEX_TYPE, elts, xsElement, false);
        if (eltSimpleType != null && eltComplexType != null) {
            throw new SchemaComponentException("Both 'simpleType' and 'complexType' are not allowed here, " + DOM.toXPath(xsElement));
        }
        ElementDeclarationImpl r = new ElementDeclarationImpl();
        this.initComponent(r, xsElement);
        r.name = attrName;
        if (attrForm == null) {
            r.targetNamespace = scope == null ? this.currentTargetNamespace : (this.isElementFormDefaultQualified ? this.currentTargetNamespace : "");
        } else if (attrForm.equals(S_QUALIFIED)) {
            r.targetNamespace = this.currentTargetNamespace;
        } else if (attrForm.equals(S_UNQUALIFIED)) {
            r.targetNamespace = "";
        } else {
            String mp = EditDistance.getMostProbable(attrForm, ARR_Q_U, 2);
            throw new SchemaComponentException("attributeFormDefault should be either 'qualified' or 'unqualified', " + DOM.toXPath(xsElement) + "." + (mp == null ? "" : " (Did you mean '" + mp + "'?)"));
        }
        r.typeDefinition = this.schema.getURTypeDefinition();
        if (attrType != null) {
            this.addRef(r, attrType, xsElement, 1, "type definition");
        } else if (eltSimpleType != null) {
            r.typeDefinition = this.processSimpleTypeDefinition(eltSimpleType);
        } else if (eltComplexType != null) {
            r.typeDefinition = this.processComplexTypeDefinition(eltComplexType);
        }
        r.scope = scope;
        r.defaultValue = attrDefault;
        r.fixedValue = attrFixed;
        if (attrNillable == null) {
            r.isNillable = false;
        } else if (attrNillable.equals(S_TRUE) || attrNillable.equals(S_1)) {
            r.isNillable = true;
        } else if (attrNillable.equals(S_FALSE) || attrNillable.equals(S_0)) {
            r.isNillable = false;
        } else {
            throw new SchemaComponentException("The 'nillable' attribute should be in { 'true', 'false', '1', '0', }, but it is '" + attrNillable + "'");
        }
        this.processIdentityConstraintChildrenOf(xsElement, r.identityConstraintDefinitions);
        if (attrAbstract == null) {
            r.isAbstract = false;
        } else if (attrAbstract.equals(S_TRUE) || attrAbstract.equals(S_1)) {
            r.isAbstract = true;
        } else if (attrAbstract.equals(S_FALSE) || attrAbstract.equals(S_0)) {
            r.isAbstract = false;
        } else {
            throw new SchemaComponentException("The 'abstract' attribute should be in { 'true', 'false', '1', '0', }, but it is '" + attrAbstract + "'");
        }
        return r;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ComplexTypeDefinitionImpl processComplexTypeDefinition(Element xsComplexType) throws SchemaComponentException {
        Element xs_1;
        Element xsExtension;
        Element xsRestriction;
        String[] attrs = LoaderImpl.extractAttrs(xsComplexType, ATTRS_CTD);
        String attrAbstract = attrs[0];
        String attrBlock = attrs[1];
        String attrFinal = attrs[2];
        String attrMixed = attrs[3];
        String attrName = attrs[4];
        ComplexTypeDefinitionImpl r = new ComplexTypeDefinitionImpl();
        this.initComponent(r, xsComplexType);
        r.name = attrName == null ? "" : attrName;
        r.targetNamespace = this.currentTargetNamespace;
        if (attrAbstract == null) {
            r.isAbstract = false;
        } else if (attrAbstract.equals(S_TRUE) || attrAbstract.equals(S_1)) {
            r.isAbstract = true;
        } else {
            if (!attrAbstract.equals(S_FALSE) && !attrAbstract.equals(S_0)) throw new SchemaComponentException("The 'abstract' attribute should be in { 'true', 'false', '1', '0', }, but it is '" + attrAbstract + "'");
            r.isAbstract = false;
        }
        if (attrFinal != null) {
            if (attrFinal.equals("#all")) {
                r.isFinalRestriction = true;
                r.isFinalExtension = true;
            } else {
                String[] x = StringUtils.split(attrFinal);
                r.isFinalRestriction = false;
                r.isFinalExtension = false;
                int i = 0;
                while (i < x.length) {
                    if (x[i].equals(S_EXTENSION)) {
                        r.isFinalExtension = true;
                    } else if (x[i].equals(S_RESTRICTION)) {
                        r.isFinalRestriction = true;
                    } else {
                        String mp = EditDistance.getMostProbable(x[i], ARR_E_R, 2);
                        throw new SchemaComponentException("The 'final' attribute of " + DOM.toXPath(xsComplexType) + " should be either '#all' or a list of { 'extension', 'restriction' }, but it contains an invalid token, '" + x[i] + "'." + (mp == null ? "" : " (Did you mean '" + mp + "'?)"));
                    }
                    ++i;
                }
            }
        } else {
            r.isFinalExtension = this.isFinalDefaultExtension;
            r.isFinalRestriction = this.isFinalDefaultRestriction;
        }
        Element xsComplexContent = LoaderImpl.findChild(xsComplexType, "complexContent");
        Element xsSimpleContent = LoaderImpl.findChild(xsComplexType, "simpleContent");
        if (xsSimpleContent != null) {
            xsRestriction = LoaderImpl.findChild(xsSimpleContent, S_RESTRICTION);
            xsExtension = LoaderImpl.findChild(xsSimpleContent, S_EXTENSION);
            if (xsRestriction != null) {
                xs_1 = xsRestriction;
                Element xsSimpleType = LoaderImpl.findChild(xsRestriction, S_SIMPLE_TYPE);
                if (xsSimpleType != null) {
                    r.contentTypeSimpleTypeDefinition = this.processSimpleTypeDefinition(xsSimpleType);
                } else {
                    this.addRef(r, xsRestriction.getAttribute(S_BASE), xsRestriction, 1, "content type");
                }
                r.isDerivationMethodExtension = false;
            } else {
                if (xsExtension == null) throw new SchemaComponentException();
                xs_1 = xsExtension;
                r.baseTypeDefinition = this.schema.getURTypeDefinition();
                this.addRef(r, xsExtension.getAttribute(S_BASE), xsExtension, 1, "content type");
                r.isDerivationMethodExtension = true;
            }
        } else if (xsComplexContent != null) {
            xsRestriction = LoaderImpl.findChild(xsComplexContent, S_RESTRICTION);
            xsExtension = LoaderImpl.findChild(xsComplexContent, S_EXTENSION);
            if (xsRestriction != null) {
                this.addRef(r, xsRestriction.getAttribute(S_BASE), xsRestriction, 1, "base type definition");
                r.isDerivationMethodExtension = false;
                xs_1 = xsRestriction;
                Element xs_ = LoaderImpl.findChild_ACGS(xsRestriction);
                if (xs_ != null) {
                    r.contentTypeContentModel = this.processParticle(xs_, r);
                }
            } else {
                if (xsExtension == null) throw new SchemaComponentException();
                this.addRef(r, xsExtension.getAttribute(S_BASE), xsExtension, 1, "base type definition");
                r.isDerivationMethodExtension = true;
                xs_1 = xsExtension;
                Element xs_ = LoaderImpl.findChild_ACGS(xsExtension);
                if (xs_ != null) {
                    r.contentTypeContentModel = this.processParticle(xs_, r);
                }
            }
        } else {
            r.baseTypeDefinition = this.schema.getURTypeDefinition();
            Element xs_ = LoaderImpl.findChild_ACGS(xsComplexType);
            if (xs_ != null) {
                r.contentTypeContentModel = this.processParticle(xs_, r);
            }
            xs_1 = xsComplexType;
        }
        this.processAttributeUseChildrenOf(xs_1, r.attributeUses, r);
        Element xsAnyAttribute = LoaderImpl.findChild(xs_1, "anyAttribute");
        if (xsAnyAttribute != null) {
            r.attributeWildcard = this.processWildcard(xsAnyAttribute);
        }
        if (xsComplexType.hasAttribute(S_BLOCK)) {
            String sBlock = xsComplexType.getAttribute(S_BLOCK);
            r.isProhibitedSubstitutionExtension = sBlock.indexOf(S_EXTENSION) != -1;
            r.isProhibitedSubstitutionRestriction = sBlock.indexOf(S_RESTRICTION) != -1;
            return r;
        } else {
            r.isProhibitedSubstitutionExtension = this.isBlockDefaultExtension;
            r.isProhibitedSubstitutionRestriction = this.isBlockDefaultRestriction;
        }
        return r;
    }

    private AttributeGroupDefinitionImpl processAttributeGroupDefinition(Element xsAttributeGroup) throws SchemaComponentException {
        AttributeGroupDefinitionImpl r = new AttributeGroupDefinitionImpl();
        this.initComponent(r, xsAttributeGroup);
        r.name = xsAttributeGroup.getAttribute(S_NAME);
        r.targetNamespace = this.currentTargetNamespace;
        this.processAttributeUseChildrenOf(xsAttributeGroup, r.attributeUses, r);
        Element xsAnyAttribute = LoaderImpl.findChild(xsAttributeGroup, "anyAttribute");
        if (xsAnyAttribute != null) {
            r.attributeWildcard = this.processWildcard(xsAnyAttribute);
        }
        return r;
    }

    private ModelGroupDefinitionImpl processModelGroupDefinition(Element xsGroup) throws SchemaComponentException {
        String[] attrs = LoaderImpl.extractAttrs(xsGroup, ATTRS_MGD);
        String attrName = attrs[0];
        ModelGroupDefinitionImpl r = new ModelGroupDefinitionImpl();
        this.initComponent(r, xsGroup);
        if (attrName == null) {
            throw new SchemaComponentException("Model group definition without a name, " + DOM.toXPath(xsGroup));
        }
        r.name = attrName;
        r.targetNamespace = this.currentTargetNamespace;
        Element xs_ = LoaderImpl.findChild_ACGS(xsGroup);
        if (xs_ == null) {
            throw new SchemaComponentException();
        }
        r.modelGroup = this.processModelGroup(xs_, null);
        return r;
    }

    private ModelGroupImpl processModelGroup(Element xs_, ComplexTypeDefinitionImpl scope) throws SchemaComponentException {
        ModelGroupImpl r = new ModelGroupImpl();
        this.initComponent(r, xs_);
        String s = xs_.getLocalName();
        if (s.equals(S_ALL)) {
            r.compositor = 1;
        } else if (s.equals(S_CHOICE)) {
            r.compositor = 2;
        } else if (s.equals(S_SEQUENCE)) {
            r.compositor = 3;
        } else {
            throw new SchemaComponentException();
        }
        this.processParticleChildrenOf(xs_, r.particles, scope);
        return r;
    }

    private WildcardImpl processWildcard(Element xsAny_) throws SchemaComponentException {
        String sProcessContents;
        WildcardImpl r = new WildcardImpl();
        this.initComponent(r, xsAny_);
        r.processContents = xsAny_.hasAttribute("processContents") ? ((sProcessContents = xsAny_.getAttribute("processContents")).equals("lax") ? 2 : (sProcessContents.equals("skip") ? 1 : 3)) : 3;
        if (xsAny_.hasAttribute(S_NAMESPACE)) {
            String sNS = xsAny_.getAttribute(S_NAMESPACE);
            if (sNS.equals("##any")) {
                r.nscAny = true;
            } else if (sNS.equals("##other")) {
                r.negated = this.currentTargetNamespace;
            } else {
                String[] m = ListSplitter.split(sNS);
                int i = 0;
                while (i < m.length) {
                    if (m[i].equals("##targetNamespace")) {
                        m[i] = this.currentTargetNamespace;
                    } else if (m[i].equals("##local")) {
                        m[i] = "";
                    }
                    ++i;
                }
                r.members = m;
            }
        } else {
            r.nscAny = true;
        }
        return r;
    }

    private SimpleTypeDefinitionImpl processSimpleTypeDefinition(Element xsSimpleType) throws SchemaComponentException {
        String[] attrs = LoaderImpl.extractAttrs(xsSimpleType, ATTRS_STD);
        String attrFinal = attrs[0];
        String attrName = attrs[1];
        SimpleTypeDefinitionImpl r = new SimpleTypeDefinitionImpl();
        this.initComponent(r, xsSimpleType);
        r.name = attrName == null ? "" : attrName;
        r.targetNamespace = this.currentTargetNamespace;
        if (attrFinal == null) {
            r.isFinalUnion = false;
            r.isFinalRestriction = false;
            r.isFinalList = false;
            r.isFinalExtension = false;
        } else if (attrFinal.equals("#all")) {
            r.isFinalUnion = true;
            r.isFinalRestriction = true;
            r.isFinalList = true;
            r.isFinalExtension = true;
        } else {
            String[] x = StringUtils.split(attrFinal);
            int i = 0;
            while (i < x.length) {
                if (x[i].equals(S_EXTENSION)) {
                    r.isFinalExtension = true;
                } else if (x[i].equals(S_LIST)) {
                    r.isFinalList = true;
                } else if (x[i].equals(S_RESTRICTION)) {
                    r.isFinalRestriction = true;
                } else if (x[i].equals(S_UNION)) {
                    r.isFinalUnion = true;
                } else {
                    String mp = EditDistance.getMostProbable(x[i], ARR_E_L_R_U, 2);
                    throw new SchemaComponentException("The 'final' attribute of " + DOM.toXPath(xsSimpleType) + " should be either '#all' or a list of { 'extension', 'list', 'restriction', 'union' }, but it contains an invalid token '" + x[i] + "." + (mp == null ? "" : " (Did you mean '" + mp + "'?)"));
                }
                ++i;
            }
        }
        Element xsRestriction = LoaderImpl.findChild(xsSimpleType, S_RESTRICTION);
        Element xsList = LoaderImpl.findChild(xsSimpleType, S_LIST);
        Element xsUnion = LoaderImpl.findChild(xsSimpleType, S_UNION);
        if (xsRestriction != null) {
            r.variety = 1;
            if (xsRestriction.hasAttribute(S_BASE)) {
                this.addRef(r, xsRestriction.getAttribute(S_BASE), xsRestriction, 1, "base type definition");
            } else {
                Element xsSimpleType1 = LoaderImpl.findChild(xsRestriction, S_SIMPLE_TYPE);
                if (xsSimpleType1 == null) {
                    throw new SchemaComponentException("xs:simpleType/xs:restriction without a base");
                }
                r.baseTypeDefinition = this.processSimpleTypeDefinition(xsSimpleType1);
            }
            this.processFacetChildrenOf(xsRestriction, r.facets);
        } else if (xsList != null) {
            r.variety = 2;
            if (xsList.hasAttribute("itemType")) {
                this.addRef(r, xsList.getAttribute("itemType"), xsList, 1, "item type definition");
            } else {
                Element xsSimpleType1 = LoaderImpl.findChild(xsList, S_SIMPLE_TYPE);
                if (xsSimpleType1 != null) {
                    throw new SchemaComponentException("xs:simpleType/xs:list without a base");
                }
                r.baseTypeDefinition = r.itemTypeDefinition = this.processSimpleTypeDefinition(xsSimpleType1);
            }
        } else if (xsUnion != null) {
            r.variety = 3;
            r.memberTypeDefinitions = new Vector();
            if (xsUnion.hasAttribute("memberTypes")) {
                String[] m = ListSplitter.split(xsUnion.getAttribute("memberTypes"));
                int i = 0;
                while (i < m.length) {
                    this.addRef(r, m[i], xsUnion, 1, "member type definitions");
                    ++i;
                }
            }
            NodeList children = xsUnion.getChildNodes();
            int nChildren = children.getLength();
            int i = 0;
            while (i < nChildren) {
                Node c = children.item(i);
                if (c.getNodeType() == 1 && c.getLocalName().equals(S_SIMPLE_TYPE)) {
                    r.memberTypeDefinitions.add(this.processSimpleTypeDefinition((Element)c));
                }
                ++i;
            }
        }
        return r;
    }

    private ParticleImpl processParticle(Element xs_, ComplexTypeDefinitionImpl scope) throws SchemaComponentException {
        String sMaxOccurs;
        ParticleImpl r = new ParticleImpl();
        this.initComponent(r, xs_);
        r.minOccurs = xs_.hasAttribute(S_MIN_OCCURS) ? Integer.parseInt(xs_.getAttribute(S_MIN_OCCURS).trim()) : 1;
        r.maxOccurs = xs_.hasAttribute(S_MAX_OCCURS) ? ((sMaxOccurs = xs_.getAttribute(S_MAX_OCCURS).trim()).equals("unbounded") ? Integer.MAX_VALUE : Integer.parseInt(sMaxOccurs)) : 1;
        String s = xs_.getLocalName();
        if (s.equals(S_ALL) || s.equals(S_CHOICE) || s.equals(S_SEQUENCE)) {
            r.term = this.processModelGroup(xs_, scope);
        } else if (s.equals(S_ELEMENT)) {
            if (xs_.hasAttribute(S_REF)) {
                this.addRef(r, xs_.getAttribute(S_REF), xs_, 3, "term");
            } else {
                r.term = this.processElementDeclaration(xs_, scope);
            }
        } else if (s.equals(S_GROUP)) {
            if (xs_.hasAttribute(S_REF)) {
                this.addRef(r, xs_.getAttribute(S_REF), xs_, 8, "term");
            } else {
                r.term = this.processModelGroup(xs_, scope);
            }
        } else if (s.equals(S_ANY)) {
            r.term = this.processWildcard(xs_);
        }
        return r;
    }

    private void processParticleChildrenOf(Element p, Vector v, ComplexTypeDefinitionImpl scope) throws SchemaComponentException {
        NodeList children = p.getChildNodes();
        int nChildren = children.getLength();
        int i = 0;
        while (i < nChildren) {
            String name;
            Node x = children.item(i);
            if (x.getNodeType() == 1 && ((name = x.getLocalName()).equals(S_ALL) || name.equals(S_CHOICE) || name.equals(S_SEQUENCE) || name.equals(S_GROUP) || name.equals(S_ELEMENT) || name.equals(S_ANY))) {
                v.add(this.processParticle((Element)x, scope));
            }
            ++i;
        }
    }

    private IdentityConstraintDefinitionImpl processIdentityConstraintDefinition(Element xs_) throws SchemaComponentException {
        IdentityConstraintDefinitionImpl r = new IdentityConstraintDefinitionImpl();
        this.initComponent(r, xs_);
        r.name = xs_.getAttribute(S_NAME);
        r.targetNamespace = this.currentTargetNamespace;
        String s = xs_.getLocalName();
        r.category = s.equals("key") ? 1 : (s.equals("keyref") ? 2 : 3);
        NodeList list = xs_.getChildNodes();
        int nList = list.getLength();
        int i = 0;
        while (i < nList) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                String name = node.getLocalName();
                Element e = (Element)node;
                if (name.equals("selector")) {
                    r.selector = e.getAttribute("xpath");
                } else if (name.equals("field")) {
                    r.fields.add(e.getAttribute("xpath"));
                }
            }
            ++i;
        }
        if (xs_.hasAttribute("refer")) {
            this.addRef(r, xs_.getAttribute("refer"), xs_, 13, "referenced key");
        }
        return r;
    }

    private void processIdentityConstraintChildrenOf(Element p, Vector v) throws SchemaComponentException {
        NodeList children = p.getChildNodes();
        int nChildren = children.getLength();
        int i = 0;
        while (i < nChildren) {
            String name;
            Node x = children.item(i);
            if (x.getNodeType() == 1 && ((name = x.getLocalName()).equals("unique") || name.equals("key") || name.equals("keyref"))) {
                v.add(this.processIdentityConstraintDefinition((Element)x));
            }
            ++i;
        }
    }

    private NotationDeclarationImpl processNotationDeclaration(Element xsNotation) throws SchemaComponentException {
        NotationDeclarationImpl r = new NotationDeclarationImpl();
        this.initComponent(r, xsNotation);
        if (xsNotation.hasAttribute(S_NAME)) {
            r.name = xsNotation.getAttribute(S_NAME);
        }
        if (xsNotation.hasAttribute("public")) {
            r.publicIdentifier = xsNotation.getAttribute("public");
        }
        if (xsNotation.hasAttribute("system")) {
            r.systemIdentifier = xsNotation.getAttribute("system");
        }
        return r;
    }

    private AttributeUseImpl processAttributeUse(Element xsAttribute, ComplexTypeDefinitionImpl scope) throws SchemaComponentException {
        AttributeUseImpl r = new AttributeUseImpl();
        this.initComponent(r, xsAttribute);
        r.valueConstraintDefault = xsAttribute.hasAttribute(S_DEFAULT) ? xsAttribute.getAttribute(S_DEFAULT) : null;
        r.valueConstraintFixed = xsAttribute.hasAttribute(S_FIXED) ? xsAttribute.getAttribute(S_FIXED) : null;
        if (xsAttribute.hasAttribute(S_USE) && xsAttribute.getAttribute(S_USE).equals("required")) {
            r.isRequired = true;
        }
        if (xsAttribute.hasAttribute(S_REF)) {
            this.addRef(r, xsAttribute.getAttribute(S_REF), xsAttribute, 4, "attribute declaration");
        } else {
            r.attributeDeclaration = this.processAttributeDeclaration(xsAttribute, scope);
        }
        return r;
    }

    private void processAttributeUseChildrenOf(Element p, Vector v, BaseImpl caller) throws SchemaComponentException {
        NodeList children = p.getChildNodes();
        int nChildren = children.getLength();
        int i = 0;
        while (i < nChildren) {
            Node x = children.item(i);
            if (x.getNodeType() == 1) {
                String name = x.getLocalName();
                if (name.equals(S_ATTRIBUTE)) {
                    Element ex = (Element)x;
                    if (ex.hasAttribute(S_USE) && ex.getAttribute(S_USE).trim().equals("prohibited")) {
                        if (caller.getTypeOfComponent() == 1) {
                            ((ComplexTypeDefinitionImpl)caller).addProhibited(this.currentTargetNamespace, ex.getAttribute(S_NAME));
                        }
                    } else {
                        AttributeUseImpl r = this.processAttributeUse(ex, caller instanceof ComplexTypeDefinitionImpl ? (ComplexTypeDefinitionImpl)caller : null);
                        v.add(r);
                    }
                } else if (name.equals(S_ATTRIBUTE_GROUP)) {
                    Element xsAttributeGroup = (Element)x;
                    this.addRef(caller, xsAttributeGroup.getAttribute(S_REF), xsAttributeGroup, 5, "attribute uses");
                }
            }
            ++i;
        }
    }

    private Facet processFacet(Element xs_) throws SchemaComponentException {
        FacetImpl r = new FacetImpl(xs_.getLocalName(), xs_.getAttribute(S_VALUE), false);
        this.initComponent(r, xs_);
        return r;
    }

    private void processFacetChildrenOf(Element p, Vector v) throws SchemaComponentException {
        NodeList children = p.getChildNodes();
        int nChildren = children.getLength();
        int i = 0;
        while (i < nChildren) {
            String name;
            Node x = children.item(i);
            if (x.getNodeType() == 1 && LoaderImpl.isNameOfFacet(name = x.getLocalName())) {
                Facet r = this.processFacet((Element)x);
                v.add(r);
            }
            ++i;
        }
    }

    private void processAnnotation(BaseImpl c, Element xsAnnotation) throws SchemaComponentException {
        AnnotationImpl r = new AnnotationImpl();
        r.setOwnerSchema(this.schema);
        r.setAssociated(xsAnnotation);
        c.setAnnotation(r);
    }

    private static boolean isNameOfFacet(String s) throws SchemaComponentException {
        return s.equals("minExclusive") || s.equals("minInclusive") || s.equals("maxExclusive") || s.equals("maxInclusive") || s.equals("totalDigits") || s.equals("fractionDigits") || s.equals("length") || s.equals("minLength") || s.equals("maxLength") || s.equals("enumeration") || s.equals("whiteSpace") || s.equals("pattern");
    }

    private static Element findChild(Element e, String local) throws SchemaComponentException {
        NodeList list = e.getChildNodes();
        if (list == null) {
            return null;
        }
        int nList = list.getLength();
        int i = 0;
        while (i < nList) {
            Node node = list.item(i);
            if (node.getNodeType() == 1 && node.getLocalName().equals(local)) {
                return (Element)node;
            }
            ++i;
        }
        return null;
    }

    private static Element findChild_ACGS(Element e) throws SchemaComponentException {
        Element r1 = LoaderImpl.findChild(e, S_ALL);
        if (r1 != null) {
            return r1;
        }
        Element r2 = LoaderImpl.findChild(e, S_CHOICE);
        if (r2 != null) {
            return r2;
        }
        Element r3 = LoaderImpl.findChild(e, S_GROUP);
        if (r3 != null) {
            return r3;
        }
        Element r4 = LoaderImpl.findChild(e, S_SEQUENCE);
        if (r4 != null) {
            return r4;
        }
        return null;
    }

    public void print(Schema schema, OutputStream out) throws SchemaComponentException {
        if (this.printer == null) {
            this.printer = new ComponentPrinter();
        }
        this.printer.print(schema, out);
    }

    public void printAsHTML(Schema schema, OutputStream out, boolean printBuiltIn) throws SchemaComponentException {
        if (this.printerToHTML == null) {
            this.printerToHTML = new ComponentPrinterToHTML();
        }
        this.printerToHTML.print(schema, out, printBuiltIn);
    }

    private void addRef(BaseImpl from, String qName, Element e, int toWhat) throws SchemaComponentException {
        this.addRef(from, qName, e, toWhat, null);
    }

    private void addRef(BaseImpl from, String qName, Element e, int toWhat, String prop) throws SchemaComponentException {
        this.refs.add(new Ref(from, qName, e, toWhat, prop));
    }

    protected void requestResolutionOf(Base x) throws SchemaComponentException {
        int nRefs = this.refs.size();
        int i = 0;
        while (i < nRefs) {
            Ref ref = (Ref)this.refs.get(i);
            if (ref.getFrom() == x) {
                ref.resolve(this);
            }
            ++i;
        }
    }

    private Element findXSSchema0(Element e) {
        if (e.getLocalName().equals(S_SCHEMA)) {
            String uri = e.getNamespaceURI();
            int i = 0;
            while (i < XS_NAMESPACES.length) {
                if (XS_NAMESPACES[i].equals(uri)) {
                    return e;
                }
                ++i;
            }
        }
        NodeList list = e.getChildNodes();
        int nList = list.getLength();
        int i = 0;
        while (i < nList) {
            Element r;
            Node child = list.item(i);
            if (child.getNodeType() == 1 && (r = this.findXSSchema0((Element)child)) != null) {
                return r;
            }
            ++i;
        }
        return null;
    }

    private void initComponent(BaseImpl b, Element e) throws SchemaComponentException {
        b.setOwnerSchema(this.schema);
        if (e != null) {
            b.setAssociated(e);
            Element a = LoaderImpl.findChild(e, S_ANNOTATION);
            if (a != null) {
                this.processAnnotation(b, a);
            }
        }
    }

    protected Transformer getTransformer() throws SchemaComponentException {
        if (this.transformer == null) {
            System.setProperty((class$javax$xml$transform$TransformerFactory == null ? (class$javax$xml$transform$TransformerFactory = LoaderImpl.class$("javax.xml.transform.TransformerFactory")) : class$javax$xml$transform$TransformerFactory).getName(), (class$com$inqmy$lib$jaxp$TransformerFactoryImpl == null ? (class$com$inqmy$lib$jaxp$TransformerFactoryImpl = LoaderImpl.class$("com.inqmy.lib.jaxp.TransformerFactoryImpl")) : class$com$inqmy$lib$jaxp$TransformerFactoryImpl).getName());
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                this.transformer = tf.newTransformer();
            }
            catch (Exception e) {
                throw new SchemaComponentException(e);
            }
        }
        return this.transformer;
    }

    private static String[] extractAttrs(Element e, String[] attrNames) throws SchemaComponentException {
        String[] r = new String[attrNames.length];
        NamedNodeMap attrs = e.getAttributes();
        if (attrs == null) {
            return STRING_ARRAY_0;
        }
        int nAttrs = attrs.getLength();
        int i = 0;
        while (i < nAttrs) {
            Node attr = attrs.item(i);
            String uri = attr.getNamespaceURI();
            if (uri == null || uri.length() == 0) {
                String local = attr.getLocalName();
                boolean found = false;
                int j = 0;
                while (j < attrNames.length) {
                    if (local.equals(attrNames[j])) {
                        r[j] = attr.getNodeValue();
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    String mp = EditDistance.getMostProbable(local, attrNames, 2);
                    throw new SchemaComponentException("Attribute " + DOM.toXPath(attr) + " is unqualified but was not recognized by the schema loader." + (mp == null ? "" : " (Did you mean '" + mp + "'?)"));
                }
            }
            ++i;
        }
        return r;
    }

    private static Element[] extractElements(Element e, String[] elementNames) throws SchemaComponentException {
        NodeList children = e.getChildNodes();
        if (children == null) {
            return ELEMENT_ARRAY_0;
        }
        int nChildren = children.getLength();
        Element[] temp = new Element[nChildren];
        int nTemp = 0;
        int i = 0;
        while (i < nChildren) {
            String value;
            Node childNode = children.item(i);
            if (childNode instanceof Element) {
                Element childElement = (Element)childNode;
                String uri = childElement.getNamespaceURI();
                if (!LoaderImpl.isSchemaQualified(uri)) {
                    throw new SchemaComponentException("Element " + DOM.toXPath(e) + " is not schema-qualified. (Make sure that namespace awareness is on during the parsing.)");
                }
                String local = childElement.getLocalName();
                boolean found = false;
                int j = 0;
                while (j < elementNames.length) {
                    if (local.equals(elementNames[j])) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    String mp = EditDistance.getMostProbable(local, elementNames, 2);
                    throw new SchemaComponentException("Bad schema element, " + DOM.toXPath(childElement) + (mp == null ? "" : " (Did you mean '" + mp + "'?)"));
                }
                temp[nTemp++] = childElement;
            } else if (childNode instanceof Text && !StringUtils.isWhitespace(value = childNode.getNodeValue())) {
                throw new SchemaComponentException("All text nodes in a schema document (except those in xs:annotation-s) should be whitespace. Location: " + DOM.toXPath(childNode));
            }
            ++i;
        }
        Element[] r = new Element[nTemp];
        System.arraycopy(temp, 0, r, 0, nTemp);
        return r;
    }

    private static Element findSingleElement(String localName, Element[] array, Element parent, boolean mustBePresent) throws SchemaComponentException {
        Element r = null;
        boolean ok = true;
        int i = 0;
        while (i < array.length) {
            if (array[i].getLocalName().equals(localName)) {
                if (r != null) {
                    ok = false;
                    break;
                }
                r = array[i];
            }
            ++i;
        }
        boolean bl = ok = ok && (r != null || !mustBePresent);
        if (!ok) {
            throw new SchemaComponentException("There should be " + (mustBePresent ? "exactly" : "at most") + " one child of " + DOM.toXPath(parent) + " named '" + localName + "' at location ");
        }
        return r;
    }

    private static boolean isSchemaQualified(String uri) {
        if (uri == null) {
            return false;
        }
        int n = XS_NAMESPACES.length;
        int i = 0;
        while (i < n) {
            if (uri.equals(XS_NAMESPACES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected Source resolve(String base, String rel) {
        Source r = null;
        if (this.uriResolver != null) {
            try {
                r = this.uriResolver.resolve(rel, base);
            }
            catch (Exception e) {}
        } else if (this.entityResolver != null) {
            try {
                InputSource ins = this.entityResolver.resolveEntity("", rel);
                r = new StreamSource();
                ((StreamSource)r).setSystemId(ins.getSystemId());
                ((StreamSource)r).setInputStream(ins.getByteStream());
                ((StreamSource)r).setReader(ins.getCharacterStream());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (r == null) {
            String absoluteSystemId;
            URL baseURL;
            try {
                baseURL = URLLoaderBase.fileOrURLToURL(null, base);
            }
            catch (IOException ioe) {
                baseURL = null;
            }
            try {
                URL absoluteURL = URLLoaderBase.fileOrURLToURL(baseURL, rel);
                absoluteSystemId = absoluteURL == null ? null : absoluteURL.toExternalForm();
            }
            catch (IOException ioe) {
                absoluteSystemId = null;
            }
            r = new StreamSource(absoluteSystemId);
        }
        return r;
    }

    protected Schema getSchema() {
        return this.schema;
    }

    protected URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

