/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.components.impl0;

import com.inqmy.lib.schema.components.AttributeDeclaration;
import com.inqmy.lib.schema.components.AttributeGroupDefinition;
import com.inqmy.lib.schema.components.AttributeUse;
import com.inqmy.lib.schema.components.Base;
import com.inqmy.lib.schema.components.ComplexTypeDefinition;
import com.inqmy.lib.schema.components.ElementDeclaration;
import com.inqmy.lib.schema.components.IdentityConstraintDefinition;
import com.inqmy.lib.schema.components.ModelGroup;
import com.inqmy.lib.schema.components.NotationDeclaration;
import com.inqmy.lib.schema.components.Particle;
import com.inqmy.lib.schema.components.Schema;
import com.inqmy.lib.schema.components.SimpleTypeDefinition;
import com.inqmy.lib.schema.components.TypeDefinitionBase;
import com.inqmy.lib.schema.components.Wildcard;
import com.inqmy.lib.schema.components.impl0.ModelGroupDefinitionImpl;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

public class ComponentPrinter {
    public static final String ABSENT = "\u00b7absent\u00b7";
    private PrintStream out;
    private int counter;
    private Vector indexer = new Vector();
    private Vector temp = new Vector();

    public void print(Schema schema, OutputStream out) {
        this.out = out instanceof PrintStream ? (PrintStream)out : new PrintStream(out);
        this.indexer.clear();
        this.getIndex(schema);
        this.counter = 0;
        while (this.counter < this.indexer.size()) {
            this.p((Base)this.indexer.get(this.counter));
        }
    }

    private void p(Base x) {
        int tx = x.getTypeOfComponent();
        this.out.println();
        this.out.println(this.formatRef(x) + " " + x.getNameOfComponent());
        ++this.counter;
        switch (tx) {
            case 4: {
                AttributeDeclaration y = (AttributeDeclaration)x;
                this.q("name", y.getName());
                this.q("target namespace", y.getTargetNamespace());
                this.q("type definition", y.getTypeDefinition());
                this.q("scope", y.getScope());
                this.q("value constraint");
                String vcd = y.getValueConstraintDefault();
                String vcf = y.getValueConstraintFixed();
                if (vcd != null) {
                    this.out.println("<" + vcd + ", default>");
                    break;
                }
                if (vcf != null) {
                    this.out.println("<" + vcf + ", fixed>");
                    break;
                }
                this.out.println(ABSENT);
                break;
            }
            case 5: {
                AttributeGroupDefinition y = (AttributeGroupDefinition)x;
                this.q("name", y.getName());
                this.q("target namespace", y.getTargetNamespace());
                this.q("attribute uses");
                this.temp.clear();
                y.getAttributeUses(this.temp);
                Enumeration enumeration = this.temp.elements();
                if (enumeration != null) {
                    this.out.print("{ ");
                    while (enumeration.hasMoreElements()) {
                        this.out.print(this.formatRef((Base)enumeration.nextElement()) + " ");
                    }
                    this.out.println("}");
                } else {
                    this.out.println("null");
                }
                this.q("attribute wildcard", y.getAttributeWildcard());
                break;
            }
            case 6: {
                AttributeUse y = (AttributeUse)x;
                this.q("required", String.valueOf(y.isRequired()));
                this.q("attribute declaration", y.getAttributeDeclaration());
                String vcd = y.getValueConstraintDefault();
                String vcf = y.getValueConstraintFixed();
                if (vcd != null) {
                    this.out.println("<" + vcd + ", default>");
                    break;
                }
                if (vcf != null) {
                    this.out.println("<" + vcf + ", fixed>");
                    break;
                }
                this.out.println(ABSENT);
                break;
            }
            case 1: {
                ComplexTypeDefinition y = (ComplexTypeDefinition)x;
                this.q("name", y.getName());
                this.q("target namespace", y.getTargetNamespace());
                this.q("base type definition", y.getBaseTypeDefinition());
                this.q("derivation method", y.isDerivationMethodExtension() ? "extension" : "restriction");
                this.q("final", "{ " + (y.isFinalExtension() ? "extension " : "") + (y.isFinalRestriction() ? "restriction " : "") + "}");
                this.q("abstract", String.valueOf(y.isAbstract()));
                this.q("attribute uses");
                this.temp.clear();
                y.getAttributeUses(this.temp);
                Enumeration enumeration = this.temp.elements();
                if (enumeration != null) {
                    this.out.print("{ ");
                    while (enumeration.hasMoreElements()) {
                        this.out.print(this.formatRef((Base)enumeration.nextElement()) + " ");
                    }
                    this.out.println("}");
                } else {
                    this.out.println("null");
                }
                this.q("attribute wildcard", y.getAttributeWildcard());
                SimpleTypeDefinition ctst = y.getContentTypeSimpleTypeDefinition();
                Particle ctcm = y.getContentTypeContentModel();
                if (ctst != null) {
                    this.q("content type", ctst);
                } else if (ctcm != null) {
                    this.q("content type", ctcm);
                } else {
                    this.q("content type", (String)null);
                }
                this.q("prohibited substitutions", "{ " + (y.isProhibitedSubstitutionExtension() ? "extension " : "") + (y.isProhibitedSubstitutionRestriction() ? "restriction " : "") + "}");
                break;
            }
            case 3: {
                ElementDeclaration y = (ElementDeclaration)x;
                this.q("name", y.getName());
                this.q("target namespace", y.getTargetNamespace());
                this.q("type definition", y.getTypeDefinition());
                this.q("scope", y.getScope());
                this.q("value constraint");
                String vcd = y.getValueConstraintDefault();
                String vcf = y.getValueConstraintFixed();
                if (vcd != null) {
                    this.out.println("<" + vcd + ", default>");
                } else if (vcf != null) {
                    this.out.println("<" + vcf + ", fixed>");
                } else {
                    this.out.println(ABSENT);
                }
                this.q("nillable", String.valueOf(y.isNillable()));
                this.q("identity-constraint definitions");
                this.out.print("{ ");
                this.temp.clear();
                y.getIdentityConstraintDefinitions(this.temp);
                Enumeration e = this.temp.elements();
                while (e.hasMoreElements()) {
                    IdentityConstraintDefinition icd = (IdentityConstraintDefinition)e.nextElement();
                    this.out.print(this.formatRef(icd) + " ");
                }
                this.out.println("}");
                this.q("substitution group affiliation", y.getSubstitutionGroupAffiliation());
                this.q("substitution group exclusions", "{ " + (y.isSubstitutionGroupExclusionExtension() ? "extension " : "") + (y.isSubstitutionGroupExclusionRestriction() ? "restriction " : "") + "}");
                this.q("disallowed substitutions", "{ " + (y.isDisallowedSubstitutionSubstitution() ? "substitution " : "") + (y.isDisallowedSubstitutionExtension() ? "extension " : "") + (y.isDisallowedSubstitutionRestriction() ? "restriction " : "") + "}");
                this.q("abstract", String.valueOf(y.isAbstract()));
                break;
            }
            case 11: {
                break;
            }
            case 13: {
                IdentityConstraintDefinition y = (IdentityConstraintDefinition)x;
                this.q("name", y.getName());
                this.q("target namespace", y.getTargetNamespace());
                this.q("identity-constraint category", y.isIdentityConstraintCategoryKey() ? "key" : (y.isIdentityConstraintCategoryKeyref() ? "keyref" : "unique"));
                this.q("selector", y.getSelector());
                this.q("referenced key", y.getReferencedKey());
                break;
            }
            case 7: {
                ModelGroup y = (ModelGroup)x;
                this.q("compositor", y.isCompositorAll() ? "all" : (y.isCompositorChoice() ? "choice" : "sequence"));
                this.q("particles");
                this.out.print("{ ");
                this.temp.clear();
                y.getParticles(this.temp);
                Enumeration e = this.temp.elements();
                while (e.hasMoreElements()) {
                    Particle p = (Particle)e.nextElement();
                    this.out.print(this.formatRef(p) + ' ');
                }
                this.out.println("}");
                break;
            }
            case 8: {
                ModelGroupDefinitionImpl y = (ModelGroupDefinitionImpl)x;
                this.q("name", y.getName());
                this.q("target namespace", y.getTargetNamespace());
                this.q("model group", y.getModelGroup());
                break;
            }
            case 14: {
                NotationDeclaration y = (NotationDeclaration)x;
                this.q("name", y.getName());
                this.q("target namespace", y.getTargetNamespace());
                this.q("system identifier", y.getSystemIdentifier());
                this.q("public identifier", y.getPublicIdentifier());
                break;
            }
            case 9: {
                Particle y = (Particle)x;
                int a = y.getMaxOccurs();
                this.q("min occurs", String.valueOf(y.getMinOccurs()));
                this.q("max occurs", a == Integer.MAX_VALUE ? "unbounded" : String.valueOf(a));
                this.q("term", y.getTerm());
                break;
            }
            case 0: {
                Schema y = (Schema)x;
                this.temp.clear();
                y.getTopLevelComponents(this.temp);
                Enumeration enumeration = this.temp.elements();
                while (enumeration.hasMoreElements()) {
                    Base a = (Base)enumeration.nextElement();
                    this.getIndex(a);
                }
                break;
            }
            case 2: {
                SimpleTypeDefinition y = (SimpleTypeDefinition)x;
                this.q("name", y.getName());
                this.q("target namespace", y.getTargetNamespace());
                this.q("base type definition", y.getBaseTypeDefinition());
                this.q("facets", "???");
                this.q("final", "{ " + (y.isFinalExtension() ? "extension " : "") + (y.isFinalList() ? "list " : "") + (y.isFinalRestriction() ? "restriction " : "") + (y.isFinalUnion() ? "union " : "") + "}");
                if (y.isVarietyAtomic()) {
                    this.q("variety", "atomic");
                    this.q("primitive type definition", y.getPrimitiveTypeDefinition());
                    break;
                }
                if (y.isVarietyList()) {
                    this.q("variety", "list");
                    this.q("item type definition", y.getItemTypeDefinition());
                    break;
                }
                if (y.isVarietyUnion()) {
                    this.q("variety", "union");
                    this.q("member type definitions");
                    this.out.print("{ ");
                    this.temp.clear();
                    y.getMemberTypeDefinitions(this.temp);
                    Enumeration e = this.temp.elements();
                    while (e.hasMoreElements()) {
                        TypeDefinitionBase t = (TypeDefinitionBase)e.nextElement();
                        this.out.print(this.formatRef(t) + ' ');
                    }
                    this.out.println("}");
                    break;
                }
                this.q("variety", "???");
                break;
            }
            case 10: {
                Wildcard y = (Wildcard)x;
                if (y.isNamespaceConstraintAny()) {
                    this.q("namespace constraint", "any");
                    break;
                }
                if (y.getNamespaceConstraintNegated() != null) {
                    this.q("namespace constraint", "<not, " + y.getNamespaceConstraintNegated() + ">");
                    break;
                }
                this.q("namespace constraint", "{ ??? }");
                break;
            }
        }
    }

    private void q(String nameOfProperty) {
        this.out.print("    {" + nameOfProperty + "}" + "                               ".substring(nameOfProperty.length()));
    }

    private void q(String nameOfProperty, String value) {
        this.q(nameOfProperty);
        this.out.println(this.nn(value));
    }

    private void q(String nameOfProperty, Base value) {
        this.q(nameOfProperty);
        if (value == null) {
            this.out.println(ABSENT);
        } else {
            this.out.println(this.formatRef(value));
        }
    }

    private String nn(String s) {
        return s == null ? ABSENT : s;
    }

    private int getIndex(Base x) {
        int r = this.indexer.indexOf(x);
        if (r == -1) {
            r = this.indexer.size();
            this.indexer.add(x);
        }
        return r;
    }

    private String formatRef(Base x) {
        return "[#" + this.getIndex(x) + "]";
    }
}

