/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.perspective.view.j2ee.internal.filter;

import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.extension.filter.persistable.IPersistableFilter;
import com.tssap.selena.model.extension.filter.persistable.UniPFilter;
import org.eclipse.ui.IMemento;

public class J2EEViewPFilter
extends UniPFilter {
    public static final String TYPE = "J2EE_Prj_NamePFilter";
    public static final int PRJ_EAR = 1;
    public static final int PRJ_EJB = 2;
    public static final int PRJ_EJBASS = 4;
    public static final int PRJ_WEB = 8;
    public static final int PRJ_WEBAPP = 16;
    private int hiddenProjectTypes;

    public J2EEViewPFilter() {
        this(new String[0], new String[0], true, 0);
    }

    public J2EEViewPFilter(String[] equalNames, String[] patternNames, boolean inverted, int hiddenProjectTypes) {
        super(equalNames, patternNames, inverted);
        this.hiddenProjectTypes = hiddenProjectTypes;
    }

    public boolean isAvailable(PropertyMap propertyMap) {
        boolean ret = true;
        if (propertyMap instanceof Model) {
            this.isHiddenModel((Model)propertyMap);
        }
        if (ret) {
            ret = super.isAvailable(propertyMap);
        }
        return ret;
    }

    private boolean isHiddenModel(Model model) {
        boolean ret = false;
        int type = 1;
        while (type <= 16 || ret) {
            if ((type & this.hiddenProjectTypes) > 0) {
                switch (type) {
                    case 1: {
                        ret = J2eeElementManager.isEarProject((Element)model);
                        break;
                    }
                    case 2: {
                        ret = J2eeElementManager.isEjbProject((Element)model);
                        break;
                    }
                    case 4: {
                        ret = J2eeElementManager.isEjbAssemblyProject((Element)model);
                        break;
                    }
                    case 8: {
                        ret = J2eeElementManager.isWebProject((Element)model);
                        break;
                    }
                    case 16: {
                        ret = J2eeElementManager.isWebAssemblyProject((Element)model);
                        break;
                    }
                }
            }
            type *= 2;
        }
        return ret;
    }

    public static IPersistableFilter createFilter(IMemento memento) {
        J2EEViewPFilter ret = null;
        if (J2EEViewPFilter.checkMemento(memento)) {
            ret = new J2EEViewPFilter();
            ret.restoreState(memento);
        }
        return ret;
    }

    private static boolean checkMemento(IMemento memento) {
        return true;
    }

    public void restoreState(IMemento memento) {
        super.restoreState(memento);
        Integer hidden = memento.getInteger("hiddenPrjTypes");
        this.hiddenProjectTypes = hidden != null ? hidden : 0;
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString("type", this.getType());
        memento.putInteger("hiddenPrjTypes", this.hiddenProjectTypes);
    }

    public String getType() {
        return TYPE;
    }
}

