/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.perspective.view.j2ee.internal.filter;

import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.archive.IJ2eeArchiveAwareFile;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.extension.filter.YesManFilter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class EARModulesFilter
extends YesManFilter {
    public boolean isAvailable(PropertyMap propertyMap) {
        Element elem;
        if (propertyMap instanceof Element && J2eeElementManager.isEarProject((Element)(elem = (Element)propertyMap).getModel())) {
            if (J2eeElementManager.isEAR((Element)elem)) {
                return true;
            }
            if (J2eeElementManager.isEjbJarProxy((Element)elem)) {
                return true;
            }
            if (J2eeElementManager.isWARProxy((Element)elem)) {
                return true;
            }
            if (J2eeElementManager.isEarArchive((Element)elem)) {
                return true;
            }
            if (J2eeElementManager.isEarProject((Element)elem.getParent()) && J2eeElementManager.isEARSAPDescriptorType((Element)elem)) {
                return true;
            }
            if (J2eeElementManager.isEARMETAINFFolder((Element)elem)) {
                EntityEnumeration entityEnumeration = ((Entity)elem).children();
                while (entityEnumeration.hasMoreElements()) {
                    Element element = (Element)entityEnumeration.nextElement();
                    if (J2eeElementManager.isEAR((Element)element) || this.isEARXMLFILE(element) || this.isEARArchiveAwareMETAINFFile(element)) continue;
                    return true;
                }
                return false;
            }
            if (elem.getParent() != null && elem.getUniqueName().getDomain().equalsIgnoreCase("DataModel") && elem.getUniqueName().getLocation().indexOf("META-INF") >= 0 && !J2eeElementManager.isEAR((Element)elem) && !this.isEARXMLFILE(elem) && !this.isEARArchiveAwareMETAINFFile(elem)) {
                return true;
            }
        }
        return false;
    }

    private boolean isEARXMLFILE(Element element) {
        return element.getUniqueName().getName().equalsIgnoreCase("application.xml");
    }

    private boolean isEARArchiveAwareMETAINFFile(Element element) {
        IJ2eeArchiveAwareFile[] awareFiles = UIPlugin.getEARArchiveAwareFiles();
        IResource res = J2eeElementManager.getResourceToElement((Element)element);
        if (res == null || !(res instanceof IFile)) {
            return false;
        }
        int i = 0;
        while (i < awareFiles.length) {
            IJ2eeArchiveAwareFile file = awareFiles[i];
            if (file.getName().equalsIgnoreCase(element.getUniqueName().getName()) && J2eeElementManager.isEARMETAINFFolder((Element)element.getParent())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

