/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.perspective.view.j2ee.internal;

import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.view.GenericJ2eeLabelProvider;
import com.tssap.j2ee.ui.perspective.view.ejb.internal.EjbLabelProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.proxy.ProxyMetaInfo;
import com.tssap.util.ui.ITooltipProvider;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.internal.ui.viewsupport.StorageLabelProvider;
import org.eclipse.swt.graphics.Image;

public class J2eeLabelProvider
extends EjbLabelProvider
implements ITooltipProvider {
    private GenericJ2eeLabelProvider[] externalProviders = null;
    private StorageLabelProvider storageLableProvider = new StorageLabelProvider();

    public J2eeLabelProvider() {
        this.externalProviders = UIPlugin.getExternalJ2eeLabelProvider();
    }

    public Image getImage(Object obj) {
        Image parentImg;
        if (obj instanceof Reference) {
            obj = ((Reference)obj).getEntity();
        }
        if ((parentImg = super.getImage(obj)) == null && obj instanceof Element) {
            Element elem = (Element)obj;
            if (J2eeElementManager.isEarProject((Element)elem)) {
                if (J2eeElementManager.isComponentProject((Element)elem)) {
                    return this.getImageRegistry().get("earComponentProject");
                }
                return this.getImageRegistry().get("earProject");
            }
            if (J2eeElementManager.isEarArchive((Element)elem)) {
                return this.getImageRegistry().get("ear");
            }
            if (J2eeElementManager.isWebModule((Element)elem)) {
                if (J2eeElementManager.isComponentProject((Element)elem)) {
                    return this.getImageRegistry().get("webApplicationComponentProject");
                }
                return this.getImageRegistry().get("webApplicationProject");
            }
            if (J2eeElementManager.isWarArchive((Element)elem)) {
                return this.getImageRegistry().get("war");
            }
            if (J2eeElementManager.isSecurityRole((Element)elem)) {
                return this.getImageRegistry().get("SecurityRole");
            }
            if (J2eeElementManager.isWAR((Element)elem)) {
                return this.getImageRegistry().get("warDD");
            }
            if (J2eeElementManager.isEAR((Element)elem)) {
                return this.getImageRegistry().get("earDD");
            }
            if (J2eeElementManager.isEjbJar((Element)elem)) {
                return this.getImageRegistry().get("ejbJarDD");
            }
            if (J2eeElementManager.isWebModule((Element)elem.getModel())) {
                Image img = null;
                img = this.getWebSourceImage(elem);
                if (img != null) {
                    return img;
                }
                return this.getExternalImage(obj);
            }
            if (obj instanceof ReferenceCollection) {
                obj = ((ReferenceCollection)obj).getParent();
                return this.getImage(obj);
            }
            if (J2eeElementManager.isProxy((Element)elem)) {
                Element proxiedElement = ProxyMetaInfo.getSourceElement((UniqueName)elem.getUniqueName());
                if (proxiedElement != null) {
                    return this.getImage(proxiedElement);
                }
                return this.getExternalImage(obj);
            }
            if (J2eeElementManager.isEarProject((Element)elem.getModel())) {
                Image img = null;
                img = this.getImageForFilesAndFolders(elem);
                if (img != null) {
                    return img;
                }
                return this.getExternalImage(obj);
            }
            return this.getExternalImage(obj);
        }
        return parentImg;
    }

    public String getText(Object element) {
        Element proxiedElement;
        if (element instanceof Reference) {
            element = ((Reference)element).getEntity();
        }
        if (element instanceof Entity) {
            String elemName;
            Entity elem = (Entity)element;
            if (J2eeElementManager.isBeanRegistry((Element)elem)) {
                return "EJB Candidates";
            }
            if (J2eeElementManager.isListenerRegistry((Element)elem)) {
                return "Listener Candidates";
            }
            if (J2eeElementManager.isServletRegistry((Element)elem)) {
                return "Servlet Candidates";
            }
            if (J2eeElementManager.isJspRegistry((Element)elem)) {
                return "Jsp Candidates";
            }
            if (J2eeElementManager.isFilterRegistry((Element)elem)) {
                return "Filter Candidates";
            }
            if ((J2eeElementManager.isEARSAPDescriptorType((Element)elem) || J2eeElementManager.isEJBSAPDescriptorType((Element)elem) || J2eeElementManager.isWEBSAPDescriptorType((Element)elem)) && (elemName = elem.getPropertyValue("$name")) != null) {
                if (elemName.indexOf("META-INF") >= 0) {
                    elemName = elemName.substring("META-INF".length() + 1);
                    return elemName;
                }
                if (elemName.indexOf("META-INF") >= 0) {
                    elemName = elemName.substring("META-INF".length() + 1);
                    return elemName;
                }
                if (elemName.indexOf("WEB-INF") >= 0) {
                    elemName = elemName.substring("WEB-INF".length() + 1);
                    return elemName;
                }
                return elemName;
            }
            if (J2eeElementManager.isEjbModule((Element)elem.getModel())) {
                if (J2eeElementManager.isProxy((Element)elem) && J2eeElementManager.isEnterpriseJavaBean((Element)elem)) {
                    return J2eeElementManager.getEnterpriseJavaBean((Element)elem).getEjbName();
                }
                if (J2eeElementManager.isSecurityRole((Element)elem)) {
                    return elem.getPropertyValue("$name");
                }
                if (elem.hasPropertyValue("$metaclass", "com.tssap.j2ee.core.ejbjar.EjbRelation")) {
                    return elem.getPropertyValue("ejbRelationName");
                }
            }
            if (J2eeElementManager.isEjbJarProxy((Element)elem)) {
                return ProxyMetaInfo.getSourceModel((UniqueName)elem.getUniqueName()).getPropertyValue("$name");
            }
            if (J2eeElementManager.isWebModule((Element)elem.getModel())) {
                if (J2eeElementManager.isFilter((Element)elem) || J2eeElementManager.isListener((Element)elem) || J2eeElementManager.isServlet((Element)elem) || J2eeElementManager.isJsp((Element)elem)) {
                    return J2eeElementManager.getWebSource((Element)elem).getName();
                }
                if (J2eeElementManager.isSecurityRole((Element)elem)) {
                    return elem.getPropertyValue("$name");
                }
            }
            if (J2eeElementManager.isWARProxy((Element)elem)) {
                return ProxyMetaInfo.getSourceModel((UniqueName)elem.getUniqueName()).getPropertyValue("$name");
            }
            if (J2eeElementManager.isEarProject((Element)elem.getModel()) && J2eeElementManager.isSecurityRole((Element)elem)) {
                String name = elem.getUniqueName().getName();
                if (name.equals("")) {
                    name = ProxyMetaInfo.getSourceElement((UniqueName)elem.getUniqueName()).getPropertyValue("$name");
                }
                return name;
            }
            if (J2eeElementManager.isWebModule((Element)elem.getModel())) {
                if (J2eeElementManager.isWebFolder((Element)elem)) {
                    return elem.getPropertyValue("$name");
                }
                if (J2eeElementManager.isWebClientSource((Element)elem)) {
                    String ret = elem.getUniqueName().getName();
                    if (ret == null || ret.equals("")) {
                        ret = elem.getPropertyValue("$name");
                    }
                    return ret.substring(ret.lastIndexOf("/") + 1);
                }
            }
        }
        String text = null;
        int i = 0;
        while (i < this.externalProviders.length) {
            text = this.externalProviders[i].getText(element);
            if (text != null && !text.equals("")) {
                return text;
            }
            ++i;
        }
        if (element instanceof Entity && J2eeElementManager.isProxy((Element)((Element)element)) && (proxiedElement = ProxyMetaInfo.getSourceElement((UniqueName)((Element)element).getUniqueName())) != null) {
            return this.getText(proxiedElement);
        }
        text = super.getText(element);
        if (text == null || text.equals("")) {
            Entity diagramEntity;
            if (element instanceof ReferenceCollection && (diagramEntity = ((ReferenceCollection)element).getParent()) != null) {
                return this.getText(diagramEntity);
            }
            return element.toString();
        }
        return text;
    }

    private final Image getWebSourceImage(Element elem) {
        if (J2eeElementManager.isWAR((Element)elem)) {
            return null;
        }
        if (J2eeElementManager.isFilter((Element)elem)) {
            return this.getImageRegistry().get("filter");
        }
        if (J2eeElementManager.isListener((Element)elem)) {
            return this.getImageRegistry().get("listener");
        }
        if (J2eeElementManager.isJsp((Element)elem)) {
            return this.getImageRegistry().get("jsp");
        }
        if (J2eeElementManager.isServlet((Element)elem)) {
            return this.getImageRegistry().get("servlet");
        }
        if (J2eeElementManager.isHtmlFile((Element)elem)) {
            return this.getImageRegistry().get("html");
        }
        if (J2eeElementManager.isJavaFile((Element)elem)) {
            return this.getImageRegistry().get("JavaFile");
        }
        if (J2eeElementManager.isListenerRegistry((Element)elem)) {
            return this.getImageRegistry().get("listenerRegistry");
        }
        if (J2eeElementManager.isServletRegistry((Element)elem)) {
            return this.getImageRegistry().get("servletRegistry");
        }
        if (J2eeElementManager.isJspRegistry((Element)elem)) {
            return this.getImageRegistry().get("jspRegistry");
        }
        if (J2eeElementManager.isFilterRegistry((Element)elem)) {
            return this.getImageRegistry().get("filterRegistry");
        }
        if (J2eeElementManager.isJavaSrcFolder((Element)elem)) {
            return this.getImageRegistry().get("JavaSourceFolder");
        }
        if (J2eeElementManager.isPackageFragmentFolder((Element)elem)) {
            return this.getImageRegistry().get("JavaPackage");
        }
        if (J2eeElementManager.isWebClientSourceFolder((Element)elem)) {
            return this.getImageRegistry().get("JavaSourceFolder");
        }
        if (J2eeElementManager.isResourceReference((Element)elem)) {
            return this.getImageRegistry().get("ResourceRef");
        }
        if (J2eeElementManager.isEnvironmentEntry((Element)elem)) {
            return this.getImageRegistry().get("EnvEntry");
        }
        if (J2eeElementManager.isResourceEnvironmentReference((Element)elem)) {
            return this.getImageRegistry().get("ResourceEnvRef");
        }
        if (J2eeElementManager.isInitParameter((Element)elem)) {
            return this.getImageRegistry().get("InitParameter");
        }
        if (J2eeElementManager.isSecurityConstraint((Element)elem)) {
            return this.getImageRegistry().get("SecurityConstraint");
        }
        if (J2eeElementManager.isWebResourceCollection((Element)elem)) {
            return this.getImageRegistry().get("WebResourceCollection");
        }
        if (J2eeElementManager.isMimeMapping((Element)elem)) {
            return this.getImageRegistry().get("MimeMapping");
        }
        if (J2eeElementManager.isMimeMappingRegistry((Element)elem)) {
            return this.getImageRegistry().get("MimeMappingRegistry");
        }
        if (J2eeElementManager.isContextParameter((Element)elem)) {
            return this.getImageRegistry().get("ContextParameter");
        }
        if (J2eeElementManager.isContextParameterRegistry((Element)elem)) {
            return this.getImageRegistry().get("ContextParameterRegistry");
        }
        if (J2eeElementManager.isEjbRef((Element)elem)) {
            return this.getImageRegistry().get("EjbRef");
        }
        if (J2eeElementManager.isEjbLocalRef((Element)elem)) {
            return this.getImageRegistry().get("EjbLocalRef");
        }
        if (J2eeElementManager.isErrorPage((Element)elem)) {
            return this.getImageRegistry().get("ErrorPage");
        }
        Image img = null;
        img = this.getImageForFilesAndFolders(elem);
        if (img != null) {
            return img;
        }
        return null;
    }

    private Image getExternalImage(Object obj) {
        Image img;
        Element el;
        IResource underlyingResource;
        int i = 0;
        while (i < this.externalProviders.length) {
            Image img2 = null;
            img2 = this.externalProviders[i].getImage(obj);
            if (img2 != null) {
                return img2;
            }
            ++i;
        }
        if (obj instanceof Element && (underlyingResource = J2eeElementManager.getResourceToElement((Element)(el = (Element)obj))) != null && (img = this.storageLableProvider.getImage((Object)underlyingResource)) != null) {
            return img;
        }
        return null;
    }

    public String getTooltipText(Object element) {
        return super.getTooltipText(element);
    }
}

