/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.perspective.view.j2ee.internal;

import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.ejb.util.EjbUtil;
import com.tssap.j2ee.ui.perspective.view.j2ee.internal.J2eeDecoratedImageRegistry;
import com.tssap.j2ee.ui.perspective.view.j2ee.internal.J2eeElementImageDescriptor;
import com.tssap.j2ee.ui.perspective.view.j2ee.internal.WrappingImageDescriptor;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelAccessEvent;
import com.tssap.selena.model.elements.ModelAccessListener;
import com.tssap.selena.model.elements.ModelChangeEvent;
import com.tssap.selena.model.elements.ModelChangeListener;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.extension.filefolder.FileAndFolderManagement;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.IProblemChangedListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class J2eeLabelDecorator
implements ILabelDecorator {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$perspective$view$j2ee$internal$J2eeLabelDecorator == null ? (class$com$tssap$j2ee$ui$perspective$view$j2ee$internal$J2eeLabelDecorator = J2eeLabelDecorator.class$("com.tssap.j2ee.ui.perspective.view.j2ee.internal.J2eeLabelDecorator")) : class$com$tssap$j2ee$ui$perspective$view$j2ee$internal$J2eeLabelDecorator));
    J2eeDecoratedImageRegistry imgReg = new J2eeDecoratedImageRegistry();
    private IProblemChangedListener myProblemChangedListener;
    private ListenerList myListeners;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$perspective$view$j2ee$internal$J2eeLabelDecorator;

    public J2eeLabelDecorator() {
        BeanCorruptionUpdater.create();
    }

    public Image decorateImage(Image image, Object element) {
        if (image == null) {
            return null;
        }
        int deco = this.getDecorateFlag(element);
        Rectangle bounds = image.getBounds();
        Image ret = this.imgReg.get((ImageDescriptor)new J2eeElementImageDescriptor(new WrappingImageDescriptor(image), deco, new Point(bounds.width, bounds.height)));
        return ret;
    }

    private int getDecorateFlag(Object element) {
        int ret = 0;
        if (element != null && element instanceof Element) {
            Element selenaElement = (Element)element;
            IResource res = J2eeElementManager.getResourceToElement((Element)selenaElement);
            if (res != null) {
                try {
                    IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                    ret = this.getMaxSeverity(markers);
                }
                catch (CoreException e) {
                    tracer.error("", (Throwable)e);
                }
            } else {
                boolean isEJB = J2eeElementManager.isEnterpriseJavaBean((Element)selenaElement);
                boolean isBeanReg = J2eeElementManager.isBeanRegistry((Element)selenaElement);
                if (isBeanReg || isEJB) {
                    ret = this.getEJBMarkerSeverity(selenaElement, isEJB, isBeanReg);
                }
            }
        }
        return ret;
    }

    private int getEJBMarkerSeverity(Element selenaElement, boolean isEJB, boolean isBeanReg) {
        IEnterpriseJavaBean enterpriseJavaBean;
        int ret = 0;
        IMarker[] markers = null;
        IResource projectResource = FileAndFolderManagement.getInstance().getResource((Element)selenaElement.getModel());
        try {
            markers = projectResource.findMarkers(UIPlugin.BEAN_PROBLEM_MARKER_ID, false, 2);
        }
        catch (CoreException e) {
            tracer.error("", (Throwable)e);
        }
        if (isBeanReg) {
            ret = markers != null ? this.getMaxSeverity(markers) : 0;
        } else if (isEJB && (enterpriseJavaBean = J2eeElementManager.getEnterpriseJavaBean((Element)selenaElement)) != null) {
            int i = 0;
            while (i < markers.length) {
                try {
                    IResource beanRes = enterpriseJavaBean.getBeanClass().getUnderlyingResource();
                    if (markers[i].getResource().equals((Object)beanRes)) {
                        ret = this.getSeverity(markers[i]);
                    }
                }
                catch (JavaModelException e1) {
                    tracer.error("", (Throwable)e1);
                }
                ++i;
            }
        }
        return ret;
    }

    private int getMaxSeverity(IMarker[] markers) {
        int ret = 0;
        int i = 0;
        while (i < markers.length && ret != 1) {
            ret = this.getSeverity(markers[i]);
            ++i;
        }
        return ret;
    }

    private int getSeverity(IMarker marker) {
        int ret = 0;
        int priority = marker.getAttribute("severity", 0);
        if (priority == 1) {
            ret = 2;
        } else if (priority == 2) {
            ret = 1;
        }
        return ret;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public void dispose() {
        this.imgReg.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.myListeners != null) {
            this.myListeners.remove((Object)listener);
            if (this.myListeners.isEmpty() && this.myProblemChangedListener != null) {
                JavaPlugin.getDefault().getProblemMarkerManager().removeListener(this.myProblemChangedListener);
                this.myProblemChangedListener = null;
            }
        }
    }

    public void addListener(ILabelProviderListener listener) {
        if (this.myListeners == null) {
            this.myListeners = new ListenerList();
        }
        this.myListeners.add((Object)listener);
        if (this.myProblemChangedListener == null) {
            this.myProblemChangedListener = new IProblemChangedListener(){

                public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
                    J2eeLabelDecorator.this.fireProblemsChanged(changedResources, isMarkerChange);
                }
            };
            JavaPlugin.getDefault().getProblemMarkerManager().addListener(this.myProblemChangedListener);
        }
    }

    private void fireProblemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        if (this.myListeners != null && !this.myListeners.isEmpty()) {
            LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object[])changedResources);
            Object[] listeners = this.myListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ILabelProviderListener)listeners[i]).labelProviderChanged(event);
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class BeanCorruptionUpdater
    implements ModelChangeListener,
    ModelAccessListener {
        private static BeanCorruptionUpdater instance = null;
        private List beanElList = new ArrayList();

        private BeanCorruptionUpdater() {
        }

        public static void create() {
            if (instance != null) {
                return;
            }
            Enumeration enumeration = ModelAccess.models();
            ArrayList<Model> modelList = new ArrayList<Model>();
            while (enumeration.hasMoreElements()) {
                Model element = (Model)enumeration.nextElement();
                if (!J2eeElementManager.isEjbProject((Element)element)) continue;
                modelList.add(element);
                IEnterpriseJavaBean[] beans = J2eeElementManager.getEjbProject((Element)element).getEnterpriseBeans();
                int i = 0;
                while (i < beans.length) {
                    EjbUtil.checkEjb((IEnterpriseJavaBean)beans[i], (boolean)true);
                    ++i;
                }
            }
            Model[] models = modelList.toArray(new Model[modelList.size()]);
            instance = new BeanCorruptionUpdater();
            ModelAccess.addModelAccessListener((ModelAccessListener)instance);
            int i = 0;
            while (i < models.length) {
                models[i].addModelDeltaListener((ModelChangeListener)instance);
                ++i;
            }
        }

        public void modelChanged(ModelChangeEvent changeEvent) {
            this.searchBeans(changeEvent.getRootDelta());
            int i = 0;
            while (i < this.beanElList.size()) {
                EjbUtil.checkEjb((IEnterpriseJavaBean)J2eeElementManager.getEnterpriseJavaBean((Element)((Element)this.beanElList.get(i))), (boolean)true);
                ++i;
            }
        }

        private void searchBeans(ModelDeltaNode node) {
            this.beanElList.clear();
            this.searchBeans(node, this.beanElList);
        }

        private void searchBeans(ModelDeltaNode node, List beanElList) {
            if (node.getElement() != null && !node.isDeleted()) {
                if (J2eeElementManager.isEnterpriseJavaBean((Element)node.getElement())) {
                    beanElList.add(node.getElement());
                } else {
                    Enumeration enumeration = node.changedChildren();
                    while (enumeration.hasMoreElements()) {
                        this.searchBeans((ModelDeltaNode)enumeration.nextElement(), beanElList);
                    }
                }
            }
        }

        public void modelCreated(ModelAccessEvent event) {
            Model model = event.getModel();
            model.addModelDeltaListener((ModelChangeListener)this);
        }

        public void modelRemoved(ModelAccessEvent event) {
        }
    }
}

