/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.perspective.view.j2ee.internal;

import com.tssap.selena.model.util.Assert;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class J2eeDecoratedImageRegistry {
    private HashMap myRegistry = new HashMap(10);
    private Display myDisplay;

    public J2eeDecoratedImageRegistry() {
        this(null);
    }

    public J2eeDecoratedImageRegistry(Display display) {
        if (display == null) {
            display = this.getDisplay();
        }
        this.myDisplay = display;
        Assert.isNotNull((Object)this.myDisplay);
        this.hookDisplay();
    }

    private Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public Image get(ImageDescriptor descriptor) {
        Image result;
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((result = (Image)this.myRegistry.get(descriptor)) != null) {
            return result;
        }
        Assert.isTrue((this.myDisplay == this.getDisplay() ? 1 : 0) != 0, (String)"Allocating image for wrong display.");
        result = descriptor.createImage();
        if (result != null) {
            this.myRegistry.put(descriptor, result);
        }
        return result;
    }

    public void dispose() {
        Iterator iter = this.myRegistry.values().iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            image.dispose();
        }
        this.myRegistry.clear();
    }

    private void hookDisplay() {
        this.myDisplay.disposeExec(new Runnable(){

            public void run() {
                J2eeDecoratedImageRegistry.this.dispose();
            }
        });
    }
}

