/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.perspective.view.j2ee;

import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.selena.model.elements.Element;
import java.text.Collator;
import org.eclipse.jface.viewers.ViewerSorter;

public class J2eeViewSorter
extends ViewerSorter {
    private static int CATEGORY_DC_FOLDER = 101;
    private static int CATEGORY_SAP_SPECIFIC_DEPLOYMENT_DESCRIPTOR = 102;
    private static int CATEGORY_DEPLOYMENT_DESCRIPTOR = 103;
    private static int CATEGORY_EJB_CANDIDATES_FOLDER = 110;
    private static int CATEGORY_JSP_CANDIDATES_FOLDER = 111;
    private static int CATEGORY_SERVLET_CANDIDATES_FOLDER = 112;
    private static int CATEGORY_FILTER_CANDIDATES_FOLDER = 113;
    private static int CATEGORY_LISTENER_CANDIDATES_FOLDER = 114;
    private static int CATEGORY_META_INF_FOLDER = 120;
    private static int CATEGORY_WEB_INF_FOLDER = 121;
    private static int CATEGORY_SOURCE_FOLDER = 125;
    private static int CATEGORY_CONTENT_FOLDER = 126;
    private static int CATEGORY_ARCHIVE = 127;
    private static int CATEGORY_EJB_FIELD = 200;
    private static int CATEGORY_EJB_METHOD = 220;
    private static int CATEGORY_EJB_BUSINESS_METHOD = 221;
    private static int CATEGORY_EJB_CREATE_METHOD = 222;
    private static int CATEGORY_EJB_FINDER_METHOD = 223;
    private static int CATEGORY_EJB_HOME_METHOD = 224;
    private static int CATEGORY_EJB_SELECT_METHOD = 225;
    private static int CATEGORY_EJB_RELATION = 240;

    public J2eeViewSorter() {
    }

    public J2eeViewSorter(Collator collator) {
        super(collator);
    }

    public int category(Object object) {
        int ret = super.category(object);
        if (object instanceof Element) {
            Element element = (Element)object;
            if (J2eeElementManager.isDCMetaDataNode((Element)element)) {
                return CATEGORY_DC_FOLDER;
            }
            if (J2eeElementManager.isEjbJar((Element)element) || J2eeElementManager.isEAR((Element)element) || J2eeElementManager.isWAR((Element)element)) {
                return CATEGORY_DEPLOYMENT_DESCRIPTOR;
            }
            if (J2eeElementManager.isEJBSAPDescriptorType((Element)element) || J2eeElementManager.isEARSAPDescriptorType((Element)element) || J2eeElementManager.isWEBSAPDescriptorType((Element)element)) {
                return CATEGORY_SAP_SPECIFIC_DEPLOYMENT_DESCRIPTOR;
            }
            if (J2eeElementManager.isBeanRegistry((Element)element)) {
                return CATEGORY_EJB_CANDIDATES_FOLDER;
            }
            if (J2eeElementManager.isJspRegistry((Element)element)) {
                return CATEGORY_JSP_CANDIDATES_FOLDER;
            }
            if (J2eeElementManager.isServletRegistry((Element)element)) {
                return CATEGORY_SERVLET_CANDIDATES_FOLDER;
            }
            if (J2eeElementManager.isFilterRegistry((Element)element)) {
                return CATEGORY_FILTER_CANDIDATES_FOLDER;
            }
            if (J2eeElementManager.isListenerRegistry((Element)element)) {
                return CATEGORY_LISTENER_CANDIDATES_FOLDER;
            }
            if (J2eeElementManager.isMETAINFFolder((Element)element)) {
                return CATEGORY_META_INF_FOLDER;
            }
            if (J2eeElementManager.isWEBINFFolder((Element)element)) {
                return CATEGORY_WEB_INF_FOLDER;
            }
            if (J2eeElementManager.isJ2eeSourceFolder((Element)element)) {
                return CATEGORY_SOURCE_FOLDER;
            }
            if (J2eeElementManager.isWebFolder((Element)element)) {
                return CATEGORY_CONTENT_FOLDER;
            }
            if (J2eeElementManager.isEjbJarArchive((Element)element) || J2eeElementManager.isWarArchive((Element)element) || J2eeElementManager.isEarArchive((Element)element)) {
                return CATEGORY_ARCHIVE;
            }
            if (J2eeElementManager.isEjbField((Element)element)) {
                return CATEGORY_EJB_FIELD;
            }
            if (J2eeElementManager.isEjbMethod((Element)element)) {
                return CATEGORY_EJB_METHOD;
            }
            if (J2eeElementManager.isBusinessMethod((Element)element)) {
                return CATEGORY_EJB_BUSINESS_METHOD;
            }
            if (J2eeElementManager.isCreateMethod((Element)element)) {
                return CATEGORY_EJB_CREATE_METHOD;
            }
            if (J2eeElementManager.isFinderMethod((Element)element)) {
                return CATEGORY_EJB_FINDER_METHOD;
            }
            if (J2eeElementManager.isHomeMethod((Element)element)) {
                return CATEGORY_EJB_HOME_METHOD;
            }
            if (J2eeElementManager.isSelectMethod((Element)element)) {
                return CATEGORY_EJB_SELECT_METHOD;
            }
            if (J2eeElementManager.isEjbRelation((Element)element)) {
                return CATEGORY_EJB_RELATION;
            }
        } else if (ret == 0) {
            ret = Integer.MAX_VALUE;
        }
        return ret;
    }
}

