/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.perspective.view.j2ee;

import com.tssap.j2ee.ui.perspective.view.j2ee.internal.J2eeLabelProvider;
import com.tssap.j2ee.ui.perspective.view.j2ee.internal.filter.J2EEViewPFilter;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.extension.filter.persistable.IFilterFactory;
import com.tssap.selena.model.extension.filter.persistable.IPersistableFilter;
import com.tssap.util.ui.pane.IGridLayoutData;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.SelectionDialog;

public class J2EEViewFilterUtil {
    public static IFilterFactory getJ2EEViewFilterFactory() {
        return J2EEViewFilterFactory.getInstance();
    }

    public static J2EEFilterEditDialog getJ2EEFilterEditDialog(Shell shell, Model[] models, String[] reservedNames, J2EEViewPFilter filter) {
        return new J2EEFilterEditDialog(shell, models, reservedNames, filter);
    }

    public static class J2EEViewFilterFactory
    implements IFilterFactory {
        private static J2EEViewFilterFactory instance;

        private J2EEViewFilterFactory() {
        }

        public boolean canCreateFilter(IMemento memento) {
            String type = memento.getString("type");
            return "J2EE_Prj_NamePFilter".equals(type);
        }

        public static IFilterFactory getInstance() {
            if (instance == null) {
                instance = new J2EEViewFilterFactory();
            }
            return instance;
        }

        public IPersistableFilter createFilter(IMemento memento) {
            IPersistableFilter ret = null;
            String type = memento.getString("type");
            if ("J2EE_Prj_NamePFilter".equals(type)) {
                ret = J2EEViewPFilter.createFilter(memento);
            }
            return ret;
        }
    }

    public static class J2EEFilterEditDialog
    extends SelectionDialog {
        private Label statusLabel;
        private Text patternTxtField;
        private CheckboxTableViewer projectTableViewer;
        private Button hideRadio;
        private Button showRadio;
        private Text nameTxtField;
        private int SIZING_SELECTION_WIDGET_HEIGHT = 300;
        private int SIZING_SELECTION_WIDGET_WIDTH = 300;
        private J2EEViewPFilter filter;
        private Model[] myModels;
        private String[] myReservedNames;

        public J2EEFilterEditDialog(Shell shell, Model[] models, String[] reservedNames, J2EEViewPFilter filter) {
            super(shell);
            super.setTitle("Filter Editor");
            super.setMessage("Edit filter");
            this.myModels = models;
            this.myReservedNames = reservedNames != null ? reservedNames : new String[]{};
            this.filter = filter;
        }

        protected Control createDialogArea(Composite parent) {
            IGridLayoutPane mainPane = PaneFactory.createGridLayoutPane((Composite)parent, (int)1);
            GridData data = new GridData(1808);
            data.widthHint = this.SIZING_SELECTION_WIDGET_WIDTH;
            data.heightHint = this.SIZING_SELECTION_WIDGET_HEIGHT;
            mainPane.getComposite().setLayoutData((Object)data);
            IGridLayoutData gridData = mainPane.createGridLayoutData(4, 4, true, false);
            IGridLayoutPane namePane = mainPane.addGridLayoutPane(2, gridData);
            gridData = namePane.createGridLayoutData(4, 4, true, false);
            namePane.addTextLabel("Filter name ");
            this.nameTxtField = namePane.addTextField(false, gridData);
            this.nameTxtField.addModifyListener(new ModifyListener(this){
                private final /* synthetic */ J2EEFilterEditDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void modifyText(ModifyEvent e) {
                    if (this.isReservedName(J2EEFilterEditDialog.access$000(this.this$0).getText())) {
                        J2EEFilterEditDialog.access$100(this.this$0).setText("Name is already used");
                        Button okBut = J2EEFilterEditDialog.access$201(this.this$0, 0);
                        if (okBut != null) {
                            okBut.setEnabled(false);
                        }
                    } else {
                        J2EEFilterEditDialog.access$100(this.this$0).setText("");
                        Button okBut = J2EEFilterEditDialog.access$301(this.this$0, 0);
                        if (okBut != null) {
                            okBut.setEnabled(true);
                        }
                    }
                }

                private boolean isReservedName(String string) {
                    boolean ret = false;
                    int i = 0;
                    while (i < J2EEFilterEditDialog.access$400(this.this$0).length && !ret) {
                        if (string.equals(J2EEFilterEditDialog.access$400(this.this$0)[i])) {
                            ret = true;
                        }
                        ++i;
                    }
                    return ret;
                }
            });
            mainPane.addPlaceholder();
            IGridLayoutPane showHidePane = mainPane.addGridLayoutPane(2);
            this.showRadio = showHidePane.addRadioButton("Show Filter");
            this.hideRadio = showHidePane.addRadioButton("Hide Filter");
            gridData = mainPane.createGridLayoutData(4, 4, true, true);
            this.projectTableViewer = mainPane.addCheckboxTableViewer(false, gridData);
            this.projectTableViewer.setLabelProvider((IBaseLabelProvider)new J2eeLabelProvider());
            mainPane.addPlaceholder();
            mainPane.addTextLabel("Name Patterns:");
            mainPane.addTextLabel("'*', '?' supported. ';' seperated");
            gridData = mainPane.createGridLayoutData(4, 4, true, false);
            this.patternTxtField = mainPane.addTextField(false, gridData);
            gridData = mainPane.createGridLayoutData(4, 4, true, false);
            mainPane.addPlaceholder();
            this.statusLabel = mainPane.addTextLabel("", gridData);
            this.statusLabel.setForeground(this.statusLabel.getDisplay().getSystemColor(3));
            this.fillControls();
            return parent;
        }

        private void fillControls() {
            this.nameTxtField.setText(this.filter.getName());
            this.showRadio.setSelection(!this.filter.isInverted());
            this.hideRadio.setSelection(this.filter.isInverted());
            this.projectTableViewer.add((Object[])this.myModels);
            ArrayList<String> namePatterns = new ArrayList<String>(Arrays.asList(this.filter.getEqualNames()));
            int i = 0;
            while (i < this.myModels.length) {
                if (namePatterns.contains(this.myModels[i].getUniqueName().getName())) {
                    this.projectTableViewer.setChecked((Object)this.myModels[i], true);
                }
                ++i;
            }
            String[] patterns = this.filter.getPatternNames();
            StringBuffer buf = new StringBuffer();
            int i2 = 0;
            while (i2 < patterns.length) {
                buf.append(patterns[i2] + " ;");
                ++i2;
            }
            this.patternTxtField.setText(buf.toString());
        }

        private void fillFilterDataFromControls() {
            this.filter.setName(this.nameTxtField.getText());
            this.filter.setInverted(this.hideRadio.getSelection());
            this.filter.setEqualNames(this.getEqualNameFromUI());
            this.filter.setPatternNames(this.getPatternNamesFromUI());
        }

        private String[] getEqualNameFromUI() {
            ArrayList<String> prjNames = new ArrayList<String>();
            Object[] chectObj = this.projectTableViewer.getCheckedElements();
            int i = 0;
            while (i < chectObj.length) {
                if (chectObj[i] instanceof Model) {
                    Model checkedModel = (Model)chectObj[i];
                    prjNames.add(checkedModel.getUniqueName().getName());
                }
                ++i;
            }
            return prjNames.toArray(new String[prjNames.size()]);
        }

        private String[] getPatternNamesFromUI() {
            ArrayList<String> patterns = new ArrayList<String>();
            String patternString = this.patternTxtField.getText();
            StringTokenizer patTokenizer = new StringTokenizer(patternString, ";");
            while (patTokenizer.hasMoreTokens()) {
                String pat = patTokenizer.nextToken().trim();
                if (pat.length() <= 0) continue;
                patterns.add(pat);
            }
            return patterns.toArray(new String[patterns.size()]);
        }

        protected void okPressed() {
            this.fillFilterDataFromControls();
            super.okPressed();
        }

        static /* synthetic */ Text access$000(J2EEFilterEditDialog x0) {
            return x0.nameTxtField;
        }

        static /* synthetic */ Label access$100(J2EEFilterEditDialog x0) {
            return x0.statusLabel;
        }

        static /* synthetic */ Button access$201(J2EEFilterEditDialog x0, int x1) {
            return super.getButton(x1);
        }

        static /* synthetic */ Button access$301(J2EEFilterEditDialog x0, int x1) {
            return super.getButton(x1);
        }

        static /* synthetic */ String[] access$400(J2EEFilterEditDialog x0) {
            return x0.myReservedNames;
        }
    }
}

