/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.perspective.view.j2ee;

import com.tssap.j2ee.core.filters.ws.DtrDeleteActionFilter;
import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.view.IJ2eeView;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.view.IJ2eeResourceFilterProvider;
import com.tssap.j2ee.ui.core.view.J2eeResourceFilter;
import com.tssap.j2ee.ui.perspective.view.ejb.internal.filter.EjbModuleFilter;
import com.tssap.j2ee.ui.perspective.view.ejb.internal.filter.EjbModuleResourceFilter;
import com.tssap.j2ee.ui.perspective.view.j2ee.ContextDependentPathProvider;
import com.tssap.j2ee.ui.perspective.view.j2ee.J2EEViewFilterUtil;
import com.tssap.j2ee.ui.perspective.view.j2ee.J2eeViewSelectionConverter;
import com.tssap.j2ee.ui.perspective.view.j2ee.J2eeViewSorter;
import com.tssap.j2ee.ui.perspective.view.j2ee.internal.J2eeLabelDecorator;
import com.tssap.j2ee.ui.perspective.view.j2ee.internal.J2eeLabelProvider;
import com.tssap.j2ee.ui.perspective.view.j2ee.internal.filter.EARModulesFilter;
import com.tssap.j2ee.ui.perspective.view.j2ee.internal.filter.EARProjectFilter;
import com.tssap.j2ee.ui.perspective.view.j2ee.internal.filter.J2EEViewPFilter;
import com.tssap.j2ee.ui.perspective.view.j2ee.internal.filter.J2eeFadeOutFilter;
import com.tssap.j2ee.ui.perspective.view.j2ee.internal.filter.WebModuleFilter;
import com.tssap.j2ee.ui.perspective.view.j2ee.internal.filter.WebModuleResourceFilter;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.extension.filter.FilterFactory;
import com.tssap.selena.model.extension.filter.IFilter;
import com.tssap.selena.model.extension.filter.IFilterSet;
import com.tssap.selena.model.extension.filter.IMutableFilterSet;
import com.tssap.selena.model.extension.filter.YesManFilter;
import com.tssap.selena.model.extension.filter.persistable.FilterSelectionDialog;
import com.tssap.selena.model.extension.filter.persistable.IFilterEditor;
import com.tssap.selena.model.extension.filter.persistable.IFilterFactory;
import com.tssap.selena.model.extension.filter.persistable.IFilterSelectionCallback;
import com.tssap.selena.model.extension.filter.persistable.IPersistableFilter;
import com.tssap.selena.model.extension.filter.persistable.PersistableFilterFactory;
import com.tssap.selena.model.extension.filter.persistable.PersistableFilterManager;
import com.tssap.selena.model.extension.ui.treeviewer.GenericDataModelFilteredTreeViewer;
import com.tssap.util.UtilPlugin;
import com.tssap.util.action.Category;
import com.tssap.util.action.DefaultActionFilter;
import com.tssap.util.action.IActionContext;
import com.tssap.util.action.IActionFilter;
import com.tssap.util.action.ICategory;
import com.tssap.util.action.IGenericAction;
import com.tssap.util.action.path.IPathProvider;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.IContext;
import com.tssap.util.ui.IContextProvider;
import com.tssap.util.ui.IDescriptionIndicator;
import com.tssap.util.ui.LabelProviderContainer;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.image.SapImage;
import com.tssap.util.ui.image.SapImageRegistry;
import com.tssap.util.ui.menu.IMenuFactory;
import com.tssap.util.ui.menu.MenuFactory;
import com.tssap.util.ui.menu.context.ContextMenu;
import com.tssap.util.ui.menu.context.DynamicContextMenu;
import com.tssap.util.ui.menu.context.IContextMenu;
import com.tssap.util.ui.menu.context.IContextMenuPart;
import com.tssap.util.ui.menu.context.MixedContextMenu;
import com.tssap.util.ui.viewer.IViewerContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractJ2eeView
extends ViewPart
implements IJ2eeView,
IContextProvider {
    private static final boolean CACHING_BUTTON_AVAILABLE = false;
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$perspective$view$j2ee$AbstractJ2eeView == null ? (class$com$tssap$j2ee$ui$perspective$view$j2ee$AbstractJ2eeView = AbstractJ2eeView.class$("com.tssap.j2ee.ui.perspective.view.j2ee.AbstractJ2eeView")) : class$com$tssap$j2ee$ui$perspective$view$j2ee$AbstractJ2eeView));
    private static final int MIN_SUBMENU_ENTRIES = 1;
    private static boolean withComponentProjects = false;
    private static boolean DEFAULT_OPTIMISTIC_CHILDREN_CHECK = true;
    private static boolean DEFAULT_EXPAND_SINGLE_CHILD_AUTOMATICALLY = true;
    protected static String FILTER_NAME_ALL = "All";
    protected static String FILTER_NAME_EJB = "EJB";
    protected static String FILTER_NAME_EJBASSRESOURCE = "ASSEMBLY RESOURCES";
    protected static String FILTER_NAME_EJBMODULERESOURCE = "EJBMODULE RESOURCES";
    protected static String FILTER_NAME_COMPONENT_PROJECT = "Component Projects";
    protected static String FILTER_NAME_EJB_PROJECT = "EJB Projects";
    protected static String FILTER_NAME_EJB_MODULE = "EJB Modules";
    protected static String FILTER_NAME_EAR_PROJECT = "EAR Projects";
    protected static String FILTER_NAME_WEB_PROJECT = "Web Projects";
    protected static String FILTER_NAME_WEB_MODULE = "Web Module";
    protected static String FILTER_NAME_EJB_ASSEMBLY = "EJB Assembly Project";
    protected static String FILTER_NAME_WEBAPPLICATION_PROJECT = "Web Application Project";
    protected static String FILTER_NAME_WEB_RESOURCES = "WebResources";
    protected static String FILTER_NAME_WEBAPPLICATION_RESOURCES = "Web Application Resources";
    protected static String FILTER_NAME_WEBMODULE_RESOURCES = "Web Module Resources";
    protected static String FILTER_NAME_EARMODULES = "EAR Modules";
    private GenericDataModelFilteredTreeViewer treeViewer;
    private SapImageRegistry mImageRegistry = null;
    private IFilterSet staticFilterSet;
    private IFilter[] externalStaticFilterSet = null;
    private IMutableFilterSet mutableFilterSet;
    private IFilterSet mutableProjectDefaultFilterSet;
    private IMutableFilterSet userCustomFilterSet;
    private PersistableFilterManager persistableFilterManager;
    private PersistableFilterFactory persistableFilterFactory;
    private IFilterSelectionCallback myFilterSelectionCallback;
    private IFilter currentUserFilter;
    private static final IFilter[] EMPTY_FILTER_ARRAY = new IFilter[0];
    static /* synthetic */ Class class$com$tssap$j2ee$ui$perspective$view$j2ee$AbstractJ2eeView;

    public AbstractJ2eeView() {
        this.initialize();
    }

    private void initialize() {
        this.mImageRegistry = (SapImageRegistry)UIPlugin.getDefault().getImageRegistry();
    }

    private void initExternalFilterset() {
        IJ2eeResourceFilterProvider[] extJ2eeFilter = UIPlugin.getExternalJ2eeFilterProvider();
        if (extJ2eeFilter != null && extJ2eeFilter.length > 0) {
            ArrayList<J2eeResourceFilter> staticFilterSet = new ArrayList<J2eeResourceFilter>();
            int i = 0;
            while (i < extJ2eeFilter.length) {
                if (extJ2eeFilter[i].getJ2eeProjectFilter() != null) {
                    this.getMutableProjectFilterSet().addFilters((IFilter[])extJ2eeFilter[i].getJ2eeProjectFilter());
                }
                if (extJ2eeFilter[i].getJ2eeResourceFilter() != null) {
                    staticFilterSet.addAll(Arrays.asList(extJ2eeFilter[i].getJ2eeResourceFilter()));
                }
                ++i;
            }
            this.externalStaticFilterSet = new IFilter[staticFilterSet.size()];
            this.externalStaticFilterSet = staticFilterSet.toArray(this.externalStaticFilterSet);
        }
    }

    protected void initFilterSets() {
        this.setUserCustomFilterSet(FilterFactory.createAndFilterSet());
        this.updateUserFilterSet();
        this.setMutableFilterSet(FilterFactory.createOrFilterSet());
        EjbModuleFilter ejbModuleFilter = new EjbModuleFilter();
        ejbModuleFilter.setName(FILTER_NAME_EJB_MODULE);
        this.getMutableProjectFilterSet().addFilter((IFilter)ejbModuleFilter);
        EARProjectFilter earPrjFilter = new EARProjectFilter();
        earPrjFilter.setName(FILTER_NAME_EAR_PROJECT);
        this.getMutableProjectFilterSet().addFilter((IFilter)earPrjFilter);
        WebModuleFilter webModuleFilter = new WebModuleFilter();
        webModuleFilter.setName(FILTER_NAME_WEB_MODULE);
        this.getMutableProjectFilterSet().addFilter((IFilter)webModuleFilter);
        this.initExternalFilterset();
        this.setMutableProjectDefaultFilterSet((IFilterSet)FilterFactory.createOrFilterSet((IFilter[])this.getMutableProjectFilterSet().getFilters()));
        ArrayList<Object> allStaticFilter = new ArrayList<Object>();
        EjbModuleResourceFilter ejbModuleResFilter = new EjbModuleResourceFilter();
        ejbModuleResFilter.setName(FILTER_NAME_EJBMODULERESOURCE);
        allStaticFilter.add((Object)ejbModuleResFilter);
        WebModuleResourceFilter webModuleresourceFilter = new WebModuleResourceFilter();
        webModuleresourceFilter.setName(FILTER_NAME_WEBMODULE_RESOURCES);
        allStaticFilter.add((Object)webModuleresourceFilter);
        EARModulesFilter earmodulesFilter = new EARModulesFilter();
        earmodulesFilter.setName(FILTER_NAME_EARMODULES);
        allStaticFilter.add((Object)earmodulesFilter);
        if (this.externalStaticFilterSet != null) {
            allStaticFilter.addAll(Arrays.asList(this.externalStaticFilterSet));
        }
        this.setStaticFilterSet((IFilterSet)FilterFactory.createOrFilterSet((IFilter[])allStaticFilter.toArray(new IFilter[allStaticFilter.size()])));
    }

    private void updateUserFilterSet() {
        this.getUserCustomFilterSet().removeAllFilters();
        this.getUserCustomFilterSet().addFilter((IFilter)new YesManFilter());
        if (this.currentUserFilter != null) {
            this.getUserCustomFilterSet().addFilter(this.currentUserFilter);
        }
    }

    public void createPartControl(Composite parent) {
        long time = System.currentTimeMillis();
        this.initFilterSets();
        IMutableFilterSet projectFilterSet = FilterFactory.createAndFilterSet();
        projectFilterSet.addFilter((IFilter)this.getUserCustomFilterSet());
        projectFilterSet.addFilter((IFilter)this.getMutableProjectFilterSet());
        projectFilterSet.addFilters(this.getMandatoryProjectFilters());
        IFilter[] excludeProjectFilters = this.getExcludeProjectFilters();
        int i = 0;
        while (i < excludeProjectFilters.length) {
            projectFilterSet.addFilter(FilterFactory.createInvertingFilter((IFilter)excludeProjectFilters[i]));
            ++i;
        }
        IMutableFilterSet m = FilterFactory.createOrFilterSet();
        m.addFilter((IFilter)projectFilterSet);
        m.addFilter((IFilter)this.getStaticFilterSet());
        IMutableFilterSet treeFilterSet = FilterFactory.createAndFilterSet();
        treeFilterSet.addFilter((IFilter)m);
        treeFilterSet.addFilters(this.getMandatoryFilters());
        IFilter[] excludeFilters = this.getExcludeFilters();
        int i2 = 0;
        while (i2 < excludeFilters.length) {
            treeFilterSet.addFilter(FilterFactory.createInvertingFilter((IFilter)excludeFilters[i2]));
            ++i2;
        }
        this.createViewer(parent, treeFilterSet);
        this.createToolBar();
        this.createFilterMenu();
        this.addContextMenu();
        UtilPlugin.getTracer().info("Abstract J2ee view create part control: " + (System.currentTimeMillis() - time) + "ms");
    }

    private void createViewer(Composite parent, IMutableFilterSet treeFilter) {
        IPreferenceStore preferenceStore = UIPlugin.getDefault().getPreferenceStore();
        if (!preferenceStore.contains(this.getOptimisticChildrenCheckStoreKey())) {
            preferenceStore.setDefault(this.getOptimisticChildrenCheckStoreKey(), DEFAULT_OPTIMISTIC_CHILDREN_CHECK);
        }
        boolean optChildCheck = preferenceStore.getBoolean(this.getOptimisticChildrenCheckStoreKey());
        if (!preferenceStore.contains(this.getExpandSingleChildAutomaticallyStoreKey())) {
            preferenceStore.setDefault(this.getExpandSingleChildAutomaticallyStoreKey(), DEFAULT_EXPAND_SINGLE_CHILD_AUTOMATICALLY);
        }
        boolean expandSingleChildAutomatically = preferenceStore.getBoolean(this.getExpandSingleChildAutomaticallyStoreKey());
        GenericDataModelFilteredTreeViewer viewer = GenericDataModelFilteredTreeViewer.createFilteredTreeViewer((Composite)parent, (IFilter)treeFilter);
        LabelProviderContainer lpc = new LabelProviderContainer();
        lpc.addLabelProvider((ILabelProvider)new DecoratingLabelProvider((ILabelProvider)new J2eeLabelProvider(), (ILabelDecorator)new J2eeLabelDecorator()));
        ILabelProvider additionalLabelProvider = this.getAdditionalLabelProvider();
        if (additionalLabelProvider != null) {
            lpc.addLabelProvider(additionalLabelProvider);
        }
        viewer.getTreeViewer().setLabelProvider((IBaseLabelProvider)lpc);
        viewer.setOptimisticChildrenCheck(optChildCheck, false);
        viewer.setExpandSingleChildAutomatically(expandSingleChildAutomatically);
        viewer.getTreeViewer().setSorter((ViewerSorter)new J2eeViewSorter());
        viewer.setDissolveReferences(true, false);
        viewer.setSkipReferenceCollections(false, false);
        viewer.setSkipReferences(true, true);
        this.setTreeViewer(viewer);
        J2eeViewSelectionConverter converter = new J2eeViewSelectionConverter((ISelectionProvider)viewer.getTreeViewer());
        this.getSite().setSelectionProvider((ISelectionProvider)converter);
    }

    abstract ILabelProvider getAdditionalLabelProvider();

    public void setFocus() {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().getTree().setFocus();
        }
    }

    protected GenericDataModelFilteredTreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public TreeViewer getCommonTreeViewer() {
        return this.getTreeViewer().getTreeViewer();
    }

    protected void setTreeViewer(GenericDataModelFilteredTreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    private void createToolBar() {
        final IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        Action refreshAction = new Action(){

            public void run() {
                J2eeProjectManager.clearCache();
                AbstractJ2eeView.this.getTreeViewer().refresh();
            }
        };
        refreshAction.setImageDescriptor(this.mImageRegistry.getImageDescriptor("refresh"));
        refreshAction.setToolTipText("Refresh");
        toolBarManager.add((IAction)refreshAction);
        Action collapseAllAction = new Action(){

            public void run() {
                AbstractJ2eeView.this.getTreeViewer().getTreeViewer().collapseAll();
            }
        };
        collapseAllAction.setImageDescriptor(SapIdeUtilImages.getImageDescriptorFromIconsDirectory((String)UtilPlugin.getPluginId(), (String)"collapseall.gif"));
        collapseAllAction.setToolTipText("Collapse All");
        toolBarManager.add((IAction)collapseAllAction);
        Action toggleOptimisticChildrenCheckAction = new Action(){

            public void run() {
                boolean currentValue = AbstractJ2eeView.this.getTreeViewer().isOptimisticChildrenCheck();
                boolean newValue = !currentValue;
                AbstractJ2eeView.this.getTreeViewer().setOptimisticChildrenCheck(newValue);
                UIPlugin.getDefault().getPreferenceStore().setValue(AbstractJ2eeView.this.getOptimisticChildrenCheckStoreKey(), newValue);
                this.setChecked(currentValue);
                toolBarManager.update(true);
            }

            public boolean isChecked() {
                boolean ret = AbstractJ2eeView.this.getTreeViewer().isOptimisticChildrenCheck();
                return ret;
            }

            public int getStyle() {
                return 2;
            }

            public String getToolTipText() {
                String ret = "Optimistic Children Check";
                return ret;
            }
        };
        toggleOptimisticChildrenCheckAction.setImageDescriptor(SapIdeUtilImages.getSapImageDescriptor((ISapImage)SapImage.ICON_POSITIVE));
        toolBarManager.add((IAction)toggleOptimisticChildrenCheckAction);
        Action toggleExpandSingleChildAutomaticallyAction = new Action(){

            public void run() {
                boolean currentValue = AbstractJ2eeView.this.getTreeViewer().isExpandSingleChildAutomatically();
                boolean newValue = !currentValue;
                AbstractJ2eeView.this.getTreeViewer().setExpandSingleChildAutomatically(newValue);
                UIPlugin.getDefault().getPreferenceStore().setValue(AbstractJ2eeView.this.getExpandSingleChildAutomaticallyStoreKey(), newValue);
                this.setChecked(currentValue);
                toolBarManager.update(true);
            }

            public boolean isChecked() {
                boolean ret = AbstractJ2eeView.this.getTreeViewer().isExpandSingleChildAutomatically();
                return ret;
            }

            public int getStyle() {
                return 2;
            }

            public String getToolTipText() {
                String ret = "Expand Single Child Automatically";
                return ret;
            }
        };
        toggleExpandSingleChildAutomaticallyAction.setImageDescriptor(SapIdeUtilImages.getSapImageDescriptor((ISapImage)SapImage.ICON_NEXT_NODE));
        toolBarManager.add((IAction)toggleExpandSingleChildAutomaticallyAction);
    }

    private void addContextMenu() {
        MenuFactory menuFactory = new MenuFactory();
        menuFactory.getPathProviderManager().addPathProvider((IPathProvider)new ContextDependentPathProvider(true));
        MixedContextMenu contextMenuPartContainer = new MixedContextMenu();
        DynamicContextMenu dynamicContextMenu = new DynamicContextMenu((IMenuFactory)menuFactory, 1, (IActionFilter)new DtrDeleteActionFilter());
        contextMenuPartContainer.addContextMenuPart((IContextMenuPart)dynamicContextMenu);
        ContextMenu.setContextMenuToStructuredViewer((StructuredViewer)this.getTreeViewer().getTreeViewer(), (IContextMenu)contextMenuPartContainer);
        contextMenuPartContainer.addDescriptionIndicator(new IDescriptionIndicator(){

            public void indicateDescription(String descriptionText) {
                AbstractJ2eeView.this.getViewSite().getActionBars().getStatusLineManager().setMessage(descriptionText);
            }
        });
        dynamicContextMenu.registerShortcuts((Control)this.getTreeViewer().getTree(), (IWorkbenchPart)this, (IContextProvider)this);
        dynamicContextMenu.setActionFilter((IActionFilter)new J2EEActionFilter());
    }

    private void createFilterMenu() {
        final IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.removeAll();
        IPersistableFilter[] filters = this.getPersistableFilterManager().getFilters();
        Action[] filterActions = new Action[filters.length];
        int i = 0;
        while (i < filters.length) {
            IPersistableFilter iFilter = filters[i];
            String iFilterName = iFilter.getName();
            Action iFilterAction = new Action((IFilter)iFilter, iFilterName){
                private final /* synthetic */ IFilter val$iFilter;
                {
                    this.val$iFilter = val$iFilter;
                }

                public void run() {
                    AbstractJ2eeView.this.currentUserFilter = this.val$iFilter;
                    AbstractJ2eeView.this.updateUserFilterSet();
                    AbstractJ2eeView.this.createFilterMenu();
                    AbstractJ2eeView.this.getTreeViewer().refresh();
                }

                public boolean isChecked() {
                    boolean ret = false;
                    if (this.val$iFilter == AbstractJ2eeView.this.currentUserFilter) {
                        ret = true;
                    }
                    return ret;
                }
            };
            iFilterAction.setChecked(false);
            filterActions[i] = iFilterAction;
            ++i;
        }
        Action deselectFilter = new Action("Deselect Filter"){

            public void run() {
                AbstractJ2eeView.this.currentUserFilter = null;
                AbstractJ2eeView.this.updateUserFilterSet();
                AbstractJ2eeView.this.createFilterMenu();
                AbstractJ2eeView.this.getTreeViewer().refresh();
            }

            public boolean isEnabled() {
                boolean ret = false;
                if (AbstractJ2eeView.this.currentUserFilter != null) {
                    ret = true;
                }
                return ret;
            }
        };
        menuManager.add((IAction)deselectFilter);
        menuManager.add((IContributionItem)new Separator());
        Action chooseFilter = new Action("Filter..."){

            public void run() {
                IFilter filterBackup = AbstractJ2eeView.this.currentUserFilter;
                AbstractJ2eeView.this.currentUserFilter = null;
                AbstractJ2eeView.this.updateUserFilterSet();
                IFilter filter = FilterSelectionDialog.selectFilter((Shell)AbstractJ2eeView.this.getSite().getShell(), (IFilterSelectionCallback)AbstractJ2eeView.this.getFilterSelectionCallback(), (PersistableFilterManager)AbstractJ2eeView.this.getPersistableFilterManager());
                if (filter != null) {
                    AbstractJ2eeView.this.currentUserFilter = filter;
                    AbstractJ2eeView.this.updateUserFilterSet();
                } else if (filterBackup != null) {
                    AbstractJ2eeView.this.currentUserFilter = (IFilter)AbstractJ2eeView.this.getPersistableFilterManager().getFilter(filterBackup.getName());
                    AbstractJ2eeView.this.updateUserFilterSet();
                }
                AbstractJ2eeView.this.savePersistableFilters();
                AbstractJ2eeView.this.createFilterMenu();
                menuManager.markDirty();
                menuManager.update();
                AbstractJ2eeView.this.getTreeViewer().refresh();
            }
        };
        menuManager.add((IAction)chooseFilter);
        menuManager.add((IContributionItem)new Separator());
        int i2 = 0;
        while (i2 < filterActions.length) {
            menuManager.add((IAction)filterActions[i2]);
            ++i2;
        }
    }

    protected IFilterSelectionCallback getFilterSelectionCallback() {
        if (this.myFilterSelectionCallback == null) {
            this.myFilterSelectionCallback = new J2EEFilterSelectionCallback();
        }
        return this.myFilterSelectionCallback;
    }

    private IFilterSet getTreeFilterSet() {
        IFilterSet ret = null;
        IFilter filter = this.getTreeViewer().getFilter();
        if (filter instanceof IFilterSet) {
            ret = (IFilterSet)filter;
        }
        return ret;
    }

    private void setTreeFilterSet(IMutableFilterSet treeFilter) {
        this.getTreeViewer().setFilter((IFilter)treeFilter);
    }

    protected IMutableFilterSet getUserCustomFilterSet() {
        return this.userCustomFilterSet;
    }

    protected void setUserCustomFilterSet(IMutableFilterSet set) {
        this.userCustomFilterSet = set;
    }

    protected IMutableFilterSet getMutableProjectFilterSet() {
        return this.mutableFilterSet;
    }

    private IFilterSet getStaticFilterSet() {
        return this.staticFilterSet;
    }

    private void setMutableFilterSet(IMutableFilterSet mutableFilterSet) {
        this.mutableFilterSet = mutableFilterSet;
    }

    protected void setStaticFilterSet(IFilterSet staticFilterSet) {
        this.staticFilterSet = staticFilterSet;
    }

    protected IFilterSet getMutableProjectDefaultFilterSet() {
        return this.mutableProjectDefaultFilterSet;
    }

    protected void setMutableProjectDefaultFilterSet(IFilterSet mutableDefaultFilterSet) {
        this.mutableProjectDefaultFilterSet = mutableDefaultFilterSet;
    }

    public IContext getContext() {
        IViewerContext ret = null;
        if (this.getTreeViewer() != null) {
            ret = this.getTreeViewer().getCurrentViewerContext();
        }
        return ret;
    }

    protected IFilter[] getMandatoryFilters() {
        return new IFilter[]{new J2eeFadeOutFilter()};
    }

    protected IFilter[] getMandatoryProjectFilters() {
        return EMPTY_FILTER_ARRAY;
    }

    protected IFilter[] getExcludeFilters() {
        return EMPTY_FILTER_ARRAY;
    }

    protected IFilter[] getExcludeProjectFilters() {
        return EMPTY_FILTER_ARRAY;
    }

    protected abstract String getOptimisticChildrenCheckStoreKey();

    protected abstract String getExpandSingleChildAutomaticallyStoreKey();

    protected abstract String getPersitableFilterStorageFileName();

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento == null) {
            return;
        }
        String currentFilter = memento.getString("currentUserFilter");
        if (currentFilter != null) {
            IPersistableFilter[] filter = this.getPersistableFilterManager().getFilters();
            int i = 0;
            while (i < filter.length && this.currentUserFilter == null) {
                if (currentFilter.equals(filter[i].getName())) {
                    this.currentUserFilter = filter[i];
                }
                ++i;
            }
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.currentUserFilter != null) {
            memento.putString("currentUserFilter", this.currentUserFilter.getName());
        }
    }

    private void initPersistableFilters() {
        PersistableFilterFactory.registerFilterFactory((IFilterFactory)J2EEViewFilterUtil.getJ2EEViewFilterFactory());
        File storageFile = this.getPersitableFilterStorageFile();
        this.persistableFilterManager = new PersistableFilterManager();
        this.persistableFilterFactory = new PersistableFilterFactory();
        if (storageFile.exists()) {
            try {
                FileReader r = new FileReader(storageFile);
                XMLMemento memento = XMLMemento.createReadRoot((Reader)r);
                this.persistableFilterManager.restoreState((IMemento)memento);
            }
            catch (FileNotFoundException e) {
                tracer.error("Unable to restore custom filters", (Throwable)e);
            }
            catch (WorkbenchException e) {
                tracer.error("Unable to restore custom filters", (Throwable)e);
            }
        }
    }

    private void savePersistableFilters() {
        File storageFile = this.getPersitableFilterStorageFile();
        try {
            FileWriter w = new FileWriter(storageFile);
            XMLMemento memento = XMLMemento.createWriteRoot((String)"J2eeViewCustomFilters");
            this.getPersistableFilterManager().saveState((IMemento)memento);
            memento.save((Writer)w);
        }
        catch (IOException e) {
            tracer.error("", (Throwable)e);
        }
    }

    private File getPersitableFilterStorageFile() {
        IPath path = UIPlugin.getDefault().getStateLocation();
        path = path.append(this.getPersitableFilterStorageFileName());
        return path.toFile();
    }

    private PersistableFilterManager getPersistableFilterManager() {
        if (this.persistableFilterManager == null) {
            this.initPersistableFilters();
        }
        return this.persistableFilterManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class J2EEActionFilter
    extends DefaultActionFilter {
        public boolean isAvailable(IGenericAction action, IActionContext actionContext) {
            Element element;
            Object object;
            boolean ret = super.isAvailable(action, actionContext);
            ICategory category = action.getCategory();
            if (Category.DELETE.equals(category) && actionContext.getContextObjectCount() > 0 && (object = actionContext.getContextObjects()[0]) != null && object instanceof Element && (J2eeElementManager.isJ2eeSourceFolder((Element)(element = (Element)object)) || J2eeElementManager.isEjbField((Element)element) || J2eeElementManager.isEjbMethod((Element)element) || J2eeElementManager.isMETAINFFolder((Element)element) || J2eeElementManager.isEjbRelation((Element)element))) {
                ret = false;
            }
            return ret;
        }
    }

    public class J2EEFilterSelectionCallback
    implements IFilterSelectionCallback,
    IFilterEditor {
        J2EEFilterSelectionCallback() {
            AbstractJ2eeView.this.persistableFilterFactory.registerFilterEditor((IFilterEditor)this);
        }

        public IPersistableFilter createNewFilter() {
            J2EEViewPFilter ret = new J2EEViewPFilter(new String[0], new String[0], false, 0);
            ret.setName("New Filter");
            return ret;
        }

        public void editFilter(String[] reservedNames, IPersistableFilter filter) {
            AbstractJ2eeView.this.persistableFilterFactory.editFilter(AbstractJ2eeView.this.getSite().getShell(), reservedNames, filter);
        }

        public boolean isApplicable(IPersistableFilter filter) {
            return filter instanceof J2EEViewPFilter && "J2EE_Prj_NamePFilter".equals(filter.getType());
        }

        public void edit(Shell shell, String[] reservedNames, IPersistableFilter filter) {
            if (filter instanceof J2EEViewPFilter) {
                J2EEViewPFilter j2eeFilter = (J2EEViewPFilter)filter;
                Enumeration modelEnum = ModelAccess.models();
                IFilter userFilter = AbstractJ2eeView.this.currentUserFilter;
                AbstractJ2eeView.this.currentUserFilter = null;
                AbstractJ2eeView.this.updateUserFilterSet();
                IFilterSet viewFilter = AbstractJ2eeView.this.getTreeFilterSet();
                ArrayList<Model> j2eeViewModels = new ArrayList<Model>();
                while (modelEnum.hasMoreElements()) {
                    Model model = (Model)modelEnum.nextElement();
                    if (!viewFilter.isAvailable((PropertyMap)model)) continue;
                    j2eeViewModels.add(model);
                }
                AbstractJ2eeView.this.currentUserFilter = userFilter;
                AbstractJ2eeView.this.updateUserFilterSet();
                J2EEViewFilterUtil.J2EEFilterEditDialog diag = J2EEViewFilterUtil.getJ2EEFilterEditDialog(shell, j2eeViewModels.toArray(new Model[j2eeViewModels.size()]), reservedNames, j2eeFilter);
                diag.open();
            }
        }
    }

    private class DefaultFilterAction
    extends Action {
        Action[] otherActions = null;

        public DefaultFilterAction(String text, Action[] otherActions) {
            super(text);
            this.setOtherActions(otherActions);
        }

        public void run() {
            int i = 0;
            while (i < AbstractJ2eeView.this.getMutableProjectDefaultFilterSet().getFilters().length) {
                IFilter filter = AbstractJ2eeView.this.getMutableProjectDefaultFilterSet().getFilters()[i];
                if (!AbstractJ2eeView.this.getMutableProjectFilterSet().contains(filter)) {
                    AbstractJ2eeView.this.getMutableProjectFilterSet().addFilter(filter);
                }
                ++i;
            }
            IMenuManager menuManager = AbstractJ2eeView.this.getViewSite().getActionBars().getMenuManager();
            menuManager.markDirty();
            menuManager.update();
            AbstractJ2eeView.this.getTreeViewer().refresh();
        }

        public boolean isEnabled() {
            boolean ret = false;
            int i = 0;
            while (i < this.getOtherActions().length && !ret) {
                Action oneOtherAction = this.getOtherActions()[i];
                if (!oneOtherAction.isChecked()) {
                    ret = true;
                }
                ++i;
            }
            return ret;
        }

        private Action[] getOtherActions() {
            return this.otherActions;
        }

        private void setOtherActions(Action[] otherActions) {
            this.otherActions = otherActions;
        }
    }
}

