/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.perspective.view.ejb.internal;

import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.model.ejb.IBusinessMethod;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.model.ejb.IEntityBean;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.view.GenericJ2eeLabelProvider;
import com.tssap.j2ee.ui.ejb.util.EjbUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Reference;
import com.tssap.util.ui.ITooltipProvider;
import org.eclipse.swt.graphics.Image;

public class EjbLabelProvider
extends GenericJ2eeLabelProvider
implements ITooltipProvider {
    public Image getImage(Object element) {
        if (element instanceof Element) {
            Element elem = (Element)element;
            if (J2eeElementManager.isEjbModule((Element)elem)) {
                if (J2eeElementManager.isComponentProject((Element)elem)) {
                    return this.getImageRegistry().get("ejbAssemblyComponentProject");
                }
                return this.getImageRegistry().get("ejbAssemblyProject");
            }
            if (J2eeElementManager.isEjbJarArchive((Element)elem)) {
                return this.getImageRegistry().get("ejbJar");
            }
            if (J2eeElementManager.isEjbModule((Element)elem.getModel())) {
                if (J2eeElementManager.isBeanRegistry((Element)elem)) {
                    return this.getImageRegistry().get("beanRegistry");
                }
                if (J2eeElementManager.isEnterpriseJavaBean((Element)elem)) {
                    return this.getEjbImage(elem);
                }
                if (J2eeElementManager.isEjbMethod((Element)elem)) {
                    return this.getMethodImage(elem);
                }
                if (J2eeElementManager.isEjbField((Element)elem)) {
                    if (J2eeElementManager.isPersistentField((Element)elem) && !J2eeElementManager.isBMPAttribute((Element)elem)) {
                        if (J2eeElementManager.getPersistentField((Element)elem).isPKField()) {
                            return this.getImageRegistry().get("primaryKey");
                        }
                        if (J2eeElementManager.getPersistentField((Element)elem).isCMRField()) {
                            return this.getImageRegistry().get("Ejb Relationship Link");
                        }
                        return this.getImageRegistry().get("persistentField");
                    }
                    return this.getImageRegistry().get("defaultField");
                }
                if (J2eeElementManager.isJavaFile((Element)elem)) {
                    return this.getImageRegistry().get("JavaFile");
                }
                if (J2eeElementManager.isJavaSrcFolder((Element)elem)) {
                    return this.getImageRegistry().get("JavaSourceFolder");
                }
                if (J2eeElementManager.isPackageFragmentFolder((Element)elem)) {
                    return this.getImageRegistry().get("JavaPackage");
                }
                if (J2eeElementManager.isEjbRelation((Element)elem)) {
                    return this.getImageRegistry().get("Ejb Relationship Link");
                }
                return this.getImageForFilesAndFolders(elem);
            }
            return null;
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        return super.getText(element);
    }

    protected Image getMethodImage(Element elem) {
        if (J2eeElementManager.isBusinessMethod((Element)elem)) {
            Entity parent = elem instanceof Reference ? ((Reference)elem).getEntity().getParent() : elem.getParent();
            IEnterpriseJavaBean ejb = J2eeElementManager.getEnterpriseJavaBean((Element)parent);
            if (ejb.getEjbType() == 2) {
                return this.getImageRegistry().get("businessMethod");
            }
            IBusinessMethod method = J2eeElementManager.getBusinessMethod((Element)elem);
            boolean local = method.isLocalExposed();
            boolean remote = method.isRemoteExposed();
            if (ejb.getEjbType() == 0) {
                if (J2eeElementManager.isCMRFieldAccessor((Element)elem)) {
                    return this.getImageRegistry().get("Ejb Relationship Link");
                }
                if (J2eeElementManager.isPersistentFieldAccessor((Element)elem)) {
                    if (EjbUtil.isPKFieldAccessor((IBusinessMethod)method, (IEntityBean)((IEntityBean)ejb))) {
                        return this.getImageRegistry().get("primaryKey");
                    }
                    if (local && remote) {
                        return this.getImageRegistry().get("persFieldLocalremotePropagated");
                    }
                    if (local) {
                        return this.getImageRegistry().get("persFieldLocalPropagated");
                    }
                    if (remote) {
                        return this.getImageRegistry().get("persFieldRemotePropagated");
                    }
                    return this.getImageRegistry().get("persistentField");
                }
            }
            if (local && remote) {
                return this.getImageRegistry().get("localremotePropagated");
            }
            if (local) {
                return this.getImageRegistry().get("localPropagated");
            }
            if (remote) {
                return this.getImageRegistry().get("remotePropagated");
            }
            return this.getImageRegistry().get("businessMethod");
        }
        if (J2eeElementManager.isCreateMethod((Element)elem)) {
            if (J2eeElementManager.getCreateMethod((Element)elem).getName().indexOf("ByPrimaryKey") >= 0) {
                return this.getImageRegistry().get("createbyPKMethod");
            }
            return this.getImageRegistry().get("createMethod");
        }
        if (J2eeElementManager.isFinderMethod((Element)elem)) {
            if (J2eeElementManager.getFinderMethod((Element)elem).getName().indexOf("ByPrimaryKey") >= 0) {
                return this.getImageRegistry().get("finderbyPKMethod");
            }
            return this.getImageRegistry().get("finderMethod");
        }
        if (J2eeElementManager.isHomeMethod((Element)elem)) {
            return this.getImageRegistry().get("homeMethod");
        }
        if (J2eeElementManager.isSelectMethod((Element)elem)) {
            return this.getImageRegistry().get("selectMethod");
        }
        return this.getImageRegistry().get("defaultMethod");
    }

    protected Image getEjbImage(Element elem) {
        int type = J2eeElementManager.getEnterpriseJavaBean((Element)elem).getEjbType();
        if (type == 0) {
            return this.getImageRegistry().get("entityBean");
        }
        if (type == 1) {
            return this.getImageRegistry().get("sessionBean");
        }
        if (type == 2) {
            return this.getImageRegistry().get("messagedrivenBean");
        }
        return null;
    }

    protected Image getImageForFilesAndFolders(Element elem) {
        if (J2eeElementManager.isResourceFile((Element)elem)) {
            String name = elem.getUniqueName().getName();
            Image img = UIPlugin.getImageFromOS((String)name.substring(name.lastIndexOf(".") + 1));
            if (img != null) {
                return img;
            }
            if (J2eeElementManager.isImageResourceFile((Element)elem)) {
                if (J2eeElementManager.isJPEGImageResourceFile((Element)elem)) {
                    return this.getImageRegistry().get("imageJPEG");
                }
                if (J2eeElementManager.isTIFFResourceFile((Element)elem)) {
                    return this.getImageRegistry().get("imageTIFF");
                }
                if (J2eeElementManager.isGIFImageResourceFile((Element)elem)) {
                    return this.getImageRegistry().get("imageGif");
                }
                return this.getImageRegistry().get("imageResource");
            }
            return this.getImageRegistry().get("resource");
        }
        if (J2eeElementManager.isFolder((Element)elem)) {
            return this.getImageRegistry().get("Folder");
        }
        return null;
    }

    public String getTooltipText(Object element) {
        Element elem;
        if (element instanceof Element && J2eeElementManager.isEjbModule((Element)(elem = (Element)element).getModel()) && J2eeElementManager.isEnterpriseJavaBean((Element)elem) && J2eeElementManager.isReferencedEjb((Element)elem)) {
            return J2eeElementManager.getEnterpriseJavaBean((Element)elem).getDefaultEjbName();
        }
        return null;
    }
}

