/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.perspective.view.ejb;

import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.perspective.view.ejb.internal.EjbLabelProvider;
import com.tssap.j2ee.ui.perspective.view.ejb.internal.filter.EJBProjectFilter;
import com.tssap.j2ee.ui.perspective.view.ejb.internal.filter.EjbFilter;
import com.tssap.selena.model.extension.diagnostic.ModelDiagnostic;
import com.tssap.selena.model.extension.filter.FilterFactory;
import com.tssap.selena.model.extension.filter.IFilter;
import com.tssap.selena.model.extension.filter.IMutableFilterSet;
import com.tssap.selena.model.extension.ui.treeviewer.GenericDataModelFilteredTreeViewer;
import com.tssap.util.action.path.ContextDependentPathProvider;
import com.tssap.util.action.path.IPathProvider;
import com.tssap.util.ui.image.SapImageRegistry;
import com.tssap.util.ui.menu.IMenuFactory;
import com.tssap.util.ui.menu.MenuFactory;
import com.tssap.util.ui.menu.context.ContextMenu;
import com.tssap.util.ui.menu.context.DynamicContextMenu;
import com.tssap.util.ui.menu.context.IContextMenu;
import org.eclipse.jdt.ui.actions.MemberFilterActionGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.framelist.BackAction;
import org.eclipse.ui.views.framelist.ForwardAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.GoIntoAction;
import org.eclipse.ui.views.framelist.IFrameSource;
import org.eclipse.ui.views.framelist.TreeViewerFrameSource;
import org.eclipse.ui.views.framelist.UpAction;

public class EjbView
extends ViewPart {
    protected static String FILTER_NAME_ALL = "All";
    protected static String FILTER_NAME_NOTHING = "Nothing";
    protected static String FILTER_NAME_PROFOFI = "Projects, Folders and Files";
    protected static String FILTER_NAME_PROFO = "Projects and Folders";
    protected static String FILTER_NAME_FO = "Folders only";
    protected static String FILTER_NAME_FI = "Files only";
    private GenericDataModelFilteredTreeViewer treeViewer;
    private IMutableFilterSet ejbViewFilterSet = null;
    private IFilter ejbFilter = null;
    private SapImageRegistry mImageRegistry = null;

    public EjbView() {
        this.initFilterManager();
        this.mImageRegistry = (SapImageRegistry)UIPlugin.getDefault().getImageRegistry();
    }

    private void initFilterManager() {
        EJBProjectFilter ejbPrjFilter = new EJBProjectFilter();
        this.ejbFilter = new EjbFilter();
        this.ejbViewFilterSet = FilterFactory.createOrFilterSet();
        this.ejbViewFilterSet.addFilter((IFilter)ejbPrjFilter);
        this.ejbViewFilterSet.addFilter(this.ejbFilter);
        this.ejbViewFilterSet.setName("FirstTest");
    }

    public void createPartControl(Composite parent) {
        GenericDataModelFilteredTreeViewer viewer = GenericDataModelFilteredTreeViewer.createFilteredTreeViewer((Composite)parent);
        viewer.getTreeViewer().setLabelProvider((IBaseLabelProvider)new EjbLabelProvider());
        viewer.setOptimisticChildrenCheck(true, false);
        viewer.setFilter((IFilter)this.ejbViewFilterSet, false);
        viewer.setDissolveReferences(true, false);
        viewer.setSkipReferenceCollections(true, false);
        viewer.setSkipReferences(true, true);
        this.setTreeViewer(viewer);
        this.createToolBar();
        this.addContextMenu(viewer.getTreeViewer());
    }

    public void setFocus() {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().getTree().setFocus();
        }
    }

    protected GenericDataModelFilteredTreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected void setTreeViewer(GenericDataModelFilteredTreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    private void createToolBar() {
        TreeViewer strViewer = this.getTreeViewer().getTreeViewer();
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        Action refreshAction = new Action(){

            public void run() {
                EjbView.this.getTreeViewer().refresh();
                ModelDiagnostic.dumpModelsAndRegisteredProviders();
            }
        };
        refreshAction.setImageDescriptor(this.mImageRegistry.getImageDescriptor("refresh"));
        refreshAction.setToolTipText("Refresh tree");
        toolBarManager.add((IAction)refreshAction);
        TreeViewerFrameSource frameSource = new TreeViewerFrameSource((AbstractTreeViewer)strViewer);
        FrameList frameList = new FrameList((IFrameSource)frameSource);
        frameSource.connectTo(frameList);
        GoIntoAction zoomInAction = new GoIntoAction(frameList);
        zoomInAction.setImageDescriptor(this.mImageRegistry.getImageDescriptor("showchild"));
        BackAction backAction = new BackAction(frameList);
        ForwardAction forwardAction = new ForwardAction(frameList);
        UpAction upAction = new UpAction(frameList);
        toolBarManager.add((IAction)zoomInAction);
        toolBarManager.add((IAction)backAction);
        toolBarManager.add((IAction)forwardAction);
        toolBarManager.add((IAction)upAction);
        MemberFilterActionGroup mfaGroup = new MemberFilterActionGroup((StructuredViewer)strViewer, UIPlugin.ID_EJB_VIEW);
        toolBarManager.add((IContributionItem)new Separator());
        mfaGroup.contributeToToolBar(toolBarManager);
    }

    private void addContextMenu(TreeViewer viewer) {
        MenuFactory menuFactory = new MenuFactory();
        menuFactory.getPathProviderManager().addPathProvider((IPathProvider)new ContextDependentPathProvider(false));
        DynamicContextMenu contextMenu = new DynamicContextMenu((IMenuFactory)menuFactory);
        ContextMenu.setContextMenuToStructuredViewer((StructuredViewer)viewer, (IContextMenu)contextMenu);
    }
}

