/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.perspective.core.action.web;

import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.web.IClientSource;
import com.tssap.j2ee.model.web.IWebModule;
import com.tssap.j2ee.ui.dialog.AbstractInputDialog;
import com.tssap.j2ee.ui.dialog.J2eeElementInputValidator;
import com.tssap.j2ee.ui.perspective.core.action.AbstractRenameElementAction;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractRenameWebSourceAction
extends AbstractRenameElementAction {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$perspective$core$action$web$AbstractRenameWebSourceAction == null ? (class$com$tssap$j2ee$ui$perspective$core$action$web$AbstractRenameWebSourceAction = AbstractRenameWebSourceAction.class$("com.tssap.j2ee.ui.perspective.core.action.web.AbstractRenameWebSourceAction")) : class$com$tssap$j2ee$ui$perspective$core$action$web$AbstractRenameWebSourceAction));
    protected String NAME = "Rename WebSource";
    static /* synthetic */ Class class$com$tssap$j2ee$ui$perspective$core$action$web$AbstractRenameWebSourceAction;

    public boolean isAvailable(Element element) {
        if (J2eeElementManager.isWebModule((Element)element.getModel())) {
            if (J2eeElementManager.isWebClientSource((Element)element) && !J2eeElementManager.isHtmlFile((Element)element)) {
                return true;
            }
            if (J2eeElementManager.isWebServerSource((Element)element)) {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class WebSourceInputValidator
    extends J2eeElementInputValidator {
        public WebSourceInputValidator(String formerName, String projectName, IPackageFragment packageFragment) {
            super(formerName, projectName, packageFragment);
        }

        public String isValid(String newText) {
            IStatus nameStatus = JavaConventions.validateIdentifier((String)newText);
            if (!newText.equals(this.getFormerName()) && nameStatus.isOK()) {
                IType type;
                StringBuffer name = new StringBuffer();
                if (this.getPackageFragment() != null) {
                    name.append(this.getPackageFragment().getElementName());
                }
                IWebModule webMod = J2eeProjectManager.getWebModule((String)this.getJ2eeProjectName());
                try {
                    type = webMod.getJavaProject().findType(name.toString());
                }
                catch (JavaModelException e) {
                    tracer.error("", (Throwable)e);
                    type = null;
                }
                if (type == null || !type.exists() || !(type instanceof ICompilationUnit)) {
                    try {
                        IClientSource cFile = webMod.getClientSource(name.toString());
                        if (cFile == null || cFile.getFile() == null || !cFile.getFile().exists()) {
                            return null;
                        }
                    }
                    catch (Exception e1) {
                        tracer.error("", (Throwable)e1);
                        return null;
                    }
                }
                return "file already exists";
            }
            if (nameStatus.isOK()) {
                return null;
            }
            return nameStatus.getMessage();
        }
    }

    protected static class RenameWebObjectDialog
    extends AbstractInputDialog {
        public RenameWebObjectDialog(Shell parentShell, String dialogTitle, String dialogMessage, String formerName, String projectName, IPackageFragment pkg) {
            super(parentShell, dialogTitle, dialogMessage, formerName, (IInputValidator)new WebSourceInputValidator(formerName, projectName, pkg));
        }

        protected IGridLayoutPane createMainGridLayoutPane(Composite parent) {
            IGridLayoutPane layout = PaneFactory.createGridLayoutPane((Composite)parent, (int)1);
            return layout;
        }

        protected void okButtonPressed() {
        }
    }
}

