/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.perspective.core.action.project;

import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.model.web.IWebModule;
import com.tssap.j2ee.ui.wizard.J2eeWizardDialog;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.ui.wizards.NewPackageCreationWizard;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.NewPackageWizardPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class CreatePackageAction
implements IElementSingleAction {
    private static final String DESCRIPTION = "Create a new Package";
    private static final String NAME = "Package...";
    private static final String INFO = "Create a new Package";
    private static final int SIZING_WIZARD_WIDTH = 500;
    private static final int SIZING_WIZARD_HEIGHT = 500;
    private static final ICategory CATEGORY = Category.createDisplayableCategory((ICategory)Category.NEW, (String)"Create a new Package", (String)"Package...", (String)"Create a new Package", (Image)JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif"), (boolean)false, (int)30);

    public boolean isEnabled(Element element) {
        return true;
    }

    public boolean isAvailable(Element element) {
        return J2eeElementManager.isEjbModule((Element)element) || J2eeElementManager.isWebModule((Element)element) || J2eeElementManager.isPackageFragmentFolder((Element)element);
    }

    public void run(Element element) {
        Model model;
        NewPackageCreationWizard pkgWizard = new NewPackageCreationWizard();
        IWorkbench workbench = PlatformUI.getWorkbench();
        String initPackageName = "";
        if (element instanceof Model) {
            model = (Model)element;
        } else {
            model = element.getModel();
            IPackageFragment packFragment = J2eeElementManager.getPackageFragment((Element)element);
            if (packFragment != null) {
                initPackageName = packFragment.getElementName();
            }
        }
        StructuredSelection structuredSelection = new StructuredSelection((Object)this.getProject(model));
        pkgWizard.init(workbench, (IStructuredSelection)structuredSelection);
        IDialogSettings workbenchSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = workbenchSettings.getSection("CreatePackageWizardAction");
        if (wizardSettings == null) {
            wizardSettings = workbenchSettings.addNewSection("CreatePackageWizardAction");
        }
        pkgWizard.setDialogSettings(wizardSettings);
        pkgWizard.setForcePreviousAndNextButtons(true);
        Shell parent = workbench.getActiveWorkbenchWindow().getShell();
        J2eeWizardDialog dialog = new J2eeWizardDialog(parent, (Wizard)pkgWizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);
        WorkbenchHelp.setHelp((Control)dialog.getShell(), (String)"org.eclipse.ui.new_wizard_context");
        IWizardPage[] pages = pkgWizard.getPages();
        int i = 0;
        while (i < pages.length) {
            IWizardPage page = pages[i];
            if (page instanceof NewPackageWizardPage) {
                NewPackageWizardPage packageWizardPage = (NewPackageWizardPage)page;
                packageWizardPage.setPackageText(initPackageName, true);
            }
            ++i;
        }
        dialog.open();
    }

    public ICategory getCategory() {
        return CATEGORY;
    }

    private IProject getProject(Model model) {
        IWebModule prj = null;
        if (J2eeElementManager.isWebModule((Element)model)) {
            prj = J2eeElementManager.getWebModule((Element)model);
        } else if (J2eeElementManager.isEjbModule((Element)model)) {
            prj = J2eeElementManager.getEjbModule((Element)model);
        } else {
            return null;
        }
        return prj.getProject();
    }
}

