/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.perspective.core.action.project;

import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.web.IWebModule;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.archive.BuildWar;
import com.tssap.j2ee.ui.core.archive.WARGenerationException;
import com.tssap.j2ee.ui.perspective.core.action.project.AbstractBuildArchiveAction;
import com.tssap.selena.model.elements.Element;
import com.tssap.tools.archive.IWarDescriptor;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class BuildWarAction
extends AbstractBuildArchiveAction {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$perspective$core$action$project$BuildWarAction == null ? (class$com$tssap$j2ee$ui$perspective$core$action$project$BuildWarAction = BuildWarAction.class$("com.tssap.j2ee.ui.perspective.core.action.project.BuildWarAction")) : class$com$tssap$j2ee$ui$perspective$core$action$project$BuildWarAction));
    private final String DISPLAYNAME = "Build WEB Archive";
    private final String DESCRIPTION = "Build WEB Archive";
    private final String DISPLAYINFO = "Build a Web Archive File";
    private final Image DISPLAYIMAGE = UIPlugin.getImage((String)"add");
    private ICategory category = Category.createDisplayableCategory((ICategory)AbstractBuildArchiveAction.getParentCategory(), (String)"Build WEB Archive", (String)"Build WEB Archive", (String)"Build a Web Archive File", (Image)this.DISPLAYIMAGE);
    private IWebModule webModule = null;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$perspective$core$action$project$BuildWarAction;

    public boolean isAvailable(Element element) {
        IWebModule p;
        return J2eeElementManager.isWebModule((Element)element) && (p = J2eeElementManager.getWebModule((Element)element)) != null && !J2eeProjectManager.isComponentProject((IJ2eeProject)p);
    }

    public boolean isEnabled(Element element) {
        IWebModule p;
        return this.isAvailable(element) && (p = J2eeElementManager.getWebModule((Element)element)) != null && p.hasValidDescriptor();
    }

    public void run(Element element) {
        boolean isError = false;
        String warning = "";
        this.webModule = J2eeElementManager.getWebModule((Element)element);
        IResource res = this.webModule.getJavaProject().getResource();
        isError = this.isResourceErroneous(res);
        if (isError) {
            warning = "\n WARNING: The generated WAR contains class files containing syntax errors!";
            boolean answer = MessageDialog.openQuestion((Shell)UIPlugin.getShell(), (String)"Warning", (String)("The project " + this.webModule.getName() + " contains errors. Do you want to proceed anyway?"));
            if (!answer) {
                return;
            }
            tracer.warning("The project " + this.webModule.getName() + " contain errors. ");
        }
        IWarDescriptor warDescriptor = null;
        try {
            warDescriptor = BuildWar.build((IWebModule)this.webModule, (boolean)false, (String)this.webModule.getArchiveLocation(), (String)this.webModule.getArchiveName());
        }
        catch (WARGenerationException e) {
            MessageDialog.openError((Shell)UIPlugin.getShell(), (String)"War Generation failed", (String)("reason: " + e.getMessage()));
            tracer.error("", (Throwable)e);
        }
        if (warDescriptor != null) {
            if (warning.equals("")) {
                MessageDialog.openInformation((Shell)UIPlugin.getShell(), (String)"WAR Generation", (String)"WAR generation has finished successfully.");
            } else {
                MessageDialog.openWarning((Shell)UIPlugin.getShell(), (String)"WAR Generation", (String)("WAR generation has finished successfully." + warning));
            }
        }
    }

    private boolean isResourceErroneous(IResource res) {
        boolean result = false;
        try {
            IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            if (markers != null && markers.length > 0) {
                int i = 0;
                while (i < markers.length) {
                    if (markers[i].getAttribute("severity", 0) == 2) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException ce) {
            tracer.error("The creation of WEB module " + this.webModule.getName() + " is not possible. Reason :", (Throwable)ce);
        }
        return result;
    }

    public ICategory getCategory() {
        return this.category;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

