/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.perspective.core.action.project;

import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.model.ejb.IEjbModule;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.archive.BuildEjbJar;
import com.tssap.j2ee.ui.core.archive.EjbJarGenerationException;
import com.tssap.j2ee.ui.perspective.core.action.project.AbstractBuildArchiveAction;
import com.tssap.selena.model.elements.Element;
import com.tssap.tools.archive.IEjbJarDescriptor;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class BuildEjbJarAction
extends AbstractBuildArchiveAction {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$perspective$core$action$project$BuildEjbJarAction == null ? (class$com$tssap$j2ee$ui$perspective$core$action$project$BuildEjbJarAction = BuildEjbJarAction.class$("com.tssap.j2ee.ui.perspective.core.action.project.BuildEjbJarAction")) : class$com$tssap$j2ee$ui$perspective$core$action$project$BuildEjbJarAction));
    private final String DISPLAYNAME = "Build EJB Archive";
    private final String DESCRIPTION = "Build EJB Archive";
    private final String DISPLAYINFO = "Build an EJB JAR file";
    private final Image DISPLAYIMAGE = UIPlugin.getImage((String)"add");
    private ICategory category = Category.createDisplayableCategory((ICategory)AbstractBuildArchiveAction.getParentCategory(), (String)"Build EJB Archive", (String)"Build EJB Archive", (String)"Build an EJB JAR file", (Image)this.DISPLAYIMAGE);
    private IEjbModule ejbModule = null;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$perspective$core$action$project$BuildEjbJarAction;

    public boolean isAvailable(Element element) {
        return J2eeElementManager.isEjbModule((Element)element) && !J2eeElementManager.isComponentProject((Element)element);
    }

    public boolean isEnabled(Element element) {
        IEjbModule p;
        return this.isAvailable(element) && (p = J2eeElementManager.getEjbModule((Element)element)) != null && p.hasValidDescriptor() && p.hasReferencedEjbs();
    }

    public void run(Element element) {
        boolean isError = false;
        String warning = "";
        this.ejbModule = J2eeElementManager.getEjbModule((Element)element);
        IResource res = this.ejbModule.getJavaProject().getResource();
        isError = this.isResourceErroneous(res);
        if (isError) {
            warning = "\n WARNING: The generated EJB JAR contains class files containing syntax errors!";
            boolean answer = MessageDialog.openQuestion((Shell)UIPlugin.getShell(), (String)"Warning", (String)("The project " + this.ejbModule.getName() + " contains errors. Do you want to proceed anyway?"));
            if (!answer) {
                return;
            }
            tracer.warning("The project " + this.ejbModule.getName() + " contain errors. ");
        }
        IEjbJarDescriptor ejbJarDescriptor = null;
        try {
            ejbJarDescriptor = BuildEjbJar.build((IEjbModule)this.ejbModule, (boolean)false, (String)this.ejbModule.getArchiveLocation(), (String)this.ejbModule.getArchiveName());
        }
        catch (EjbJarGenerationException e) {
            MessageDialog.openError((Shell)UIPlugin.getShell(), (String)"EJB JAR Generation failed", (String)("reason: " + e.getMessage()));
            tracer.error("", (Throwable)e);
        }
        if (ejbJarDescriptor != null) {
            if (warning.equals("")) {
                MessageDialog.openInformation((Shell)UIPlugin.getShell(), (String)"EJB JAR", (String)"EJB JAR generation has finished successfully.");
            } else {
                MessageDialog.openWarning((Shell)UIPlugin.getShell(), (String)"EJB JAR", (String)("EJB JAR generation has finished successfully." + warning));
            }
        }
    }

    private boolean isResourceErroneous(IResource res) {
        boolean result = false;
        try {
            IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            if (markers != null && markers.length > 0) {
                int i = 0;
                while (i < markers.length) {
                    if (markers[i].getAttribute("severity", 0) == 2) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException ce) {
            tracer.error("The creation of EJB module " + this.ejbModule.getName() + " is not possible. Reason :", (Throwable)ce);
        }
        return result;
    }

    public ICategory getCategory() {
        return this.category;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

