/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.perspective.core.action.project;

import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ear.IEarProject;
import com.tssap.j2ee.model.ejb.IEjbModule;
import com.tssap.j2ee.model.web.IWebModule;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.archive.BuildEar;
import com.tssap.j2ee.ui.core.archive.EARGenerationException;
import com.tssap.j2ee.ui.perspective.core.action.project.AbstractBuildArchiveAction;
import com.tssap.selena.model.elements.Element;
import com.tssap.tools.archive.IEarDescriptor;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class BuildEarAction
extends AbstractBuildArchiveAction {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$perspective$core$action$project$BuildEarAction == null ? (class$com$tssap$j2ee$ui$perspective$core$action$project$BuildEarAction = BuildEarAction.class$("com.tssap.j2ee.ui.perspective.core.action.project.BuildEarAction")) : class$com$tssap$j2ee$ui$perspective$core$action$project$BuildEarAction));
    private final String DISPLAYNAME = "Build Application Archive";
    private final String DESCRIPTION = "Build Application Archive";
    private final String DISPLAYINFO = "Build an Enterprise archive file";
    private final Image DISPLAYIMAGE = UIPlugin.getImage((String)"add");
    private ICategory category = Category.createDisplayableCategory((ICategory)AbstractBuildArchiveAction.getParentCategory(), (String)"Build Application Archive", (String)"Build Application Archive", (String)"Build an Enterprise archive file", (Image)this.DISPLAYIMAGE);
    private IEarProject earPrj = null;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$perspective$core$action$project$BuildEarAction;

    public boolean isAvailable(Element element) {
        IEarProject p;
        return J2eeElementManager.isEarProject((Element)element) && (p = J2eeElementManager.getEarProject((Element)element)) != null && !J2eeProjectManager.isComponentProject((IJ2eeProject)p);
    }

    public boolean isEnabled(Element element) {
        IEarProject p;
        return this.isAvailable(element) && (p = J2eeElementManager.getEarProject((Element)element)) != null && this.hasValidDescriptor(p) && p.hasReferencedModules();
    }

    public void run(Element element) {
        IJ2eeProject[] refProjects;
        boolean isError = false;
        String warning = "";
        this.earPrj = J2eeElementManager.getEarProject((Element)element);
        IResource res = this.earPrj.getJavaProject().getResource();
        isError = this.isResourceErroneous(res);
        if (isError) {
            warning = "\n WARNING: The project " + this.earPrj.getName() + " is erroneous!";
            boolean answer = MessageDialog.openQuestion((Shell)UIPlugin.getShell(), (String)"Warning", (String)("The project " + this.earPrj.getName() + " contains errors. Do you want to proceed anyway?"));
            if (!answer) {
                return;
            }
            tracer.warning("The project " + this.earPrj.getName() + " contain errors.");
        }
        if ((refProjects = this.earPrj.getReferencedProjects()) != null && refProjects.length > 0) {
            int i = 0;
            while (i < refProjects.length) {
                isError = false;
                res = refProjects[i].getJavaProject().getResource();
                isError = this.isResourceErroneous(res);
                if (isError) {
                    if (warning.equals("")) {
                        warning = "\n WARNING: ";
                    }
                    warning = warning + "\n The referenced project " + res.getName() + " is erroneous!";
                    boolean answer = MessageDialog.openQuestion((Shell)UIPlugin.getShell(), (String)"Warning", (String)("The referenced project " + res.getName() + " contains errors. Do you want to proceed anyway?"));
                    if (!answer) {
                        return;
                    }
                    tracer.warning("The referenced project " + res.getName() + " contain errors.");
                }
                ++i;
            }
        }
        IEarDescriptor earDescriptor = null;
        try {
            earDescriptor = BuildEar.build((IEarProject)this.earPrj, (boolean)false, (String)this.earPrj.getArchiveLocation(), (String)this.earPrj.getArchiveName());
        }
        catch (EARGenerationException e) {
            MessageDialog.openError((Shell)UIPlugin.getShell(), (String)"EAR generation failed", (String)("reason: " + e.getMessage()));
            tracer.error("", (Throwable)e);
        }
        if (earDescriptor != null) {
            if (warning.equals("")) {
                MessageDialog.openInformation((Shell)UIPlugin.getShell(), (String)"EAR Generation", (String)"EAR generation has finished successfully.");
            } else {
                MessageDialog.openWarning((Shell)UIPlugin.getShell(), (String)"EAR Generation", (String)("EAR generation has finished successfully." + warning));
            }
        }
    }

    private boolean hasValidDescriptor(IEarProject earProject) {
        if (!earProject.hasValidDescriptor()) {
            return false;
        }
        IEjbModule[] ejbModules = earProject.getReferencedEjbModules();
        int i = 0;
        while (i < ejbModules.length) {
            if (!ejbModules[i].hasValidDescriptor()) {
                return false;
            }
            ++i;
        }
        IWebModule[] webModules = earProject.getReferencedWebModules();
        int i2 = 0;
        while (i2 < webModules.length) {
            if (!webModules[i2].hasValidDescriptor()) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private boolean isResourceErroneous(IResource res) {
        boolean result = false;
        try {
            IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            if (markers != null && markers.length > 0) {
                int i = 0;
                while (i < markers.length) {
                    if (markers[i].getAttribute("severity", 0) == 2) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException ce) {
            tracer.error("The creation of EAR project " + this.earPrj.getName() + " is not possible. Reason :", (Throwable)ce);
        }
        return result;
    }

    public ICategory getCategory() {
        return this.category;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

