/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.perspective.core.action.ejb;

import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.ui.ejb.model.EjbMetaDataFactory;
import com.tssap.j2ee.ui.ejb.util.EjbUtil;
import com.tssap.j2ee.ui.perspective.core.action.ejb.AddRemoteInterfacesAction;
import com.tssap.selena.model.elements.Element;
import org.eclipse.jdt.core.IType;

public class AddRemoteInterfaceAction
extends AddRemoteInterfacesAction {
    private static final String NAME = "Remote Interface to Ejb";
    private static final String INFORMATION = "Add Remote Interface to Ejb";

    public boolean isEnabled(Element element) {
        IEnterpriseJavaBean bean = J2eeElementManager.getEnterpriseJavaBean((Element)element);
        if (bean == null) {
            return false;
        }
        IType remoteIF = bean.getRemoteInterfaceClass();
        IType homeIF = bean.getHomeInterfaceClass();
        return remoteIF == null && homeIF != null && homeIF.exists();
    }

    public void run(Element element) {
        IEnterpriseJavaBean bean = J2eeElementManager.getEnterpriseJavaBean((Element)element);
        if (bean == null) {
            AddRemoteInterfacesAction.tracer.error("Ejb no longer valid");
            return;
        }
        IType cInterface = this.openDialog(bean.getEjbModule().getProject());
        if (cInterface != null) {
            this.updateEjbJarDescriptor(bean, cInterface);
        }
    }

    String getName() {
        return NAME;
    }

    boolean checkEjbInterfaceType(IType interfaceType) {
        return EjbUtil.isRemoteIF((IType)interfaceType);
    }

    void setNewType(IEnterpriseJavaBean bean, IType interfaceType) {
        bean.setRemoteInterfaceClass(EjbMetaDataFactory.createClassDataBean((String)interfaceType.getFullyQualifiedName(), null), false);
    }
}

