/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.perspective.core.action.ejb;

import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.core.EjbUtil;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.dialog.AbstractInputDialog;
import com.tssap.j2ee.ui.ejb.components.IEjbMetaData;
import com.tssap.j2ee.ui.ejb.core.EjbInputValidator;
import com.tssap.j2ee.ui.ejb.model.EjbMetaDataFactory;
import com.tssap.j2ee.ui.perspective.core.action.AbstractRenameElementAction;
import com.tssap.j2ee.ui.util.vcs.dtr.DTRUtils;
import com.tssap.j2ee.util.jdt.JDTUtils;
import com.tssap.selena.model.elements.Element;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractRenameEjbAction
extends AbstractRenameElementAction {
    private static final TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$perspective$core$action$ejb$AbstractRenameEjbAction == null ? (class$com$tssap$j2ee$ui$perspective$core$action$ejb$AbstractRenameEjbAction = AbstractRenameEjbAction.class$("com.tssap.j2ee.ui.perspective.core.action.ejb.AbstractRenameEjbAction")) : class$com$tssap$j2ee$ui$perspective$core$action$ejb$AbstractRenameEjbAction));
    protected String NAME = "Rename Ejb";
    protected IEnterpriseJavaBean ejb = null;
    protected String mFormerEjbName = null;
    protected IPackageFragment mBeanPackageFragment = null;
    protected IEjbMetaData mEjbMetaData = null;
    static /* synthetic */ Class class$com$tssap$j2ee$ui$perspective$core$action$ejb$AbstractRenameEjbAction;

    public boolean isAvailable(Element element) {
        return J2eeElementManager.isEjbModule((Element)element.getModel()) && J2eeElementManager.isEnterpriseJavaBean((Element)element);
    }

    protected boolean renameOnlyBeanclass(StringBuffer newEjbName, IEnterpriseJavaBean bean) {
        IFile[] relFiles = new IFile[2];
        try {
            relFiles[0] = this.getBeanclassFile(bean);
            relFiles[1] = this.getDescriptorFile(bean);
            if (DTRUtils.fileStateCheck((IFile[])relFiles, (String)"Rename Ejb", (IProject)bean.getEJBProject().getProject())) {
                this.ejb.setBeanClass(EjbMetaDataFactory.createClassDataBean((String)newEjbName.toString(), null));
                return true;
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)UIPlugin.getShell(), (String)"Rename EJB", (String)"Some files are corrupt");
            tracer.error("", (Throwable)e);
        }
        return false;
    }

    protected IFile getBeanclassFile(IEnterpriseJavaBean bean) throws JavaModelException, Exception {
        IFile beanclass = (IFile)bean.getBeanClass().getUnderlyingResource();
        if (beanclass == null) {
            throw new Exception("no beanclass to refactor");
        }
        return beanclass;
    }

    protected IFile getDescriptorFile(IEnterpriseJavaBean bean) throws JavaModelException, Exception {
        IFile descriptor = bean.getEjbModule().getDescriptorLocation();
        if (descriptor == null) {
            throw new Exception("no descriptor, invalid project");
        }
        return descriptor;
    }

    protected IFile[] getEjbParticipantFiles(IEnterpriseJavaBean bean) {
        IFile[] allParticipants;
        ArrayList<IFile> relatedFiles = new ArrayList<IFile>();
        IType[] types = EjbUtil.getComponentInterfaces((IEnterpriseJavaBean)bean);
        relatedFiles.addAll(Arrays.asList(JDTUtils.getFilesFromITypes((IType[])types)));
        types = EjbUtil.getHomeInterfaces((IEnterpriseJavaBean)bean);
        relatedFiles.addAll(Arrays.asList(JDTUtils.getFilesFromITypes((IType[])types)));
        try {
            allParticipants = new IFile[relatedFiles.size() + 1];
            System.arraycopy(relatedFiles.toArray(new IFile[0]), 0, allParticipants, 0, relatedFiles.size());
            allParticipants[relatedFiles.size()] = this.getBeanclassFile(bean);
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)UIPlugin.getShell(), (String)"Rename EJB", (String)"Not able to change all Files");
            tracer.error("", (Throwable)e);
            return new IFile[0];
        }
        return allParticipants;
    }

    protected boolean renameBeanAndParticipants(IEnterpriseJavaBean ejb, String newEjbName, String projectName) {
        ArrayList<IFile> relFiles = new ArrayList<IFile>();
        try {
            relFiles.add(this.getDescriptorFile(ejb));
            relFiles.addAll(Arrays.asList(this.getEjbParticipantFiles(ejb)));
            if (relFiles.size() > 0 && DTRUtils.fileStateCheck((IFile[])relFiles.toArray(new IFile[0]), (String)"Rename Ejb", (IProject)ejb.getEJBProject().getProject())) {
                ejb.setBeanClass(EjbMetaDataFactory.createClassDataBean((String)newEjbName.toString(), null));
                ejb = J2eeProjectManager.getEjbModule((String)projectName).getEnterpriseBean(newEjbName.toString());
                if (ejb == null) {
                    MessageDialog.openError((Shell)UIPlugin.getShell(), (String)"Rename EJB", (String)"Not able to rename ejb");
                    return false;
                }
                String plainName = this.getPlainEjbName(newEjbName);
                if (ejb.getHomeInterfaceClass() != null) {
                    ejb.setHomeInterfaceClass(EjbMetaDataFactory.createClassDataBean((String)(plainName + "Home"), null), true);
                    ejb.setRemoteInterfaceClass(EjbMetaDataFactory.createClassDataBean((String)plainName, null), true);
                }
                if (ejb.getLocalHomeInterfaceClass() != null) {
                    ejb.setLocalHomeInterfaceClass(EjbMetaDataFactory.createClassDataBean((String)(plainName + "LocalHome"), null), true);
                    ejb.setLocalInterfaceClass(EjbMetaDataFactory.createClassDataBean((String)(plainName + "Local"), null), true);
                }
                return true;
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)UIPlugin.getShell(), (String)"Rename EJB", (String)"Some files are corrupt");
            tracer.error("", (Throwable)e);
        }
        return false;
    }

    protected String getPlainEjbName(String newEjbName) {
        String plainName = newEjbName.substring(0, newEjbName.toString().lastIndexOf("Bean"));
        return plainName;
    }

    protected void doInitialization(Element elem) {
        this.ejb = J2eeElementManager.getEnterpriseJavaBean((Element)elem);
        this.mFormerEjbName = this.ejb.getDefaultEjbName().substring(this.ejb.getDefaultEjbName().lastIndexOf(".") + 1);
        this.mEjbMetaData = EjbMetaDataFactory.createEjbMetaDataBean();
        this.mEjbMetaData.setDefaultEjbName(this.mFormerEjbName);
        this.mEjbMetaData.setBeanclassName(this.ejb.getBeanClass().getFullyQualifiedName());
        this.mBeanPackageFragment = this.ejb.getBeanClass().getPackageFragment();
        this.mEjbMetaData.setBeanPackage(this.mBeanPackageFragment);
        this.mEjbMetaData.setEjbProjectName(this.mBeanPackageFragment.getJavaProject().getElementName());
        this.mEjbMetaData.setEjbCompliance(1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class RenameEjbDialog
    extends AbstractInputDialog {
        private Button cb_renameParticipants = null;
        private boolean renameParticipants = false;

        public RenameEjbDialog(Shell parentShell, String dialogTitle, String dialogMessage, String formerEjbName, String ejbProjectName, IPackageFragment beanClassPkg) {
            super(parentShell, dialogTitle, dialogMessage, formerEjbName, (IInputValidator)new EjbInputValidator(formerEjbName, ejbProjectName, beanClassPkg));
        }

        protected void okButtonPressed() {
            this.renameParticipants = this.cb_renameParticipants.getSelection();
        }

        protected IGridLayoutPane createMainGridLayoutPane(Composite parent) {
            IGridLayoutPane layout = PaneFactory.createGridLayoutPane((Composite)parent, (int)1);
            this.setRenameParticipantsCheckbox(layout);
            return layout;
        }

        protected void setRenameParticipantsCheckbox(IGridLayoutPane layout) {
            this.cb_renameParticipants = layout.addCheckBox("rename all participants");
        }

        protected boolean doRenameParticipants() {
            return this.renameParticipants;
        }
    }
}

