/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.ui.perspective.core.action;

import com.tssap.j2ee.model.IJ2eeProject;
import com.tssap.j2ee.model.IRepresentArchive;
import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.ui.UIPlugin;
import com.tssap.j2ee.ui.core.deploy.DeployerFactory;
import com.tssap.j2ee.ui.core.deploy.DeploymentException;
import com.tssap.j2ee.ui.core.deploy.IDeployer;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.extension.action.IElementSingleAction;
import com.tssap.util.action.Category;
import com.tssap.util.action.ICategory;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import com.tssap.util.ui.dialog.UserDialog;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.widgets.Shell;

public class SDMDeployAction
implements IElementSingleAction {
    private static TracerI tracer = TracingManager.getTracer((Class)(class$com$tssap$j2ee$ui$perspective$core$action$SDMDeployAction == null ? (class$com$tssap$j2ee$ui$perspective$core$action$SDMDeployAction = SDMDeployAction.class$("com.tssap.j2ee.ui.perspective.core.action.SDMDeployAction")) : class$com$tssap$j2ee$ui$perspective$core$action$SDMDeployAction));
    private static IDeployer sdmDeployer = DeployerFactory.getSDMDeployer();
    private static final String DISPLAY_INFO = "Deploy";
    private static final String DISPLAY_NAME = "Deploy to J2EE engine";
    private static final String DESCRIPTION = "Deploy an archive with the SDM to the SAP J2EE engine";
    private final ICategory DEFAULT_CATEGORY = Category.createDisplayableCategory((ICategory)Category.OTHERS, (String)"Deploy an archive with the SDM to the SAP J2EE engine", (String)"Deploy to J2EE engine", (String)"Deploy", null);
    static /* synthetic */ Class class$com$tssap$j2ee$ui$perspective$core$action$SDMDeployAction;

    public SDMDeployAction() {
        if (sdmDeployer == null) {
            tracer.fatal("SDM deployer not available -> No deployment possible !!");
        }
    }

    public boolean isAvailable(Element element) {
        boolean availableFlag = false;
        if (J2eeElementManager.isEarProject((Element)element.getModel()) && J2eeElementManager.isEarArchive((Element)element) || J2eeElementManager.isJ2EEServiceProject((Element)element.getModel()) && J2eeElementManager.isJ2eeServiceArchive((Element)element) || J2eeElementManager.isJ2EELibraryProject((Element)element.getModel()) && J2eeElementManager.isJ2eeLibraryArchive((Element)element)) {
            availableFlag = true;
        }
        return availableFlag;
    }

    public boolean isEnabled(Element element) {
        boolean enabledFlag = false;
        IFile archiveFile = this.getArchiveFile(element);
        if (archiveFile != null && sdmDeployer.canDeployAsync(archiveFile)) {
            enabledFlag = true;
        }
        return enabledFlag;
    }

    public void run(Element element) {
        IFile archiveFile = this.getArchiveFile(element);
        if (sdmDeployer != null) {
            if (sdmDeployer.canDeployAsync(archiveFile)) {
                try {
                    sdmDeployer.deployAsync(archiveFile, tracer);
                }
                catch (DeploymentException ex) {
                    UserDialog.openError((Shell)UIPlugin.getShell(), (String)"Could not deploy succesfully", (String)("The deployment of the archive failed with an exception !\n(" + ex.getMessage() + ")" + "\nPlease check the error log for further informations."));
                    tracer.error("", (Throwable)ex);
                }
            } else {
                UserDialog.openError((Shell)UIPlugin.getShell(), (String)"Cannot deploy", (String)"The deployment of the archive is already running !\nPlease wait until it is finished (watch the Deploy Output View).");
            }
        }
    }

    public ICategory getCategory() {
        return this.DEFAULT_CATEGORY;
    }

    private IFile getArchiveFile(Element element) {
        IFile archiveFile = null;
        IJ2eeProject prj = J2eeElementManager.getJ2eeProject((Element)element.getModel());
        if (prj instanceof IRepresentArchive) {
            IRepresentArchive archivePrj = (IRepresentArchive)prj;
            archiveFile = archivePrj.getArchiveLocationFullPath();
            if (!archiveFile.exists()) {
                tracer.error("Problems during deployment, archive file does not exist !");
            }
        } else {
            tracer.error("Can not deploy: no valid archive-project !");
        }
        return archiveFile;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

