/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.api.awt.gui.panel;

import com.sap.ip.me.mdk.api.awt.gui.layout.TableLayout;
import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;

public class HeaderPanel
extends Panel {
    private static Image image = null;
    private static Label userName = null;
    private static Font textFont = Utilities.fntBold11Dialog;
    private static Color bgColor = Utilities.lightYellowColor;

    public HeaderPanel(Image img) {
        image = img;
        double border = 1.0;
        double[][] size = new double[][]{{0.4, -1.0}, {-1.0, border}};
        this.setLayout(new TableLayout(size));
        this.setBackground(bgColor);
        if (image != null) {
            this.ensureImageLoaded(image);
        }
    }

    public void setWelcomeText(String info) {
        userName = new Label(info, 2);
        userName.setForeground(Color.black);
        userName.setFont(textFont);
        this.add((Component)userName, "1,0");
    }

    private final void ensureImageLoaded(Image image) {
        try {
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.isShowing()) {
            if (image != null) {
                int xPos = 1;
                int yPos = 1;
                g.drawImage(image, xPos, yPos, this);
            }
            g.setColor(Color.gray);
            g.drawLine(0, this.getSize().height - 1, this.getSize().width, this.getSize().height - 1);
        }
    }

    public void setIcon(String icon) {
        image = Utilities.getImage(icon);
    }
}

