/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.api.awt.gui.component;

import com.sap.ip.me.mdk.api.awt.gui.component.TextLabel;
import com.sap.ip.me.mdk.api.awt.gui.layout.ParagraphLayout;
import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Panel;

public class ListPanel
extends Panel {
    private boolean bDrawBorder = true;
    private boolean bDrawBackGround = true;
    protected Color bgColor = Utilities.menuBodyBGColor;
    private String lineMask = "TBLR";

    public ListPanel() {
        this(null, null);
    }

    public ListPanel(Component[] left, Component[] right) {
        super(new ParagraphLayout(2, 2, 2, 0, 0, 0));
        this.setList(left, right);
    }

    public void appendLine(Component l) {
        this.appendLine((Component)new TextLabel(""), l);
    }

    public void appendLine(Component l, Component[] r) {
        this.add(l, ParagraphLayout.NEW_PARAGRAPH);
        if (r != null) {
            int i = 0;
            while (i < r.length) {
                this.add(r[i]);
                ++i;
            }
        }
        this.invalidate();
        this.repaint();
    }

    public void appendLine(Component l, Component r) {
        this.add(l, ParagraphLayout.NEW_PARAGRAPH);
        if (r != null) {
            this.add(r);
        }
        this.validate();
    }

    public void setList(Component[] l, Component[] r) {
        if (l == null || r == null) {
            return;
        }
        int len = l.length < r.length ? l.length : r.length;
        int i = 0;
        while (i < len) {
            this.appendLine(l[i], r[i]);
            ++i;
        }
    }

    public void enableBackground(boolean state) {
        this.bDrawBackGround = state;
    }

    public void enableBorder(boolean state) {
        this.bDrawBorder = state;
    }

    public void setBorderMask(String mask) {
        this.lineMask = mask;
        this.repaint();
    }

    public void paint(Graphics g) {
        if (this.bDrawBackGround) {
            g.setColor(this.bgColor);
            g.fillRect(1, 1, this.getSize().width, this.getSize().height);
        }
        if (this.bDrawBorder) {
            g.setColor(Color.gray);
            if (this.lineMask.indexOf("T") > -1) {
                this.drawTopLine(g);
            }
            if (this.lineMask.indexOf("B") > -1) {
                this.drawBottomLine(g);
            }
            if (this.lineMask.indexOf("R") > -1) {
                this.drawRightLine(g);
            }
            if (this.lineMask.indexOf("L") > -1) {
                this.drawLeftLine(g);
            }
        }
        super.paint(g);
    }

    private void drawTopLine(Graphics g) {
        g.drawLine(0, 0, this.getSize().width, 0);
    }

    private void drawBottomLine(Graphics g) {
        g.drawLine(0, this.getSize().height - 1, this.getSize().width, this.getSize().height - 1);
    }

    private void drawLeftLine(Graphics g) {
        g.drawLine(0, 0, 0, this.getSize().height - 1);
    }

    private void drawRightLine(Graphics g) {
        g.drawLine(this.getSize().width - 1, 0, this.getSize().width - 1, this.getSize().height);
    }
}

