/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.api.awt.gui.component;

import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

public class LinkButton
extends Component {
    private String label;
    private String targetPage;
    private String targetHandler;
    private boolean mouseIsIn = false;
    private boolean mouseIsDown = false;
    private static Cursor handCur = new Cursor(12);
    private static Cursor arrowCur = new Cursor(0);
    private static Cursor hourCur = new Cursor(3);
    private static Cursor defCur = arrowCur;
    transient ActionListener actionListener;
    private Color textColor = Utilities.linkTextColor;
    private Image image = null;
    private Image image1 = null;
    private Image image2 = null;
    private Font textFont = Utilities.fntBold10Dialog;

    public LinkButton(String label, Image image, Image image2) {
        this.label = label;
        this.image1 = image;
        this.image2 = image2;
        this.image = this.image1;
        this.enableEvents(16L);
    }

    public LinkButton(String lab, Image eImage) {
        this(lab, eImage, null);
    }

    public LinkButton(Image eImage, Image dImage) {
        this(null, eImage, dImage);
    }

    public LinkButton(String label) {
        this(label, null, null);
    }

    public LinkButton(Image image) {
        this(null, image, null);
    }

    public void showWaitCursor() {
        this.setCursor(hourCur);
    }

    public void showDefaultCursor() {
        this.setCursor(defCur);
        this.validate();
    }

    public void addNotify() {
        super.addNotify();
        Dimension d = this.getSize();
        if (d.width == 0 || d.height == 0) {
            this.setSize(this.figureMySize(this.getGraphics()));
        }
    }

    protected Dimension figureMySize(Graphics g) {
        int width = 18;
        int height = 14;
        if (g != null) {
            FontMetrics fm = g.getFontMetrics();
            if (this.label != null) {
                height = fm.getHeight();
                width = Utilities.pixelsWideForString(this.label, fm) + 6;
            }
            if (this.image != null) {
                int imgHeight;
                int imgWidth = this.image.getWidth(this);
                imgWidth += 4;
                if (this.label != null && this.label.length() > 0) {
                    width += imgWidth;
                }
                height = height > (imgHeight = this.image.getHeight(this)) ? height : imgHeight;
            }
        }
        return new Dimension(width, height);
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String newLabel) {
        this.invalidate();
        this.label = newLabel;
        this.validate();
        this.repaint();
    }

    public void setImage(Image img) {
        this.image = img;
        this.validate();
        this.repaint();
    }

    public void setEnabled(boolean state) {
        if (this.image2 != null) {
            if (state) {
                this.setImage(this.image1);
            } else {
                this.setImage(this.image2);
            }
        }
        super.setEnabled(state);
    }

    public void setTargetPage(String command) {
        this.targetPage = command;
    }

    public String getTargetPage() {
        return this.targetPage == null ? this.label : this.targetPage;
    }

    public void setTargetHandler(String handler) {
        this.targetHandler = handler;
    }

    public String getTargetHandler() {
        return this.targetHandler;
    }

    public synchronized void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processActionEvent(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }

    public void paint(Graphics g) {
        if (this.isShowing()) {
            if (!this.isEnabled()) {
                this.mouseIsIn = false;
                this.mouseIsDown = false;
            }
            int imgPosX = 0;
            int imgPosY = 0;
            int txtPosX = 0;
            int txtPosY = 0;
            int elWidth = 0;
            int elHeight = 0;
            FontMetrics fm = g.getFontMetrics();
            if (this.image != null && (this.label == null || this.label.length() == 0)) {
                elWidth = this.image.getWidth(this);
                elHeight = this.image.getHeight(this);
                imgPosX = (this.getSize().width - elWidth) / 2;
                imgPosY = (this.getSize().height - elHeight) / 2;
            } else if (this.image != null && this.label != null && this.label.length() > 0) {
                elWidth = this.image.getWidth(this) + fm.stringWidth(this.label) - 4;
                elHeight = this.image.getHeight(this);
                imgPosX = (this.getSize().width - elWidth) / 2;
                imgPosY = (this.getSize().height - elHeight) / 2;
                txtPosX = imgPosX + this.image.getWidth(this) + 2;
                txtPosY = (this.getSize().height + 2 + fm.getHeight()) / 2 - fm.getAscent() / 2;
            } else if (this.image == null && this.label != null && this.label.length() > 0) {
                elWidth = fm.stringWidth(this.label);
                elHeight = fm.getHeight();
                txtPosX = (this.getSize().width - elWidth) / 2 + fm.getLeading() + 2;
                txtPosY = (this.getSize().height + fm.getHeight()) / 2 - fm.getAscent() / 2;
            }
            if (this.image != null) {
                g.drawImage(this.image, imgPosX, imgPosY, this);
            }
            if (this.label != null && this.label.length() > 0) {
                if (this.isEnabled()) {
                    g.setColor(this.textColor == null ? this.getForeground() : this.textColor);
                } else {
                    g.setColor(Color.gray);
                }
                g.setFont(this.textFont);
                g.drawString(this.label, txtPosX, txtPosY);
            }
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return this.figureMySize(this.getGraphics());
    }

    public void processMouseEvent(MouseEvent evt) {
        if (this.isEnabled()) {
            switch (evt.getID()) {
                case 504: {
                    defCur = handCur;
                    this.mouseIsIn = true;
                    this.repaint();
                    break;
                }
                case 505: {
                    defCur = arrowCur;
                    this.mouseIsIn = false;
                    this.repaint();
                    break;
                }
                case 501: {
                    defCur = handCur;
                    this.mouseIsDown = true;
                    this.repaint();
                    break;
                }
                case 502: {
                    defCur = handCur;
                    this.mouseIsDown = false;
                    this.repaint();
                }
            }
            this.setCursor(defCur);
            super.processMouseEvent(evt);
        }
    }
}

