/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.mdk.api.awt.gui.component;

import com.sap.ip.me.mdk.api.awt.gui.component.LinkButton;
import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class InputField
extends TextField
implements TextListener {
    public boolean bNUMBER = false;
    public boolean btnsEnabled = false;
    private LinkButton[] linkButtons = null;
    private int MAXCHARCOUNT = 255;
    private String goodText = null;

    public InputField(int width, int maxCount) {
        super(width);
        if (maxCount > 0) {
            this.MAXCHARCOUNT = maxCount;
        }
        this.addTextListener(this);
    }

    public void setAsNumberField() {
        this.bNUMBER = true;
    }

    public void setMandatory(LinkButton[] buttons) {
        if (buttons == null) {
            return;
        }
        this.linkButtons = buttons;
    }

    private void disableButtons() {
        if (this.linkButtons == null || !this.btnsEnabled) {
            return;
        }
        int i = 0;
        while (i < this.linkButtons.length) {
            this.linkButtons[i].setEnabled(false);
            ++i;
        }
        this.btnsEnabled = false;
    }

    private void enableButtons() {
        if (this.linkButtons == null || this.btnsEnabled) {
            return;
        }
        int i = 0;
        while (i < this.linkButtons.length) {
            this.linkButtons[i].setEnabled(true);
            ++i;
        }
        this.btnsEnabled = true;
    }

    public void textValueChanged(TextEvent textevent) {
        String s = this.getText();
        int cPos = this.getCaretPosition();
        if (s == null || s.length() == 0) {
            this.goodText = "";
            this.disableButtons();
            return;
        }
        if (s.length() > this.MAXCHARCOUNT) {
            this.setText(this.goodText);
            if (cPos > 0) {
                this.setCaretPosition(cPos - 1);
            }
            Utilities.beep();
        }
        if (this.bNUMBER && !this.isInteger(s)) {
            this.setText(this.goodText);
            if (cPos > 0) {
                this.setCaretPosition(cPos - 1);
            }
            Utilities.beep();
        }
        if (this.linkButtons != null) {
            if (this.getText().length() > 0) {
                this.enableButtons();
            } else {
                this.disableButtons();
            }
        }
        this.goodText = this.getText();
    }

    private boolean isInteger(String s) {
        try {
            int i = Integer.parseInt(s);
        }
        catch (NumberFormatException x) {
            return false;
        }
        return true;
    }

    public int getIntegerValue() {
        if (!this.bNUMBER) {
            return this.getText().hashCode();
        }
        String s = this.getText();
        if (s == null || s.length() == 0) {
            return 0;
        }
        return Integer.parseInt(s);
    }
}

