/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.user;

import com.sap.caf.mp.base.db.ICNConnectionPool;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.user.IUserContext;
import com.sap.caf.mp.core.user.UserConfig;
import com.sap.security.api.IUser;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import java.util.Locale;

public class UserContext
implements IUserContext {
    private Locale m_locale;
    private int m_userInstNr;
    private long m_userId;
    private IUser m_user;
    private String m_uniqueId;
    private ICNConnectionPool m_connectionPool;
    private UserConfig m_userConfig;

    protected UserContext(ICNConnectionPool pool, Locale locale, int userInstNr, long userId, IUser sapUser) {
        this.m_locale = locale;
        if (this.m_locale == null) {
            this.m_locale = Locale.getDefault();
        }
        this.m_userInstNr = userInstNr;
        this.m_userId = userId;
        this.m_user = sapUser;
        this.m_uniqueId = this.m_user.getUniqueID();
        this.m_connectionPool = pool;
        this.m_userConfig = new UserConfig(this.m_connectionPool, this.m_userInstNr);
    }

    protected UserContext(ICNConnectionPool pool, Locale locale, int userInstNr, long userId, String uniqueId) {
        this.m_locale = locale;
        if (this.m_locale == null) {
            this.m_locale = Locale.getDefault();
        }
        this.m_userInstNr = userInstNr;
        this.m_userId = userId;
        this.m_user = null;
        this.m_uniqueId = uniqueId;
        this.m_connectionPool = pool;
        this.m_userConfig = new UserConfig(this.m_connectionPool, this.m_userInstNr);
    }

    public int getUserInstNr() {
        return this.m_userInstNr;
    }

    public long getUserId() {
        return this.m_userId;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public String getUniqueId() {
        return this.m_uniqueId;
    }

    public IUser getSAPUser() {
        if (this.m_user != null) {
            return this.m_user;
        }
        try {
            this.m_user = UMFactory.getUserFactory().getUser(this.m_uniqueId);
            return this.m_user;
        }
        catch (UMException ex) {
            return null;
        }
    }

    public String getParameterValue(String application, String parameterName) throws EngineException, InvocationException {
        return this.m_userConfig.getParameterValue(this.m_userInstNr, this.m_userId, application, parameterName);
    }

    public void setParameterValue(String application, String parameterName, String parameterValue) throws EngineException, InvocationException {
        this.m_userConfig.setParameterValue(this.m_userInstNr, this.m_userId, application, parameterName, parameterValue);
    }

    public String removeParameterValue(String application, String parameterName) throws EngineException, InvocationException {
        return this.m_userConfig.removeParameterValue(this.m_userInstNr, this.m_userId, application, parameterName);
    }

    public boolean getParameterValueBoolean(String application, String parameterName) throws EngineException, InvocationException {
        String retVal = this.m_userConfig.getParameterValue(this.m_userInstNr, this.m_userId, application, parameterName);
        return Boolean.valueOf(retVal);
    }

    public void setParameterValueBoolean(String application, String parameterName, boolean parameterValue) throws EngineException, InvocationException {
        Boolean value = new Boolean(parameterValue);
        this.m_userConfig.setParameterValue(this.m_userInstNr, this.m_userId, application, parameterName, value.toString());
    }
}

