/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.user;

import com.sap.caf.mp.base.db.ICNConnectionPool;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.user.UserConfigCache;
import com.sap.caf.mp.core.user.UserConfigDbImpl;

public class UserConfig {
    private static final int CACHE_INVALIDATION_CYCLE = 3600000;
    private int m_installationNumber;
    private ICNConnectionPool m_connectionPool;
    private UserConfigCache m_cache;
    private UserConfigDbImpl m_userConfigDbAccess;

    protected UserConfig(ICNConnectionPool connectionPool, int instNr) {
        this.m_installationNumber = instNr;
        this.m_connectionPool = connectionPool;
        try {
            this.m_cache = UserConfigCache.getInstance(this.m_installationNumber, 3600000);
        }
        catch (InvocationException ex) {
            this.m_cache = null;
        }
        this.m_userConfigDbAccess = new UserConfigDbImpl(this.m_connectionPool);
    }

    public String getParameterValue(int instNr, long userId, String application, String parameterName) throws EngineException, InvocationException {
        String value = this.m_cache.getParameterValue(instNr, userId, application, parameterName);
        if (value == null) {
            value = this.m_userConfigDbAccess.get(instNr, userId, application, parameterName);
        }
        if (value != null && this.m_cache != null) {
            this.m_cache.setParameterValue(instNr, userId, application, parameterName, value);
        }
        return value;
    }

    public void setParameterValue(int instNr, long userId, String application, String parameterName, String parameterValue) throws EngineException, InvocationException {
        this.m_userConfigDbAccess.set(instNr, userId, application, parameterName, parameterValue);
        if (this.m_cache != null) {
            this.m_cache.setParameterValue(instNr, userId, application, parameterName, parameterValue);
        }
    }

    public String removeParameterValue(int instNr, long userId, String application, String parameterName) throws EngineException, InvocationException {
        String value = this.m_userConfigDbAccess.remove(instNr, userId, application, parameterName);
        if (this.m_cache != null) {
            this.m_cache.removeParameterValue(instNr, userId, application, parameterName);
        }
        return value;
    }

    public static void main(String[] args) {
    }
}

