/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.svc.persist;

import com.sap.caf.mp.base.db.ICNConnectionPool;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.core.svc.persist.ISystemPropertyManager;
import com.sap.caf.mp.core.svc.persist.PersistenceManagers;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class SystemPropertyManager
implements ISystemPropertyManager {
    private static final String m_stmtPropertyInsert = "INSERT INTO CAF_RT_SYSCFG(PARAM_NAME,PARAM_VALUE) VALUES(?,?)";
    private static final String m_stmtPropertySelect = "SELECT * FROM CAF_RT_SYSCFG WHERE PARAM_NAME=?";
    private static final String m_stmtPropertyUpdate = "UPDATE CAF_RT_SYSCFG SET PARAM_VALUE=? WHERE PARAM_NAME=?";
    private static final String m_stmtPropertyDelete = "DELETE FROM CAF_RT_SYSCFG WHERE PARAM_NAME=?";
    private ICNConnectionPool m_pool;

    public SystemPropertyManager(ICNConnectionPool pool) {
        this.m_pool = pool;
    }

    public void deleteValue(String name) throws EngineException {
        this.deletePropertyValue(name);
    }

    public String getValue(String name) throws EngineException {
        return this.getPropertyValue(name);
    }

    public void setValue(String name, String value) throws EngineException {
        this.modifyPropertyValue(name, value);
    }

    private boolean checkPropertyExists(String name) throws EngineException {
        Connection conn = null;
        try {
            boolean result = false;
            conn = this.m_pool.getConnection();
            PreparedStatement stmt = conn.prepareStatement(m_stmtPropertySelect);
            stmt.setString(1, name);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                result = true;
            }
            rs.close();
            stmt.close();
            conn.close();
            return result;
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            PersistenceManagers.recover(conn);
            throw new EngineException(ex);
        }
    }

    private void deletePropertyValue(String name) throws EngineException {
        Connection conn = null;
        try {
            conn = this.m_pool.getConnection();
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            PreparedStatement stmt = conn.prepareStatement(m_stmtPropertyDelete);
            stmt.setString(1, name);
            stmt.execute();
            stmt.close();
            conn.commit();
            conn.close();
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            PersistenceManagers.recoverAndClose(conn);
            throw new EngineException(ex);
        }
    }

    private String getPropertyValue(String name) throws EngineException {
        Connection conn = null;
        try {
            conn = this.m_pool.getConnection();
            PreparedStatement stmt = conn.prepareStatement(m_stmtPropertySelect);
            stmt.setString(1, name);
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) {
                rs.close();
                stmt.close();
                conn.close();
                return "";
            }
            String value = rs.getString("PARAM_VALUE");
            rs.close();
            stmt.close();
            conn.close();
            return value;
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            PersistenceManagers.recoverAndClose(conn);
            throw new EngineException(ex);
        }
    }

    private void modifyPropertyValue(String name, String value) throws EngineException {
        if ((value = value.trim()).length() == 0) {
            this.deletePropertyValue(name);
            return;
        }
        boolean exists = this.checkPropertyExists(name);
        Connection conn = null;
        try {
            conn = this.m_pool.getConnection();
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            if (exists) {
                PreparedStatement stmt = conn.prepareStatement(m_stmtPropertyUpdate);
                stmt.setString(1, value);
                stmt.setString(2, name);
                stmt.execute();
                stmt.close();
            } else {
                PreparedStatement stmt = conn.prepareStatement(m_stmtPropertyInsert);
                stmt.setString(1, name);
                stmt.setString(2, value);
                stmt.execute();
                stmt.close();
            }
            conn.commit();
            conn.close();
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            PersistenceManagers.recoverAndClose(conn);
            throw new EngineException(ex);
        }
    }
}

