/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.mp.core.svc.persist;

import com.sap.caf.mp.base.db.ICNConnectionPool;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.logging.BaseLogManager;
import com.sap.caf.mp.core.svc.persist.ILockArgument;
import com.sap.caf.mp.core.svc.persist.ILockManager;
import com.sap.caf.mp.core.svc.persist.LockArgument;
import com.sap.caf.mp.core.svc.persist.PersistenceManagers;
import com.sap.security.api.IUser;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.GregorianCalendar;
import java.util.Vector;

public class LockManager
implements ILockManager {
    private static final String TABLE_NAME_LOCK = "CAF_RT_SVCLCK";
    private static final String COLUMN_NAME_LOCK_TYPE = "LOCK_TYPE";
    private static final String COLUMN_NAME_LOCK_ARG = "LOCK_ARG";
    private static final String COLUMN_NAME_LOCK_VAL = "LOCK_VAL";
    private static final String COLUMN_NAME_LOCK_USER = "LOCK_USER";
    private static final String COLUMN_NAME_LOCK_TS = "LOCK_TS";
    private static String m_stmtInsertLock = "INSERT INTO CAF_RT_SVCLCK(LOCK_TYPE,LOCK_ARG,LOCK_VAL,LOCK_USER,LOCK_TS) VALUES (?,?,?,?,?)";
    private static String m_stmtReadLock = "SELECT * FROM CAF_RT_SVCLCK WHERE LOCK_TYPE=? AND LOCK_ARG=?;";
    private static String m_stmtDeleteLock = "DELETE FROM CAF_RT_SVCLCK WHERE LOCK_TYPE=? AND LOCK_ARG=?;";
    private static String m_stmtReadLocks = "SELECT * FROM CAF_RT_SVCLCK;";
    private static String m_stmtSelectUserLocks = "SELECT * FROM CAF_RT_SVCLCK WHERE LOCK_USER=?;";
    private ICNConnectionPool m_connectionPool;

    public LockManager(ICNConnectionPool pool) {
        this.m_connectionPool = pool;
    }

    private Connection getConnection() {
        Connection conn = null;
        try {
            conn = this.m_connectionPool.getConnection();
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
        }
        catch (Exception ex) {
            BaseLogManager.error(this.getClass(), (Exception)ex);
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return conn;
    }

    public ILockArgument testLock(int lockType, String lockArgument) throws EngineException {
        PreparedStatement stmt;
        Connection conn = this.getConnection();
        try {
            stmt = conn.prepareStatement(m_stmtReadLock);
            stmt.setInt(1, lockType);
            stmt.setString(2, lockArgument);
        }
        catch (SQLException e) {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            throw new EngineException((Exception)e);
        }
        try {
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                int lockValue = rs.getInt(COLUMN_NAME_LOCK_VAL);
                String lockUser = rs.getString(COLUMN_NAME_LOCK_USER);
                long lockTs = rs.getLong(COLUMN_NAME_LOCK_TS);
                rs.close();
                stmt.close();
                conn.close();
                return new LockArgument(lockType, lockArgument, lockValue, lockUser, lockTs);
            }
            rs.close();
            stmt.close();
            conn.close();
            return null;
        }
        catch (SQLException e1) {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            throw new EngineException((Exception)e1);
        }
    }

    public Vector getPendingLocks() throws EngineException {
        Vector<LockArgument> result = new Vector<LockArgument>();
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(m_stmtReadLocks);
        }
        catch (SQLException e) {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            throw new EngineException((Exception)e);
        }
        try {
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                int lockType = rs.getInt(COLUMN_NAME_LOCK_TYPE);
                String lockArgument = rs.getString(COLUMN_NAME_LOCK_ARG);
                int lockValue = rs.getInt(COLUMN_NAME_LOCK_VAL);
                String lockUser = rs.getString(COLUMN_NAME_LOCK_USER);
                long lockTs = rs.getLong(COLUMN_NAME_LOCK_TS);
                result.add(new LockArgument(lockType, lockArgument, lockValue, lockUser, lockTs));
            }
            rs.close();
            stmt.close();
            conn.close();
            return result;
        }
        catch (SQLException e1) {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            throw new EngineException((Exception)e1);
        }
    }

    public void unlock(ILockArgument argument) throws EngineException {
        PreparedStatement stmt;
        Connection conn = this.getConnection();
        try {
            stmt = conn.prepareStatement(m_stmtDeleteLock);
            stmt.setInt(1, argument.getLockType());
            stmt.setString(2, argument.getLockArgument());
        }
        catch (SQLException e) {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            throw new EngineException((Exception)e);
        }
        try {
            stmt.executeUpdate();
            PersistenceManagers.commit(conn);
            conn.close();
        }
        catch (SQLException e1) {
            BaseLogManager.error(this.getClass(), (Exception)e1);
            try {
                conn.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            throw new EngineException((Exception)e1);
        }
    }

    public ILockArgument lock(int lockType, String lockArgument, int lockValue, String userUniqueId) throws EngineException {
        ILockArgument argument = null;
        try {
            argument = this.internalLock(lockType, lockArgument, lockValue, userUniqueId);
            if (argument != null) {
                return argument;
            }
        }
        catch (EngineException ex) {
            // empty catch block
        }
        argument = this.testLock(lockType, lockArgument);
        if (argument != null) {
            return null;
        }
        return this.internalLock(lockType, lockArgument, lockValue, userUniqueId);
    }

    private ILockArgument internalLock(int lockType, String lockArgument, int lockValue, String userUniqueId) throws EngineException {
        Connection conn = this.getConnection();
        long now = GregorianCalendar.getInstance().getTime().getTime();
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(m_stmtInsertLock);
            stmt.setInt(1, lockType);
            stmt.setString(2, lockArgument);
            stmt.setInt(3, lockValue);
            stmt.setString(4, userUniqueId);
            stmt.setLong(5, now);
        }
        catch (SQLException e) {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                conn.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            throw new EngineException((Exception)e);
        }
        try {
            stmt.executeUpdate();
            PersistenceManagers.commit(conn);
            stmt.close();
            conn.close();
            return new LockArgument(lockType, lockArgument, lockValue, userUniqueId, now);
        }
        catch (SQLException e1) {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            throw new EngineException((Exception)e1);
        }
    }

    public Vector getPendingLocks(IUser user) throws EngineException {
        Vector<LockArgument> result = new Vector<LockArgument>();
        Connection conn = this.getConnection();
        String uniqueid = user.getUniqueID();
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(m_stmtSelectUserLocks);
            stmt.setString(1, uniqueid);
        }
        catch (SQLException e) {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            throw new EngineException((Exception)e);
        }
        try {
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                int lockType = rs.getInt(COLUMN_NAME_LOCK_TYPE);
                String lockArgument = rs.getString(COLUMN_NAME_LOCK_ARG);
                int lockValue = rs.getInt(COLUMN_NAME_LOCK_VAL);
                String lockUser = rs.getString(COLUMN_NAME_LOCK_USER);
                long lockTs = rs.getLong(COLUMN_NAME_LOCK_TS);
                result.add(new LockArgument(lockType, lockArgument, lockValue, lockUser, lockTs));
            }
            rs.close();
            stmt.close();
            conn.close();
            return result;
        }
        catch (SQLException e1) {
            try {
                conn.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            throw new EngineException((Exception)e1);
        }
    }
}

